/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.io;

import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XTruncate;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.framework.io.XOutputStreamWrapper;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UCBStreamHandler
extends URLStreamHandler {
    public static final String separator = "/ucb/";
    private XComponentContext m_xContext = null;
    private XMultiComponentFactory m_xMultiComponentFactory = null;
    private XSimpleFileAccess m_xSimpleFileAccess = null;
    private HashMap m_jarStreamMap = new HashMap(12);
    public static String m_ucbscheme;
    static /* synthetic */ Class class$com$sun$star$io$XTruncate;

    public UCBStreamHandler(XComponentContext xComponentContext, String string, XSimpleFileAccess xSimpleFileAccess) {
        LogUtils.DEBUG("UCBStreamHandler ctor, scheme = " + string);
        this.m_xContext = xComponentContext;
        m_ucbscheme = string;
        this.m_xSimpleFileAccess = xSimpleFileAccess;
    }

    public void parseURL(URL uRL, String string, int n, int n2) {
        LogUtils.DEBUG("**XUCBStreamHandler, parseURL: " + uRL + " spec: " + string + " start: " + n + " limit: " + n2);
        String string2 = uRL.getFile();
        string2 = string2 == null ? string.substring(n, n2) : string2 + string.substring(n, n2);
        LogUtils.DEBUG("**For scheme = " + m_ucbscheme);
        LogUtils.DEBUG("**Setting path = " + string2);
        this.setURL(uRL, m_ucbscheme, null, -1, null, null, string2, null, null);
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        return new UCBConnection(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getUCBStream(String string, String string2) throws IOException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            if (string2.endsWith(".jar")) {
                inputStream = (InputStream)this.m_jarStreamMap.get(string2);
                if (inputStream == null) {
                    inputStream = this.getFileStreamFromUCB(string2);
                    this.m_jarStreamMap.put(string2, inputStream);
                } else {
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException) {
                        inputStream.close();
                        inputStream = this.getFileStreamFromUCB(string2);
                        this.m_jarStreamMap.put(string2, inputStream);
                    }
                }
                inputStream2 = this.getFileStreamFromJarStream(string, inputStream);
            } else {
                String string3 = PathUtils.make_url(string2, string);
                inputStream2 = this.getFileStreamFromUCB(string3);
            }
            Object var7_7 = null;
            if (inputStream == null) return inputStream2;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                LogUtils.DEBUG("Caught exception closing stream: " + iOException.getMessage());
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return inputStream2;
        }
        catch (IOException iOException) {
            LogUtils.DEBUG("Caught exception closing stream: " + iOException.getMessage());
        }
        return inputStream2;
    }

    private InputStream getFileStreamFromJarStream(String string, InputStream inputStream) throws IOException {
        ZipInputStream zipInputStream = null;
        ZipEntry zipEntry = null;
        boolean bl = false;
        zipInputStream = new ZipInputStream(inputStream);
        while (zipInputStream.available() != 0) {
            zipEntry = zipInputStream.getNextEntry();
            if (!zipEntry.getName().equals(string)) continue;
            return zipInputStream;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getFileStreamFromUCB(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        XInputStream xInputStream = null;
        LogUtils.DEBUG("Trying to read from " + string);
        xInputStream = this.m_xSimpleFileAccess.openFileRead(string);
        LogUtils.DEBUG("sfa appeared to read file ");
        byte[][] byArrayArray = new byte[1][];
        int n = 0;
        int n2 = this.m_xSimpleFileAccess.getSize(string);
        if (n2 == 0 && xInputStream.available() > 0) {
            n2 = xInputStream.available();
        }
        LogUtils.DEBUG("size of file " + string + " is " + n2);
        LogUtils.DEBUG("available = " + xInputStream.available());
        byArrayArray[0] = new byte[n2];
        n = xInputStream.readBytes((byte[][])byArrayArray, n2);
        if (n != n2) {
            throw new IOException("Failed to read " + n2 + " bytes from XInputStream");
        }
        byteArrayInputStream = new ByteArrayInputStream(byArrayArray[0]);
        Object var8_9 = null;
        if (xInputStream == null) return byteArrayInputStream;
        try {
            xInputStream.closeInput();
            return byteArrayInputStream;
        }
        catch (Exception exception) {
            LogUtils.DEBUG("Error closing XInputStream:" + exception.getMessage());
        }
        return byteArrayInputStream;
        {
            catch (com.sun.star.io.IOException iOException) {
                LogUtils.DEBUG("caught exception " + (Object)((Object)iOException));
                throw new IOException(iOException.getMessage());
            }
            catch (com.sun.star.uno.Exception exception) {
                LogUtils.DEBUG("caught exception " + (Object)((Object)exception));
                throw new IOException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (xInputStream == null) throw throwable;
            try {
                xInputStream.closeInput();
                throw throwable;
            }
            catch (Exception exception) {
                LogUtils.DEBUG("Error closing XInputStream:" + exception.getMessage());
            }
            throw throwable;
        }
    }

    private String convertClassNameToFileName(String string) {
        return string.replace('.', File.separatorChar) + ".class";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UCBConnection
    extends URLConnection {
        public UCBConnection(URL uRL) {
            super(uRL);
        }

        public void connect() {
        }

        public InputStream getInputStream() throws IOException {
            LogUtils.DEBUG("UCBConnectionHandler GetInputStream on " + this.url);
            String string = this.url.toString();
            if (string.lastIndexOf(UCBStreamHandler.separator) == -1) {
                LogUtils.DEBUG("getInputStream straight file load");
                return UCBStreamHandler.this.getFileStreamFromUCB(string);
            }
            String string2 = string.substring(0, string.lastIndexOf(UCBStreamHandler.separator));
            String string3 = string.substring(string.lastIndexOf(UCBStreamHandler.separator) + UCBStreamHandler.separator.length());
            LogUtils.DEBUG("getInputStream, load of file from another file eg. " + string3 + " from " + string2);
            return UCBStreamHandler.this.getUCBStream(string3, string2);
        }

        public OutputStream getOutputStream() throws IOException {
            LogUtils.DEBUG("UCBConnectionHandler getOutputStream on " + this.url);
            XOutputStreamWrapper xOutputStreamWrapper = null;
            try {
                String string = this.url.toString();
                if (string.lastIndexOf(UCBStreamHandler.separator) != -1) {
                    String string2 = string.substring(0, string.lastIndexOf(UCBStreamHandler.separator));
                    String string3 = string.substring(string.lastIndexOf(UCBStreamHandler.separator) + UCBStreamHandler.separator.length());
                    if (UCBStreamHandler.this.m_xSimpleFileAccess.isReadOnly(string2)) {
                        throw new IOException("File is read only");
                    }
                    LogUtils.DEBUG("getOutputStream, create o/p  stream  for file eg. " + string2);
                    XOutputStream xOutputStream = UCBStreamHandler.this.m_xSimpleFileAccess.openFileWrite(string2);
                    XTruncate xTruncate = (XTruncate)UnoRuntime.queryInterface((Class)(class$com$sun$star$io$XTruncate == null ? (class$com$sun$star$io$XTruncate = UCBStreamHandler.class$("com.sun.star.io.XTruncate")) : class$com$sun$star$io$XTruncate), (Object)xOutputStream);
                    if (xTruncate != null) {
                        xTruncate.truncate();
                    }
                    xOutputStreamWrapper = new XOutputStreamWrapper(xOutputStream);
                }
                if (xOutputStreamWrapper == null) {
                    throw new IOException("Failed to get OutputStream for " + string);
                }
            }
            catch (CommandAbortedException commandAbortedException) {
                LogUtils.DEBUG("caught exception: " + commandAbortedException.toString() + " getting writable stream from " + this.url);
                throw new IOException(commandAbortedException.toString());
            }
            catch (com.sun.star.uno.Exception exception) {
                LogUtils.DEBUG("caught unknown exception: " + exception.toString() + " getting writable stream from " + this.url);
                throw new IOException(exception.toString());
            }
            return xOutputStreamWrapper;
        }
    }
}

