/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml;

import com.sun.xmlsearch.db.CompactEdgeFormat;
import com.sun.xmlsearch.db.FullVectorBtree;
import com.sun.xmlsearch.db.VectorBtreeParameters;
import com.sun.xmlsearch.util.Compressor;
import com.sun.xmlsearch.util.ConceptLocation;
import com.sun.xmlsearch.util.Index;
import com.sun.xmlsearch.util.IntegerArray;
import com.sun.xmlsearch.util.StreamDecompressor;
import com.sun.xmlsearch.xml.ContextTables;
import com.sun.xmlsearch.xml.qe.QueryHit;
import com.sun.xmlsearch.xml.qe.QueryHitData;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public final class XmlIndex
extends Index {
    private VectorBtreeParameters _edgesParams;
    private FullVectorBtree _edges;
    private byte[] _edge = CompactEdgeFormat.makeVector();
    private IntegerArray _contextsOffsets = new IntegerArray();
    private ContextTables _contextTables;
    protected RandomAccessFile _contextsFile = null;
    private byte[] _contextsData;
    private String[] _linkNames;

    public XmlIndex(String string, boolean bl) {
        super(string, bl);
    }

    public boolean init() throws Exception {
        if (super.init()) {
            this._edgesParams = new VectorBtreeParameters(this._schema, "EDGE", 9);
            if (!this._edgesParams.readState()) {
                this._edgesParams.setBlockSize(1024);
            }
            this._edges = new FullVectorBtree(this._edgesParams, this._update);
            if (this._contextsOffsets.cardinality() > 0) {
                this._contextsData = this.readByteArray("CONTEXTS");
                this._linkNames = (String[])this.readObject("LINKNAMES");
                this._contextTables = new ContextTables(this._contextsOffsets.toIntArray(), this._contextsData, this._linkNames);
            }
            return true;
        }
        return false;
    }

    public String[] getLinkNames() {
        return this._linkNames;
    }

    public void pruneIndex(Hashtable hashtable, Hashtable hashtable2) throws Exception {
        int n = this._documents.cardinality();
        IntegerArray integerArray = new IntegerArray(n);
        IntegerArray integerArray2 = new IntegerArray(n);
        IntegerArray integerArray3 = new IntegerArray(n);
        IntegerArray integerArray4 = new IntegerArray(n);
        this.getContextsFile();
        this._contextsOffsets.add((int)this._contextsFile.length());
        this._contextsFile.setLength(0L);
        this._contextsFile.seek(0L);
        this.getPositionsFile();
        this._microIndexOffsets.add((int)this._positionsFile.length());
        this._positionsFile.setLength(0L);
        this._positionsFile.seek(0L);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            String string = this.fetch(this._documents.at(i));
            if (hashtable.get(string) == null && hashtable2.get(string) == null) {
                System.out.println("keeping " + string);
                integerArray3.add(n2);
                n2 += this.writeOutMicroIndex(i);
                integerArray4.add(n3);
                n3 += this.writeOutContextInfo(i);
                integerArray.add(this._documents.at(i));
                integerArray2.add(this._titles.at(i));
                continue;
            }
            System.out.println("removing " + string);
            if (hashtable.get(string) == null) continue;
            this.removeSymbol(string);
        }
        this._documents = integerArray;
        this._microIndexOffsets = integerArray3;
        this._contextsOffsets = integerArray4;
        this._titles = integerArray2;
    }

    private int writeOutMicroIndex(int n) throws IOException {
        int n2 = this._microIndexOffsets.at(n);
        int n3 = this._microIndexOffsets.at(n + 1) - n2;
        this._positionsFile.write(this._positions, n2, n3);
        return n3;
    }

    private int writeOutContextInfo(int n) throws IOException {
        int n2 = this._contextsOffsets.at(n);
        int n3 = this._contextsOffsets.at(n + 1) - n2;
        this._contextsFile.write(this._contextsData, n2, n3);
        return n3;
    }

    public RandomAccessFile getContextsFile() throws IOException {
        if (this._contextsFile == null) {
            this._contextsFile = this.getRAF("CONTEXTS", this._update);
        }
        return this._contextsFile;
    }

    protected void readOffsetsTables(InputStream inputStream) throws Exception {
        super.readOffsetsTables(inputStream);
        int n = inputStream.read();
        this._contextsOffsets = new IntegerArray(this._documents.cardinality() + 1);
        StreamDecompressor streamDecompressor = new StreamDecompressor(inputStream);
        streamDecompressor.ascDecode(n, this._contextsOffsets);
    }

    public void close() throws Exception {
        if (this._contextsFile != null) {
            this._contextsFile.close();
            this._contextsFile = null;
        }
        this._edges.close();
        if (this._update) {
            this._edgesParams.updateSchema();
        }
        super.close();
    }

    public byte[] getPositions(int n) throws Exception {
        this._contextTables.setMicroindex(n);
        return super.getPositions(n);
    }

    public void resetContextSearch() {
        this._contextTables.resetContextSearch();
    }

    public ContextTables getContextInfo() {
        return this._contextTables;
    }

    public void compress(int n, int n2, ConceptLocation[] conceptLocationArray, int n3, ConceptLocation[] conceptLocationArray2, int n4, int n5, Compressor compressor) throws IOException {
        super.compress(n, n2, conceptLocationArray, n3, conceptLocationArray2, n4);
        RandomAccessFile randomAccessFile = this.getContextsFile();
        long l = randomAccessFile.length();
        randomAccessFile.seek(l);
        randomAccessFile.writeByte(n5);
        compressor.write(randomAccessFile);
        this._contextsOffsets.add((int)l);
    }

    protected void writeOutOffsets() throws IOException {
        super.writeOutOffsets();
        if (this._contextsOffsets.cardinality() > 0) {
            RandomAccessFile randomAccessFile = this.getOffsetsFile();
            Compressor compressor = new Compressor();
            int n = compressor.compressAscending(this._contextsOffsets);
            randomAccessFile.write(n);
            compressor.write(randomAccessFile);
        }
    }

    public synchronized String hitToString(QueryHit queryHit) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(queryHit.getPenalty());
        stringBuffer.append(" {");
        int[] nArray = queryHit.getMatches();
        String[] stringArray = new String[nArray.length / 2];
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[2 * i] > 0) {
                stringArray[i] = this.fetch(nArray[2 * i]);
                stringBuffer.append(stringArray[i]);
            } else {
                stringBuffer.append("--");
            }
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}\n");
        stringBuffer.append(this.documentName(queryHit.getDocument()));
        stringBuffer.append(' ');
        stringBuffer.append(queryHit.getDocument());
        stringBuffer.append(' ');
        stringBuffer.append(queryHit.getBegin());
        stringBuffer.append(' ');
        stringBuffer.append(queryHit.getEnd());
        stringBuffer.append('\n');
        this._contextTables.setMicroindex(queryHit.getDocument());
        this._contextTables.resetContextSearch();
        this._contextTables.hitLocation(stringArray, queryHit.getMatches(), stringBuffer);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public synchronized QueryHitData hitToData(QueryHit queryHit) throws Exception {
        int n;
        int[] nArray = queryHit.getMatches();
        String[] stringArray = new String[nArray.length >>> 1];
        for (n = 0; n < stringArray.length; ++n) {
            if (nArray[n << 1] <= 0) continue;
            stringArray[n] = this.fetch(nArray[n << 1]);
        }
        n = queryHit.getDocument();
        QueryHitData queryHitData = new QueryHitData(queryHit.getPenalty(), this.documentName(n), stringArray);
        this._contextTables.setMicroindex(n);
        this._contextTables.resetContextSearch();
        this._contextTables.hitLocation(stringArray, nArray, queryHitData);
        return queryHitData;
    }

    public synchronized void hitToXml(QueryHit queryHit, StringBuffer stringBuffer) throws Exception {
        stringBuffer.append("<QueryHit penalty=\"");
        stringBuffer.append(queryHit.getPenalty());
        stringBuffer.append("\" doc=\"");
        stringBuffer.append(this.documentName(queryHit.getDocument()));
        stringBuffer.append("\">");
        int[] nArray = queryHit.getMatches();
        String[] stringArray = new String[nArray.length / 2];
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[2 * i] <= 0) continue;
            stringArray[i] = this.fetch(nArray[2 * i]);
        }
        this._contextTables.setMicroindex(queryHit.getDocument());
        this._contextTables.resetContextSearch();
        this._contextTables.hitLocation(stringArray, queryHit.getMatches(), stringBuffer);
        stringBuffer.append("</QueryHit>");
    }

    public void saveLinkNames(Object[] objectArray) throws IOException {
        this.outputObject("LINKNAMES", objectArray);
    }
}

