/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mailread.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:19:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _MAILREAD_HXX
#define _MAILREAD_HXX

// include ---------------------------------------------------------------

#define _SVSTDARR_STRINGS

#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#ifndef _MENUBTN_HXX //autogen
#include <vcl/menubtn.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _SVSTDARR_HXX
#include <svtools/svstdarr.hxx>	// SvStrings
#endif

#include <svtools/svmedit.hxx>

#include <goodies/mailenum.hxx>	// MailPriority

// forward ---------------------------------------------------------------

class MailServer;

// class MailReadOnlyDialog ----------------------------------------------

class MailReadOnlyDialog : public ModalDialog
{
private:
	CancelButton	aCloseButton;
	MenuButton		aAttachButton;
	HelpButton		aHelpButton;

	FixedText		aAddressText;
	ListBox			aAddressBox;
	FixedText		aSubjectText;
	Edit			aSubjectEdit;
	FixedText		aPrioText;
	Edit			aPrioEdit;
	FixedText		aReceiptText;
	FixedBitmap		aReceiptBitmap;
	FixedText		aMessageText;
	MultiLineEdit	aMessageEdit;
	GroupBox		aTextGroup;

	MailServer*		pServer;
	Link			aOpenHdlLink;
	SvStrings		aFileList;

#if 0 // _SOLAR__PRIVATE
	DECL_LINK( SelectHdl, Button * );
#endif

public:
	MailReadOnlyDialog( Window* pParent, MailServer& rServer );
	~MailReadOnlyDialog();

	void			SetSubject( const String& rSubject )
						 { aSubjectEdit.SetText( rSubject ); }
	void			SetMessage( const String& rMessage )
						 { aMessageEdit.SetText( rMessage ); }
	void			SetPriority( MailPriority eNewPriority );
	void			SetReceipt( BOOL bReceipt );

	void			SetSenderName( const String& rSender );
	void			AppendReceiver( const String& rReceiver )
						{	aAddressBox.InsertEntry( rReceiver ); }
	void			AppendAttach( const String& rAttachFile,
								  const String& rAttachName,
								  BOOL bURL );
	String 			GetAttachFileName();

	void			SetOpenHdl( const Link& rNewLink )
						{ aOpenHdlLink = rNewLink; }
	const Link&		GetOpenHdl() const { return aOpenHdlLink; }
};

#endif

