/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dynload.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:08:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#if ! defined INCLUDED_XMLSCRIPT_DYNLOAD_HXX
#define INCLUDED_XMLSCRIPT_DYNLOAD_HXX

#include <osl/module.h>

#include <xmlscript/xmldlg_imexp.hxx>
#include <xmlscript/xmlmod_imexp.hxx>
#include <xmlscript/xmllib_imexp.hxx>

#include <tools/solar.h> // for library name macros


namespace xmlscript
{

//==================================================================================================
struct XML_script
{
    // xmldlg_imexp.hxx
    virtual void SAL_CALL exportDialogModel(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::xml::sax::XExtendedDocumentHandler > const & xOut,
        ::com::sun::star::uno::Reference<
        ::com::sun::star::container::XNameContainer > const & xDialogModel )
        SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >
    SAL_CALL importDialogModel(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::container::XNameContainer > const & xDialogModel,
        ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext > const & xContext )
        SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStreamProvider >
    SAL_CALL exportDialogModel(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::container::XNameContainer > const & xDialogModel,
        ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext > const & xContext )
        SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    virtual void SAL_CALL importDialogModel(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::io::XInputStream > xInput,
        ::com::sun::star::uno::Reference<
        ::com::sun::star::container::XNameContainer > const & xDialogModel,
        ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext > const & xContext )
        SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    // xmlmod_imexp.hxx
    virtual void SAL_CALL exportScriptModule(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::xml::sax::XExtendedDocumentHandler > const & xOut,
        const ModuleDescriptor& rMod )
		SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >
    SAL_CALL importScriptModule(
        ModuleDescriptor& rMod )
        SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    // xmllib_imexp.hxx
    virtual void SAL_CALL exportLibraryContainer(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::xml::sax::XExtendedDocumentHandler > const & xOut,
        const LibDescriptorArray* pLibArray )
		SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >
    SAL_CALL importLibraryContainer(
        LibDescriptorArray* pLibArray )
		SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    virtual void SAL_CALL exportLibrary(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::xml::sax::XExtendedDocumentHandler > const & xOut,
        const LibDescriptor& rLib )
		SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >
    SAL_CALL importLibrary(
        LibDescriptor& rLib )
		SAL_THROW( (::com::sun::star::uno::Exception) ) = 0;
};

/** Use the below like:

    static ::xmlscript::XML_script * s_xmlscript = 0;
    if (0 == s_xmlscript)
        s_xmlscript = ::xmlscript::getXmlScript();
*/
inline ::xmlscript::XML_script * getXmlScript()
{
    ::rtl::OUString lib_name( RTL_CONSTASCII_USTRINGPARAM(SVLIBRARY("xcr")) );
    oslModule module =
        osl_loadModule( lib_name.pData, SAL_LOADMODULE_LAZY | SAL_LOADMODULE_GLOBAL );
    if (0 == module)
    {
        throw ::com::sun::star::uno::RuntimeException(
            ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("cannot load library: ") ) + lib_name,
            ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >() );
    }
    ::rtl::OUString symbol_name( RTL_CONSTASCII_USTRINGPARAM("xmlscript_get") );
    typedef XML_script * (SAL_CALL * fptr_xmlscript_get)();
    fptr_xmlscript_get func =
        (fptr_xmlscript_get)osl_getSymbol( module, symbol_name.pData );
    if (0 == func)
    {
        throw ::com::sun::star::uno::RuntimeException(
            ::rtl::OUString(
                RTL_CONSTASCII_USTRINGPARAM(
                    "cannot get symbol \"xmlscript_get\" out of library ") ) + lib_name,
            ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >() );
    }
    XML_script * ret = (*func)();
    if (0 == func)
    {
        throw ::com::sun::star::uno::RuntimeException(
            ::rtl::OUString(
                RTL_CONSTASCII_USTRINGPARAM("cannot get access to xmlscript functions!") ),
            ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >() );
    }
    return ret;
}

}

#endif
