/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

class IniFile {
    String m_sFilename;
    ArrayList m_aList;
    boolean m_bListContainUnsavedChanges = false;

    public IniFile(String string) {
        this.m_sFilename = string;
        this.m_aList = this.loadLines();
    }

    ArrayList loadLines() {
        File file = new File(this.m_sFilename);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!file.exists()) {
            GlobalLogWriter.get().println("couldn't find file " + this.m_sFilename);
            return arrayList;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            String string = "";
            while (string != null) {
                string = randomAccessFile.readLine();
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            GlobalLogWriter.get().println("couldn't open file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            GlobalLogWriter.get().println("Exception occurs while reading from file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + iOException.getMessage());
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            GlobalLogWriter.get().println("Couldn't close file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + iOException.getMessage());
        }
        return arrayList;
    }

    public boolean is() {
        return this.m_aList.size() > 1;
    }

    boolean isRemark(String string) {
        return string.length() < 2 || string.startsWith("#") || string.startsWith(";");
    }

    String getItem(int n) {
        return (String)this.m_aList.get(n);
    }

    String buildSectionName(String string) {
        String string2 = "[" + string + "]";
        return string2;
    }

    String toLowerIfNeed(String string) {
        return string.toLowerCase();
    }

    int findSection(String string) {
        String string2 = this.toLowerIfNeed(this.buildSectionName(string));
        for (int i = 0; i < this.m_aList.size(); ++i) {
            String string3 = this.toLowerIfNeed(this.getItem(i).trim());
            if (this.isRemark(string3)) continue;
            if (string2.equals("[]")) {
                return i - 1;
            }
            if (!string3.startsWith(string2)) continue;
            return i;
        }
        return -1;
    }

    int findKey(String string, String string2) {
        int n = this.findSection(string);
        if (n == -1) {
            return -1;
        }
        return this.findKeyFromKnownSection(n, string2);
    }

    int findKeyFromKnownSection(int n, String string) {
        string = this.toLowerIfNeed(string);
        for (int i = n + 1; i < this.m_aList.size(); ++i) {
            String string2;
            String string3 = this.getItem(i).trim();
            if (this.isRemark(string3)) continue;
            if (string3.startsWith("[")) break;
            int n2 = string3.indexOf("=");
            if (n2 < 0 || !(string2 = this.toLowerIfNeed(string3.substring(0, n2).trim())).equals(string)) continue;
            return i;
        }
        return -1;
    }

    int findLastKnownKeyIndex(int n, String string) {
        int n2;
        string = this.toLowerIfNeed(string);
        for (int i = n2 = n + 1; i < this.m_aList.size(); ++i) {
            String string2;
            String string3 = this.getItem(i).trim();
            if (this.isRemark(string3)) continue;
            if (string3.startsWith("[")) {
                return i;
            }
            int n3 = string3.indexOf("=");
            if (n3 < 0 || !(string2 = this.toLowerIfNeed(string3.substring(0, n3).trim())).equals(string)) continue;
            return i;
        }
        return n2;
    }

    String getValue(int n) {
        String string = this.getItem(n).trim();
        if (this.isRemark(string)) {
            return "";
        }
        int n2 = string.indexOf("=");
        if (n2 >= 0) {
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1).trim();
            return string3;
        }
        return "";
    }

    public String getValue(String string, String string2) {
        String string3 = "";
        int n = this.findKey(string, string2);
        if (n == -1) {
            return "";
        }
        string3 = this.getValue(n);
        return string3;
    }

    public void store() {
        if (!this.m_bListContainUnsavedChanges) {
            return;
        }
        File file = new File(this.m_sFilename);
        if (file.exists()) {
            file.delete();
            if (file.exists()) {
                GlobalLogWriter.get().println("Couldn't delete the file " + this.m_sFilename);
                return;
            }
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            for (int i = 0; i < this.m_aList.size(); ++i) {
                String string = this.getItem(i);
                randomAccessFile.writeBytes(string);
                randomAccessFile.writeByte(10);
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            GlobalLogWriter.get().println("couldn't open file for writing " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            GlobalLogWriter.get().println("Exception occurs while writing to file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + iOException.getMessage());
        }
    }

    public void insertValue(String string, String string2, String string3) {
        int n = this.findSection(string);
        if (n == -1) {
            String string4 = this.buildSectionName(string);
            this.m_aList.add(string4);
            String string5 = string2 + "=" + string3;
            this.m_aList.add(string5);
            this.m_bListContainUnsavedChanges = true;
            return;
        }
        int n2 = this.findKeyFromKnownSection(n, string2);
        if (n2 == -1) {
            n2 = this.findLastKnownKeyIndex(n, string2);
            String string6 = string2 + "=" + string3;
            this.m_aList.add(n2, string6);
            this.m_bListContainUnsavedChanges = true;
            return;
        }
        String string7 = string2 + "=" + string3;
        this.m_aList.set(n2, string7);
        this.m_bListContainUnsavedChanges = true;
    }

    public static void main(String[] stringArray) {
        IniFile iniFile = new IniFile("/tmp/inifile");
        String string = iniFile.getValue("Section", "Key");
        iniFile.insertValue("Section", "Key2", "a new value in a existing section");
        iniFile.insertValue("Section", "Key", "replaced value");
        iniFile.insertValue("New Section", "Key", "a new key value pair");
        String string2 = iniFile.getValue("Section2", "Key");
        iniFile.store();
    }
}

