/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.classfile.ByteCode;
import org.mozilla.classfile.ClassFileField;
import org.mozilla.classfile.ClassFileMethod;
import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.ExceptionTableEntry;
import org.mozilla.classfile.JavaVariable;
import org.mozilla.javascript.LabelTable;

public class ClassFileWriter {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    private static final int LineNumberTableSize = 16;
    private static final int ExceptionTableSize = 4;
    private static final long FileHeaderConstant = -3819410108756852691L;
    private static final boolean DEBUG = true;
    private static final boolean DEBUGSTACK = false;
    private static final boolean DEBUGLABELS = false;
    private static final boolean DEBUGCODE = false;
    private static final int CodeBufferSize = 128;
    private ExceptionTableEntry[] itsExceptionTable;
    private int itsExceptionTableTop;
    private int[] itsLineNumberTable;
    private int itsLineNumberTableTop;
    private byte[] itsCodeBuffer;
    private int itsCodeBufferTop;
    private ConstantPool itsConstantPool;
    private short itsSourceFileAttributeIndex;
    private ClassFileMethod itsCurrentMethod;
    private short itsStackTop;
    private short itsMaxStack;
    private short itsMaxLocals;
    private Vector itsMethods = new Vector();
    private Vector itsFields = new Vector();
    private Vector itsInterfaces = new Vector();
    private short itsFlags;
    private short itsThisClassIndex;
    private short itsSuperClassIndex;
    private short itsSourceFileNameIndex;
    private LabelTable itsLabels = new LabelTable();

    public ClassFileWriter(String string, String string2, String string3) {
        this.itsConstantPool = new ConstantPool();
        this.itsThisClassIndex = this.itsConstantPool.addClass(string);
        this.itsSuperClassIndex = this.itsConstantPool.addClass(string2);
        if (string3 != null) {
            this.itsSourceFileNameIndex = this.itsConstantPool.addUtf8(string3);
        }
        this.itsFlags = 1;
    }

    public void addInterface(String string) {
        short s = this.itsConstantPool.addClass(string);
        this.itsInterfaces.addElement(new Short(s));
    }

    public void setFlags(short s) {
        this.itsFlags = s;
    }

    public static String fullyQualifiedForm(String string) {
        return string.replace('.', '/');
    }

    public void addField(String string, String string2, short s) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        this.itsFields.addElement(new ClassFileField(s2, s3, s));
    }

    public void addField(String string, String string2, short s, int n) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        short[] sArray = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(n)};
        this.itsFields.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void addField(String string, String string2, short s, long l) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        short[] sArray = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(l)};
        this.itsFields.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void addField(String string, String string2, short s, double d) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        short[] sArray = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(d)};
        this.itsFields.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void startMethod(String string, String string2, short s) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        this.itsCurrentMethod = new ClassFileMethod(s2, s3, s);
        this.itsMethods.addElement(this.itsCurrentMethod);
    }

    public void stopMethod(short s, JavaVariable[] javaVariableArray) {
        int n;
        int n2;
        int n3;
        short s2;
        int n4;
        if (this.itsCurrentMethod == null) {
            throw new RuntimeException("No method to stop");
        }
        this.itsLabels.fixLabelGotos(this.itsCodeBuffer);
        this.itsMaxLocals = s;
        int n5 = 0;
        if (this.itsLineNumberTable != null) {
            n5 = 8 + this.itsLineNumberTableTop * 4;
        }
        int n6 = 0;
        if (javaVariableArray != null) {
            n6 = 8 + javaVariableArray.length * 10;
        }
        int n7 = 14 + this.itsCodeBufferTop + 2 + this.itsExceptionTableTop * 8 + 2 + n5 + n6;
        byte[] byArray = new byte[n7];
        int n8 = 0;
        short s3 = this.itsConstantPool.addUtf8("Code");
        byArray[n8++] = (byte)(s3 >> 8);
        byArray[n8++] = (byte)s3;
        byArray[n8++] = (byte)((n7 -= 6) >> 24);
        byArray[n8++] = (byte)(n7 >> 16);
        byArray[n8++] = (byte)(n7 >> 8);
        byArray[n8++] = (byte)n7;
        byArray[n8++] = (byte)(this.itsMaxStack >> 8);
        byArray[n8++] = (byte)this.itsMaxStack;
        byArray[n8++] = (byte)(this.itsMaxLocals >> 8);
        byArray[n8++] = (byte)this.itsMaxLocals;
        byArray[n8++] = (byte)(this.itsCodeBufferTop >> 24);
        byArray[n8++] = (byte)(this.itsCodeBufferTop >> 16);
        byArray[n8++] = (byte)(this.itsCodeBufferTop >> 8);
        byArray[n8++] = (byte)this.itsCodeBufferTop;
        System.arraycopy(this.itsCodeBuffer, 0, byArray, n8, this.itsCodeBufferTop);
        n8 += this.itsCodeBufferTop;
        if (this.itsExceptionTableTop > 0) {
            byArray[n8++] = (byte)(this.itsExceptionTableTop >> 8);
            byArray[n8++] = (byte)this.itsExceptionTableTop;
            for (n4 = 0; n4 < this.itsExceptionTableTop; ++n4) {
                s2 = this.itsExceptionTable[n4].getStartPC(this.itsLabels);
                byArray[n8++] = (byte)(s2 >> 8);
                byArray[n8++] = (byte)s2;
                n3 = this.itsExceptionTable[n4].getEndPC(this.itsLabels);
                byArray[n8++] = (byte)(n3 >> 8);
                byArray[n8++] = (byte)n3;
                n2 = this.itsExceptionTable[n4].getHandlerPC(this.itsLabels);
                byArray[n8++] = (byte)(n2 >> 8);
                byArray[n8++] = (byte)n2;
                n = this.itsExceptionTable[n4].getCatchType();
                byArray[n8++] = (byte)(n >> 8);
                byArray[n8++] = (byte)n;
            }
        } else {
            byArray[n8++] = 0;
            byArray[n8++] = 0;
        }
        n4 = 0;
        if (this.itsLineNumberTable != null) {
            ++n4;
        }
        if (javaVariableArray != null) {
            ++n4;
        }
        byArray[n8++] = 0;
        byArray[n8++] = (byte)n4;
        if (this.itsLineNumberTable != null) {
            s2 = this.itsConstantPool.addUtf8("LineNumberTable");
            byArray[n8++] = (byte)(s2 >> 8);
            byArray[n8++] = (byte)s2;
            n3 = 2 + this.itsLineNumberTableTop * 4;
            byArray[n8++] = (byte)(n3 >> 24);
            byArray[n8++] = (byte)(n3 >> 16);
            byArray[n8++] = (byte)(n3 >> 8);
            byArray[n8++] = (byte)n3;
            byArray[n8++] = (byte)(this.itsLineNumberTableTop >> 8);
            byArray[n8++] = (byte)this.itsLineNumberTableTop;
            for (n2 = 0; n2 < this.itsLineNumberTableTop; ++n2) {
                byArray[n8++] = (byte)(this.itsLineNumberTable[n2] >> 24);
                byArray[n8++] = (byte)(this.itsLineNumberTable[n2] >> 16);
                byArray[n8++] = (byte)(this.itsLineNumberTable[n2] >> 8);
                byArray[n8++] = (byte)this.itsLineNumberTable[n2];
            }
        }
        if (javaVariableArray != null) {
            s2 = this.itsConstantPool.addUtf8("LocalVariableTable");
            byArray[n8++] = (byte)(s2 >> 8);
            byArray[n8++] = (byte)s2;
            n3 = javaVariableArray.length;
            n2 = 2 + n3 * 10;
            byArray[n8++] = (byte)(n2 >> 24);
            byArray[n8++] = (byte)(n2 >> 16);
            byArray[n8++] = (byte)(n2 >> 8);
            byArray[n8++] = (byte)n2;
            byArray[n8++] = (byte)(n3 >> 8);
            byArray[n8++] = (byte)n3;
            for (n = 0; n < n3; ++n) {
                JavaVariable javaVariable = javaVariableArray[n];
                int n9 = javaVariable.getStartPC();
                byArray[n8++] = (byte)(n9 >> 8);
                byArray[n8++] = (byte)n9;
                int n10 = this.itsCodeBufferTop - n9;
                byArray[n8++] = (byte)(n10 >> 8);
                byArray[n8++] = (byte)n10;
                short s4 = this.itsConstantPool.addUtf8(javaVariable.getName());
                byArray[n8++] = (byte)(s4 >> 8);
                byArray[n8++] = (byte)s4;
                String string = javaVariable.getTypeDescriptor();
                short s5 = this.itsConstantPool.addUtf8(string);
                byArray[n8++] = (byte)(s5 >> 8);
                byArray[n8++] = (byte)s5;
                short s6 = javaVariable.getJRegister();
                byArray[n8++] = (byte)(s6 >> 8);
                byArray[n8++] = (byte)s6;
            }
        }
        this.itsCurrentMethod.setCodeAttribute(byArray);
        this.itsExceptionTable = null;
        this.itsExceptionTableTop = 0;
        this.itsLineNumberTable = null;
        this.itsCodeBufferTop = 0;
        this.itsCurrentMethod = null;
        this.itsMaxStack = 0;
        this.itsStackTop = 0;
        this.itsLabels.clearLabels();
    }

    public void add(byte by) {
        if (ByteCode.opcodeCount(by) != 0) {
            throw new RuntimeException("Unexpected operands");
        }
        this.addToCodeBuffer(by);
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange(by));
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte by, int n) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange(by));
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        switch (by) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE && (n < 0 || n > 65535)) {
                    throw new RuntimeException("Bad label for branch");
                }
                int n2 = this.itsCodeBufferTop;
                this.addToCodeBuffer(by);
                if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                int n3 = n & Integer.MAX_VALUE;
                int n4 = this.itsLabels.getLabelPC(n3);
                if (n4 != -1) {
                    short s = (short)(n4 - n2);
                    this.addToCodeBuffer((byte)(s >> 8));
                    this.addToCodeBuffer((byte)s);
                    break;
                }
                this.itsLabels.addLabelFixup(n3, n2 + 1);
                this.addToCodeBuffer((byte)0);
                this.addToCodeBuffer((byte)0);
                break;
            }
            case 16: {
                if (n < -128 || n > 127) {
                    throw new RuntimeException("out of range byte");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case 17: {
                if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                    throw new RuntimeException("out of range short");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -68: {
                if (n < 0 || n > 255) {
                    throw new RuntimeException("out of range index");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -76: 
            case -75: {
                if (n < 0 || n > 65535) {
                    throw new RuntimeException("out of range field");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (n < 0 || n > 65535) {
                    throw new RuntimeException("out of range index");
                }
                if (n >= 256 || by == 19 || by == 20) {
                    if (by == 18) {
                        this.addToCodeBuffer((byte)19);
                    } else {
                        this.addToCodeBuffer(by);
                    }
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (n < 0 || n > 65535) {
                    throw new RuntimeException("out of range variable");
                }
                if (n >= 256) {
                    this.addToCodeBuffer((byte)-60);
                    this.addToCodeBuffer(by);
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected opcode for 1 operand");
            }
        }
    }

    public void addLoadConstant(int n) {
        this.add((byte)18, this.itsConstantPool.addConstant(n));
    }

    public void addLoadConstant(long l) {
        this.add((byte)20, this.itsConstantPool.addConstant(l));
    }

    public void addLoadConstant(float f) {
        this.add((byte)18, this.itsConstantPool.addConstant(f));
    }

    public void addLoadConstant(double d) {
        this.add((byte)20, this.itsConstantPool.addConstant(d));
    }

    public void addLoadConstant(String string) {
        this.add((byte)18, this.itsConstantPool.addConstant(string));
    }

    public void add(byte by, int n, int n2) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange(by));
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        if (by == -124) {
            if (n < 0 || n > 65535) {
                throw new RuntimeException("out of range variable");
            }
            if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                throw new RuntimeException("out of range increment");
            }
            if (n > 255 || n2 < -128 || n2 > 127) {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                this.addToCodeBuffer((byte)(n2 >> 8));
                this.addToCodeBuffer((byte)n2);
            } else {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)n);
                this.addToCodeBuffer((byte)n2);
            }
        } else if (by == -59) {
            if (n < 0 || n > 65535) {
                throw new RuntimeException("out of range index");
            }
            if (n2 < 0 || n2 > 255) {
                throw new RuntimeException("out of range dimensions");
            }
            this.addToCodeBuffer((byte)-59);
            this.addToCodeBuffer((byte)(n >> 8));
            this.addToCodeBuffer((byte)n);
            this.addToCodeBuffer((byte)n2);
        } else {
            throw new RuntimeException("Unexpected opcode for 2 operands");
        }
    }

    public void add(byte by, String string) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange(by));
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        switch (by) {
            case -69: 
            case -67: 
            case -64: 
            case -63: {
                short s = this.itsConstantPool.addClass(string);
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(s >> 8));
                this.addToCodeBuffer((byte)s);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for class reference");
            }
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte by, String string, String string2, String string3) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange(by));
        if (this.itsStackTop < 0) {
            throw new RuntimeException("After " + Integer.toHexString(by & 0xFF) + " Stack underflow");
        }
        char c = string3.charAt(0);
        int n = c == 'J' || c == 'D' ? 2 : 1;
        switch (by) {
            case -78: 
            case -76: {
                this.itsStackTop = (short)(this.itsStackTop + n);
                break;
            }
            case -77: 
            case -75: {
                this.itsStackTop = (short)(this.itsStackTop - n);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for field reference");
            }
        }
        short s = this.itsConstantPool.addFieldRef(string, string2, string3);
        this.addToCodeBuffer(by);
        this.addToCodeBuffer((byte)(s >> 8));
        this.addToCodeBuffer((byte)s);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte by, String string, String string2, String string3, String string4) {
        int n = this.sizeOfParameters(string3);
        this.itsStackTop = (short)(this.itsStackTop - (n & 0xFFFF));
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange(by));
        if (this.itsStackTop < 0) {
            throw new RuntimeException("After " + Integer.toHexString(by & 0xFF) + " Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        switch (by) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                char c = string4.charAt(0);
                if (c != 'V') {
                    this.itsStackTop = c == 'J' || c == 'D' ? (short)(this.itsStackTop + 2) : (short)(this.itsStackTop + 1);
                }
                this.addToCodeBuffer(by);
                if (by == -71) {
                    short s = this.itsConstantPool.addInterfaceMethodRef(string, string2, string3 + string4);
                    this.addToCodeBuffer((byte)(s >> 8));
                    this.addToCodeBuffer((byte)s);
                    this.addToCodeBuffer((byte)((n >> 16) + 1));
                    this.addToCodeBuffer((byte)0);
                    break;
                }
                short s = this.itsConstantPool.addMethodRef(string, string2, string3 + string4);
                this.addToCodeBuffer((byte)(s >> 8));
                this.addToCodeBuffer((byte)s);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for method reference");
            }
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public int acquireLabel() {
        return this.itsLabels.acquireLabel() | Integer.MIN_VALUE;
    }

    public void markLabel(int n) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad label, no biscuit");
        }
        this.itsLabels.markLabel(n & Integer.MAX_VALUE, this.itsCodeBufferTop);
    }

    public void markLabel(int n, short s) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad label, no biscuit");
        }
        this.itsStackTop = s;
        this.itsLabels.markLabel(n & Integer.MAX_VALUE, this.itsCodeBufferTop);
    }

    public void markHandler(int n) {
        this.itsStackTop = 1;
        this.markLabel(n);
    }

    public int getCurrentCodeOffset() {
        return this.itsCodeBufferTop;
    }

    public short getStackTop() {
        return this.itsStackTop;
    }

    public void adjustStackTop(int n) {
        this.itsStackTop = (short)(this.itsStackTop + n);
        if (this.itsStackTop < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void addToCodeBuffer(byte by) {
        if (this.itsCurrentMethod == null) {
            throw new RuntimeException("No method to add to");
        }
        if (this.itsCodeBuffer == null) {
            this.itsCodeBuffer = new byte[128];
            this.itsCodeBuffer[0] = by;
            this.itsCodeBufferTop = 1;
        } else {
            if (this.itsCodeBufferTop == this.itsCodeBuffer.length) {
                byte[] byArray = this.itsCodeBuffer;
                this.itsCodeBuffer = new byte[this.itsCodeBufferTop * 2];
                System.arraycopy(byArray, 0, this.itsCodeBuffer, 0, this.itsCodeBufferTop);
            }
            this.itsCodeBuffer[this.itsCodeBufferTop++] = by;
        }
    }

    public void addExceptionHandler(int n, int n2, int n3, String string) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad startLabel");
        }
        if ((n2 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad endLabel");
        }
        if ((n3 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad handlerLabel");
        }
        ExceptionTableEntry exceptionTableEntry = new ExceptionTableEntry(n, n2, n3, string == null ? (short)0 : this.itsConstantPool.addClass(string));
        if (this.itsExceptionTable == null) {
            this.itsExceptionTable = new ExceptionTableEntry[4];
            this.itsExceptionTable[0] = exceptionTableEntry;
            this.itsExceptionTableTop = 1;
        } else {
            if (this.itsExceptionTableTop == this.itsExceptionTable.length) {
                ExceptionTableEntry[] exceptionTableEntryArray = this.itsExceptionTable;
                this.itsExceptionTable = new ExceptionTableEntry[this.itsExceptionTableTop * 2];
                System.arraycopy(exceptionTableEntryArray, 0, this.itsExceptionTable, 0, this.itsExceptionTableTop);
            }
            this.itsExceptionTable[this.itsExceptionTableTop++] = exceptionTableEntry;
        }
    }

    public void addLineNumberEntry(short s) {
        if (this.itsCurrentMethod == null) {
            throw new RuntimeException("No method to stop");
        }
        if (this.itsLineNumberTable == null) {
            this.itsLineNumberTable = new int[16];
            this.itsLineNumberTable[0] = (this.itsCodeBufferTop << 16) + s;
            this.itsLineNumberTableTop = 1;
        } else {
            if (this.itsLineNumberTableTop == this.itsLineNumberTable.length) {
                int[] nArray = this.itsLineNumberTable;
                this.itsLineNumberTable = new int[this.itsLineNumberTableTop * 2];
                System.arraycopy(nArray, 0, this.itsLineNumberTable, 0, this.itsLineNumberTableTop);
            }
            this.itsLineNumberTable[this.itsLineNumberTableTop++] = (this.itsCodeBufferTop << 16) + s;
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        short s = 0;
        if (this.itsSourceFileNameIndex != 0) {
            s = this.itsConstantPool.addUtf8("SourceFile");
        }
        dataOutputStream.writeLong(-3819410108756852691L);
        this.itsConstantPool.write(dataOutputStream);
        dataOutputStream.writeShort(this.itsFlags);
        dataOutputStream.writeShort(this.itsThisClassIndex);
        dataOutputStream.writeShort(this.itsSuperClassIndex);
        dataOutputStream.writeShort(this.itsInterfaces.size());
        for (n = 0; n < this.itsInterfaces.size(); ++n) {
            dataOutputStream.writeShort(((Short)this.itsInterfaces.elementAt(n)).shortValue());
        }
        dataOutputStream.writeShort(this.itsFields.size());
        for (n = 0; n < this.itsFields.size(); ++n) {
            ((ClassFileField)this.itsFields.elementAt(n)).write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.itsMethods.size());
        for (n = 0; n < this.itsMethods.size(); ++n) {
            ((ClassFileMethod)this.itsMethods.elementAt(n)).write(dataOutputStream);
        }
        if (this.itsSourceFileNameIndex != 0) {
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(s);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(this.itsSourceFileNameIndex);
        } else {
            dataOutputStream.writeShort(0);
        }
    }

    private int getWriteSize() {
        int n;
        int n2 = 0;
        if (this.itsSourceFileNameIndex != 0) {
            this.itsConstantPool.addUtf8("SourceFile");
        }
        n2 += 8;
        n2 += this.itsConstantPool.getWriteSize();
        n2 += 2;
        n2 += 2;
        n2 += 2;
        n2 += 2;
        n2 += 2 * this.itsInterfaces.size();
        n2 += 2;
        for (n = 0; n < this.itsFields.size(); ++n) {
            n2 += ((ClassFileField)this.itsFields.elementAt(n)).getWriteSize();
        }
        n2 += 2;
        for (n = 0; n < this.itsMethods.size(); ++n) {
            n2 += ((ClassFileMethod)this.itsMethods.elementAt(n)).getWriteSize();
        }
        if (this.itsSourceFileNameIndex != 0) {
            n2 += 2;
            n2 += 2;
            n2 += 4;
            n2 += 2;
        } else {
            n2 += 2;
        }
        return n2;
    }

    public byte[] toByteArray() {
        int n = this.getWriteSize();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            this.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length != n) {
            throw new RuntimeException();
        }
        return byArray;
    }

    private int sizeOfParameters(String string) {
        if (string.charAt(0) != '(') {
            throw new RuntimeException("Bad parameter signature");
        }
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        block6: while (string.charAt(n) != ')') {
            switch (string.charAt(n)) {
                case 'D': 
                case 'J': {
                    ++n2;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    ++n3;
                    ++n;
                    continue block6;
                }
                case '[': {
                    while (string.charAt(n) == '[') {
                        ++n;
                    }
                    if (string.charAt(n) != 'L') {
                        ++n2;
                        ++n3;
                        ++n;
                        continue block6;
                    }
                }
                case 'L': {
                    ++n2;
                    ++n3;
                    while (string.charAt(n++) != ';') {
                    }
                    continue block6;
                }
            }
            throw new RuntimeException("Bad signature character");
        }
        return n3 << 16 | n2;
    }
}

