/*
 * Decompiled with CFR 0.152.
 */
package basicrunner;

import basicrunner.BasicException;
import basicrunner.BasicHandler;
import basicrunner.BasicHandlerProvider;
import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import share.DescEntry;
import share.LogWriter;

public class BasicTestCase
extends TestCase {
    public PrintWriter oLog;
    protected String objName;
    protected String implName;
    static BasicHandler oBasicHandler = null;

    public BasicTestCase(DescEntry descEntry) {
        this.objName = descEntry.entryName;
        this.implName = descEntry.longName;
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        this.oLog = printWriter;
        LogWriter logWriter = (LogWriter)((Object)printWriter);
        oBasicHandler = BasicHandlerProvider.getHandler(testParameters, logWriter);
        try {
            oBasicHandler.perform("setValue", "cBASPath = \"" + testParameters.get("BASICRESPTH") + "/\"");
            oBasicHandler.perform("setValue", "cTestDocsDir = \"" + testParameters.get("DOCPTH") + "/\"");
            oBasicHandler.perform("setValue", "CNCSTR = \"" + testParameters.get("CNCSTR") + "\"");
            if (testParameters.get("soapi.test.hidewindows") != null) {
                oBasicHandler.perform("setValue", "soapi_test_hidewindows = true");
            } else {
                oBasicHandler.perform("setValue", "soapi_test_hidewindows = false");
            }
            oBasicHandler.perform("setValue", "dbaseUrl = \"sdbc:dbase:" + testParameters.get("dbase.url") + "\"");
            oBasicHandler.perform("setValue", "flatUrl = \"sdbc:flat:" + testParameters.get("flat.url") + "\"");
            oBasicHandler.perform("setValue", "calcUrl = \"sdbc:calc:" + testParameters.get("calc.url") + "\"");
            oBasicHandler.perform("setValue", "odbcUrl = \"sdbc:odbc:" + testParameters.get("odbc.url") + "\"");
            oBasicHandler.perform("setValue", "jdbcUrl = \"jdbc:" + testParameters.get("jdbc.url") + "\"");
            oBasicHandler.perform("setValue", "jdbcUser = \"" + testParameters.get("jdbc.user") + "\"");
            oBasicHandler.perform("setValue", "jdbcPassword = \"" + testParameters.get("jdbc.password") + "\"");
            oBasicHandler.perform("setValue", "adabasUrl = \"sdbc:adabas:" + testParameters.get("adabas.url") + "\"");
            oBasicHandler.perform("setValue", "adabasUser = \"" + testParameters.get("adabas.user") + "\"");
            oBasicHandler.perform("setValue", "adabasPassword = \"" + testParameters.get("adabas.password") + "\"");
            oBasicHandler.perform("setValue", "adoUrl = \"sdbc:ado:" + testParameters.get("ado.url") + "\"");
            oBasicHandler.perform("setValue", "mozabUrl = \"sdbc:address:" + testParameters.get("mozab.url") + "\"");
        }
        catch (BasicException basicException) {
            logWriter.println(basicException.info);
            throw new RuntimeException(basicException.info);
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        boolean bl = false;
        try {
            oBasicHandler.perform("setValue", "cObjectImplementationName = \"" + this.implName + "\"");
            PropertyValue propertyValue = oBasicHandler.perform("createObject", this.objName);
            bl = (Boolean)propertyValue.Value;
            if (!bl) {
                printWriter.println("Couldn't create object");
                throw new RuntimeException("Couldn't create object");
            }
        }
        catch (BasicException basicException) {
            printWriter.println(basicException.info);
            bl = false;
            throw new RuntimeException(basicException.info);
        }
        TestEnvironment testEnvironment = new TestEnvironment(new XInterface(){});
        testEnvironment.addObjRelation("objectCreated", new Boolean(bl));
        testEnvironment.addObjRelation("BasicHandler", oBasicHandler);
        return testEnvironment;
    }

    protected void cleanupTestEnvironment(TestParameters testParameters, TestEnvironment testEnvironment, LogWriter logWriter) {
    }

    public void cleanupTestCase(TestParameters testParameters) {
        this.oLog.println("Cleaning up testcase");
        try {
            PropertyValue propertyValue = oBasicHandler.perform("disposeObject", this.objName);
        }
        catch (BasicException basicException) {
            this.oLog.println(basicException.info);
            throw new RuntimeException(basicException.info);
        }
    }
}

