/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ConvWatchCancelException;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.OfficePrint;
import convwatch.PRNCompare;
import helper.URLHelper;
import java.io.File;
import java.util.ArrayList;
import util.utils;

public class GfxCompare
extends EnhancedComplexTestCase {
    GraphicalTestArguments m_aArguments = null;

    public String[] getTestMethodNames() {
        return new String[]{"gfxcompare"};
    }

    protected Object[] mustInstalledSoftware() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("composite -version");
        arrayList.add("identify -version");
        arrayList.add("gs -version");
        return arrayList.toArray();
    }

    public void gfxcompare() {
        GlobalLogWriter.set(log);
        this.checkEnvironment(this.mustInstalledSoftware());
        this.m_aArguments = this.getGraphicalTestArguments();
        String string = (String)param.get("FILE1");
        String string2 = (String)param.get("FILE2");
        this.compare(string, string2);
    }

    String createJPEG(String string, String string2) {
        String string3;
        File file;
        String string4 = "";
        if (string.startsWith("file:///")) {
            string = FileHelper.getSystemPathFromFileURL(string);
        }
        if ((file = new File(string)).exists()) {
            string3 = file.getAbsolutePath();
            if (!string3.equals(string)) {
                string = string3;
            }
        } else {
            GlobalLogWriter.get().println("File: '" + string + "' doesn't exist.");
            return "";
        }
        string3 = FileHelper.getPath(string);
        String string5 = FileHelper.getBasename(string);
        String string6 = FileHelper.getNameNoSuffix(string5);
        String string7 = System.getProperty("file.separator");
        String string8 = utils.getUsersTempDir();
        if (this.m_aArguments.getOutputPath() != null) {
            string8 = this.m_aArguments.getOutputPath();
        }
        if (string.toLowerCase().endsWith("ps") || string.toLowerCase().endsWith("prn") || string.toLowerCase().endsWith("pdf")) {
            String[] stringArray = PRNCompare.createJPEGFromPostscript(string8, string3, string5, this.m_aArguments.getResolutionInDPI());
            string4 = stringArray[0];
        } else {
            if (string.toLowerCase().endsWith("jpg") || string.toLowerCase().endsWith("jpeg")) {
                return string;
            }
            String string9 = string3 + string7 + string5;
            String string10 = URLHelper.getFileURLFromSystemPath(string9);
            String string11 = string8 + string7 + string5;
            String string12 = URLHelper.getFileURLFromSystemPath(string11);
            String string13 = string8 + string7 + string6 + string2 + ".ps";
            String string14 = URLHelper.getFileURLFromSystemPath(string13);
            try {
                OfficePrint.printToFile(this.m_aArguments, string10, string12, string14);
                string4 = this.createJPEG(string13, string2);
            }
            catch (ConvWatchCancelException convWatchCancelException) {
                GlobalLogWriter.get().println("Exception caught, can't create:" + string14);
            }
        }
        return string4;
    }

    public String compare(String string, String string2) {
        String string3 = this.createJPEG(string, "-1");
        String string4 = this.createJPEG(string2, "-2");
        if (string3.length() > 0 && string4.length() > 0) {
            String string5 = PRNCompare.compareJPEGs(string3, string4);
            if (string5.length() > 0) {
                GlobalLogWriter.get().println("Difference created: " + string5);
            }
            return string5;
        }
        return "";
    }
}

