/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import java.util.Vector;
import lib.MultiMethodTest;
import util.AccessibilityTools;

public class _XAccessibleComponent
extends MultiMethodTest {
    public XAccessibleComponent oObj = null;
    private Rectangle bounds = null;
    private Vector KnownBounds = new Vector();
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleContext;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;

    public void _containsPoint() {
        int n;
        int n2;
        int n3;
        this.requiredMethod("getBounds()");
        boolean bl = true;
        for (n3 = 0; !this.oObj.containsPoint(new Point(n3, 0)) && n3 < this.bounds.Width; ++n3) {
        }
        if (n3 < this.bounds.Width) {
            this.log.println("Upper bound of box containsPoint point (" + n3 + ",0) - OK");
        } else {
            this.log.println("Upper bound of box containsPoint no component points - FAILED");
            bl = false;
        }
        for (n3 = 0; !this.oObj.containsPoint(new Point(n3, this.bounds.Height - 1)) && n3 < this.bounds.Width; ++n3) {
            this.log.println("containsPoint returns false for (" + n3 + "," + this.bounds.Height + ")");
        }
        if (n3 < this.bounds.Width) {
            this.log.println("Lower bound of box containsPoint point (" + n3 + "," + (this.bounds.Height - 1) + ") - OK");
        } else {
            this.log.println("Lower bound of box containsPoint no component points - FAILED");
            bl = false;
        }
        for (n2 = 0; !this.oObj.containsPoint(new Point(0, n2)) && n2 < this.bounds.Height; ++n2) {
        }
        if (n2 < this.bounds.Height) {
            this.log.println("Left bound of box containsPoint point (0," + n2 + ") - OK");
        } else {
            this.log.println("Left bound of box containsPoint no component points - FAILED");
            bl = false;
        }
        for (n2 = 0; !this.oObj.containsPoint(new Point(this.bounds.Width - 1, n2)) && n2 < this.bounds.Height; ++n2) {
        }
        if (n2 < this.bounds.Height) {
            this.log.println("Right bound of box containsPoint point (" + (this.bounds.Width - 1) + "," + n2 + ") - OK");
        } else {
            this.log.println("Right bound of box containsPoint no component points - FAILED");
            bl = false;
        }
        boolean bl2 = true;
        for (n = -1; n <= this.bounds.Width; ++n) {
            bl2 &= !this.oObj.containsPoint(new Point(n, -1));
            bl2 &= !this.oObj.containsPoint(new Point(n, this.bounds.Height + this.bounds.Y));
        }
        if (bl2) {
            this.log.println("Outer upper and lower bounds contain no component points - OK");
        } else {
            this.log.println("Outer upper and lower bounds CONTAIN some component points - FAILED");
            bl = false;
        }
        bl2 = true;
        for (n = -1; n <= this.bounds.Height; ++n) {
            bl2 &= !this.oObj.containsPoint(new Point(-1, n));
            bl2 &= !this.oObj.containsPoint(new Point(this.bounds.X + this.bounds.Width, n));
        }
        if (bl2) {
            this.log.println("Outer left and right bounds contain no component points - OK");
        } else {
            this.log.println("Outer left and right bounds CONTAIN some component points - FAILED");
            bl = false;
        }
        this.tRes.tested("containsPoint()", bl);
    }

    public void _getAccessibleAtPoint() {
        boolean bl = true;
        XAccessibleComponent[] xAccessibleComponentArray = this.getChildrenComponents();
        if (xAccessibleComponentArray.length > 0) {
            for (int i = 0; i < xAccessibleComponentArray.length; ++i) {
                XAccessible xAccessible;
                int n;
                Rectangle rectangle = xAccessibleComponentArray[i].getBounds();
                if (rectangle.X == -1) continue;
                this.log.println("Checking child with bounds (" + rectangle.X + "," + rectangle.Y + "),(" + rectangle.Width + "," + rectangle.Height + "): " + AccessibilityTools.accessibleToString(xAccessibleComponentArray[i]));
                XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleContext == null ? _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessibleContext") : class$com$sun$star$accessibility$XAccessibleContext, (Object)xAccessibleComponentArray[i]);
                boolean bl2 = xAccessibleContext.getAccessibleStateSet().contains((short)25);
                this.log.println("\tStateType containsPoint SHOWING: " + bl2);
                if (!bl2) {
                    this.log.println("Child is invisible - OK");
                    continue;
                }
                String string = "(" + rectangle.X + "," + rectangle.Y + ")";
                if (this.KnownBounds.contains(string) && bl2) {
                    this.log.println("Child is covered by another and can't be reached");
                    continue;
                }
                this.KnownBounds.add(string);
                this.log.println("finding the point which lies on the component");
                int n2 = rectangle.Width / 2;
                for (n = rectangle.Height / 2; !xAccessibleComponentArray[i].containsPoint(new Point(n2, n)) && n2 > 0 && n > 0; --n2, --n) {
                }
                if (n2 == rectangle.Width && bl2) {
                    this.log.println("Couldn't find a point with containsPoint");
                    continue;
                }
                XAccessible xAccessible2 = this.oObj.getAccessibleAtPoint(new Point(rectangle.X + n2, rectangle.Y + n));
                if (xAccessible2 == null) {
                    this.log.println("The child not found at point (" + (rectangle.X + n2) + "," + (rectangle.Y + n) + ") - FAILED");
                    bl = bl2 ? false : (bl &= true);
                } else {
                    String string2;
                    String string3;
                    int n3;
                    xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible, (Object)xAccessibleComponentArray[i]);
                    XAccessibleContext xAccessibleContext2 = (XAccessibleContext)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleContext == null ? _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessibleContext") : class$com$sun$star$accessibility$XAccessibleContext, (Object)xAccessibleComponentArray[i]);
                    this.log.println("Child found at point (" + (rectangle.X + n2) + "," + (rectangle.Y + n) + ") - OK");
                    boolean bl3 = false;
                    if (xAccessible != null) {
                        bl3 = AccessibilityTools.equals(xAccessible, xAccessible2);
                        n3 = xAccessible.getAccessibleContext().getAccessibleIndexInParent();
                        string3 = xAccessible.getAccessibleContext().getAccessibleName();
                        string2 = xAccessible.getAccessibleContext().getAccessibleDescription();
                    } else {
                        bl3 = xAccessibleContext2.getAccessibleName().equals(xAccessible2.getAccessibleContext().getAccessibleName());
                        n3 = xAccessibleContext2.getAccessibleIndexInParent();
                        string3 = xAccessibleContext2.getAccessibleName();
                        string2 = xAccessibleContext2.getAccessibleDescription();
                    }
                    if (!bl3) {
                        int n4 = xAccessible2.getAccessibleContext().getAccessibleIndexInParent();
                        if (n3 < n4) {
                            this.log.println("The children found is not the same");
                            this.log.println("The expected child " + string3);
                            this.log.print("is hidden behind the found Child ");
                            this.log.println(xAccessible2.getAccessibleContext().getAccessibleName() + " - OK");
                        } else {
                            this.log.println("The children found is not the same - FAILED");
                            this.log.println("Expected: " + string3);
                            this.log.println("Description:  " + string2);
                            this.log.println("Found: " + xAccessible2.getAccessibleContext().getAccessibleName());
                            this.log.println("Description:  " + xAccessible2.getAccessibleContext().getAccessibleDescription());
                            bl = false;
                        }
                    }
                }
                xAccessible2 = this.oObj.getAccessibleAtPoint(new Point(rectangle.X - 1, rectangle.Y - 1));
                if (xAccessible2 == null) {
                    this.log.println("No children found at point (" + (rectangle.X - 1) + "," + (rectangle.Y - 1) + ") - OK");
                    bl &= true;
                    continue;
                }
                xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible, (Object)xAccessibleComponentArray[i]);
                boolean bl4 = AccessibilityTools.equals(xAccessible, xAccessible2);
                if (!bl4) continue;
                this.log.println("The same child found outside its bounds at (" + (rectangle.X - 1) + "," + (rectangle.Y - 1) + ") - FAILED");
                bl = false;
            }
        } else {
            this.log.println("There are no children supporting XAccessibleComponent");
        }
        this.tRes.tested("getAccessibleAtPoint()", bl);
    }

    public void _getBounds() {
        boolean bl = true;
        this.bounds = this.oObj.getBounds();
        boolean bl2 = this.bounds != null && this.bounds.X >= 0 && this.bounds.Y >= 0 && this.bounds.Width > 0 && this.bounds.Height > 0;
        this.log.println("Bounds = " + (this.bounds != null ? "(" + this.bounds.X + "," + this.bounds.Y + "),(" + this.bounds.Width + "," + this.bounds.Height + ")" : "null"));
        this.tRes.tested("getBounds()", bl &= bl2);
    }

    public void _getLocation() {
        this.requiredMethod("getBounds()");
        boolean bl = true;
        Point point = this.oObj.getLocation();
        this.tRes.tested("getLocation()", bl &= point.X == this.bounds.X && point.Y == this.bounds.Y);
    }

    public void _getLocationOnScreen() {
        this.requiredMethod("getBounds()");
        XAccessibleComponent xAccessibleComponent = this.getParentComponent();
        boolean bl = true;
        Point point = this.oObj.getLocationOnScreen();
        this.log.println("Location is (" + point.X + "," + point.Y + ")");
        if (xAccessibleComponent != null) {
            Point point2 = xAccessibleComponent.getLocationOnScreen();
            this.log.println("Parent location is (" + point2.X + "," + point2.Y + ")");
            bl &= point2.X + this.bounds.X == point.X;
            bl &= point2.Y + this.bounds.Y == point.Y;
        }
        this.tRes.tested("getLocationOnScreen()", bl);
    }

    public void _getSize() {
        this.requiredMethod("getBounds()");
        boolean bl = true;
        Size size = this.oObj.getSize();
        bl &= size.Width == this.bounds.Width;
        this.tRes.tested("getSize()", bl &= size.Height == this.bounds.Height);
    }

    public void _grabFocus() {
        boolean bl = true;
        this.oObj.grabFocus();
        this.tRes.tested("grabFocus()", bl);
    }

    private XAccessibleComponent[] getChildrenComponents() {
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible, (Object)this.oObj);
        if (xAccessible == null) {
            this.log.println("Component doesn't support XAccessible.");
            return new XAccessibleComponent[0];
        }
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        int n = xAccessibleContext.getAccessibleChildCount();
        if (n > 50) {
            n = 50;
        }
        Vector<XAccessibleComponent> vector = new Vector<XAccessibleComponent>();
        for (int i = 0; i < n; ++i) {
            try {
                XAccessible xAccessible2 = xAccessibleContext.getAccessibleChild(i);
                XAccessibleContext xAccessibleContext2 = xAccessible2.getAccessibleContext();
                XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessibleComponent") : class$com$sun$star$accessibility$XAccessibleComponent, (Object)xAccessibleContext2);
                if (xAccessibleComponent == null) continue;
                vector.add(xAccessibleComponent);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return vector.toArray(new XAccessibleComponent[vector.size()]);
    }

    private XAccessibleComponent getParentComponent() {
        XAccessibleContext xAccessibleContext;
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible, (Object)this.oObj);
        if (xAccessible == null) {
            this.log.println("Component doesn't support XAccessible.");
            return null;
        }
        XAccessibleContext xAccessibleContext2 = xAccessible.getAccessibleContext();
        XAccessible xAccessible2 = xAccessibleContext2.getAccessibleParent();
        if (xAccessible2 == null) {
            this.log.println("Component has no accessible parent.");
            return null;
        }
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = _XAccessibleComponent.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent, (Object)(xAccessibleContext = xAccessible2.getAccessibleContext()));
        if (xAccessibleComponent == null) {
            this.log.println("Accessible parent doesn't support XAccessibleComponent");
            return null;
        }
        return xAccessibleComponent;
    }

    public void _getForeground() {
        int n = this.oObj.getForeground();
        this.log.println("getForeground(): " + n);
        this.tRes.tested("getForeground()", true);
    }

    public void _getBackground() {
        int n = this.oObj.getBackground();
        this.log.println("getBackground(): " + n);
        this.tRes.tested("getBackground()", true);
    }

    protected void after() {
        if (this.tEnv.getObjRelation("Destroy") != null) {
            this.disposeEnvironment();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

