/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XMultiPropertyStates;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XMultiPropertyStates
extends MultiMethodTest {
    public XMultiPropertyStates oObj = null;
    Object[] defaults = null;
    PropertyState[] states = null;
    String[] names = null;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public void before() {
        this.names = (String[])this.tEnv.getObjRelation("PropertyNames");
        if (this.names == null) {
            throw new StatusException(Status.failed("No PropertyNames given"));
        }
        this.log.println("Totally " + this.names.length + " properties encountered:");
        this.log.print("{");
        for (int i = 0; i < this.names.length; ++i) {
            this.log.print(this.names[i] + " ");
        }
        this.log.print("}");
        this.log.println("");
    }

    public void _getPropertyDefaults() {
        boolean bl = false;
        try {
            this.defaults = this.oObj.getPropertyDefaults(this.names);
            bl = this.defaults != null && this.defaults.length == this.names.length;
            this.log.println("Number of default values: " + this.defaults.length);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            this.log.println("some properties seem to be unknown: " + unknownPropertyException.toString());
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Wrapped target Exception was thrown: " + wrappedTargetException.toString());
        }
        this.tRes.tested("getPropertyDefaults()", bl);
    }

    public void _getPropertyStates() {
        boolean bl = false;
        try {
            this.states = this.oObj.getPropertyStates(this.names);
            bl = this.states != null && this.states.length == this.names.length;
            this.log.println("Number of states: " + this.states.length);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            this.log.println("some properties seem to be unknown: " + unknownPropertyException.toString());
        }
        this.tRes.tested("getPropertyStates()", bl);
    }

    public void _setPropertiesToDefault() {
        Object object;
        int n;
        this.requiredMethod("getPropertyStates()");
        String string = (String)this.tEnv.getObjRelation("allReadOnly");
        if (string != null) {
            this.log.println(string);
            this.tRes.tested("setPropertiesToDefault()", Status.skipped(true));
            return;
        }
        boolean bl = false;
        String string2 = this.names[0];
        for (n = 0; n < this.names.length; ++n) {
            if (bl || this.states[n] == PropertyState.DEFAULT_VALUE) continue;
            string2 = this.names[n];
            object = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? _XMultiPropertyStates.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, (Object)this.oObj);
            XPropertySetInfo xPropertySetInfo = object.getPropertySetInfo();
            Property property = null;
            try {
                property = xPropertySetInfo.getPropertyByName(this.names[n]);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                this.log.println("couldn't get property info: " + unknownPropertyException.toString());
                throw new StatusException(Status.failed("couldn't get property info"));
            }
            if ((property.Attributes & 0x40) == 0) continue;
            this.log.println("Property " + this.names[n] + " 'may be default' and doesn't have default value");
            bl = true;
        }
        this.log.println("The property " + string2 + " selected");
        n = 0;
        try {
            object = new String[]{string2};
            this.log.println("Setting " + string2 + " to default");
            this.oObj.setPropertiesToDefault((String[])object);
            n = this.oObj.getPropertyStates((String[])object)[0].equals(PropertyState.DEFAULT_VALUE);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            this.log.println("some properties seem to be unknown: " + unknownPropertyException.toString());
        }
        if (n == 0) {
            this.log.println("The property didn't change its state to default ...");
            if (bl) {
                this.log.println("   ... and it may be default - FAILED");
            } else {
                this.log.println("   ... but it may not be default - OK");
                n = 1;
            }
        }
        this.tRes.tested("setPropertiesToDefault()", n != 0);
    }

    public void _setAllPropertiesToDefault() {
        this.requiredMethod("setPropertiesToDefault()");
        boolean bl = true;
        try {
            this.oObj.setAllPropertiesToDefault();
        }
        catch (RuntimeException runtimeException) {
            this.log.println("Ignore Runtime Exception: " + runtimeException.getMessage());
        }
        this.log.println("Checking that all properties are now in DEFAULT state excepting may be those which 'cann't be default'");
        try {
            this.states = this.oObj.getPropertyStates(this.names);
            for (int i = 0; i < this.states.length; ++i) {
                boolean bl2 = this.states[i].equals(PropertyState.DEFAULT_VALUE);
                if (!bl2) {
                    this.log.println("Property '" + this.names[i] + "' wasn't set to default");
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? _XMultiPropertyStates.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, (Object)this.oObj);
                    XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
                    Property property = xPropertySetInfo.getPropertyByName(this.names[i]);
                    if ((property.Attributes & 0x40) != 0) {
                        this.log.println("   ... and it has MAYBEDEFAULT attribute - FAILED");
                    } else {
                        this.log.println("   ... but it has no MAYBEDEFAULT attribute - OK");
                        bl2 = true;
                    }
                }
                bl &= bl2;
            }
        }
        catch (UnknownPropertyException unknownPropertyException) {
            this.log.println("some properties seem to be unknown: " + unknownPropertyException.toString());
            bl = false;
        }
        this.tRes.tested("setAllPropertiesToDefault()", bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

