/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTableCursor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextTableCursor
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc((XInterface)this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XTextTableCursor xTextTableCursor = null;
        printWriter.println("creating a test environment");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        XTextTable xTextTable = null;
        try {
            xTextTable = SOfficeFactory.createTextTable(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, (XTextContent)xTextTable);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create TextTable : " + exception.getMessage(), exception);
        }
        xTextTableCursor = xTextTable.createCursorByCellName("A1");
        printWriter.println("creating a new environment for TextTableCursor object");
        TestEnvironment testEnvironment = new TestEnvironment((XInterface)xTextTableCursor);
        printWriter.println("adding TextDocument as mod relation to environment");
        testEnvironment.addObjRelation("TEXTDOC", this.xTextDoc);
        testEnvironment.addObjRelation("STYLENAME1", "Table");
        testEnvironment.addObjRelation("STYLENAME2", "Text");
        return testEnvironment;
    }
}

