/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiDataObject;

public abstract class MultiFileLoader
extends DataLoader {
    static final long serialVersionUID = 1521919955690157343L;

    protected MultiFileLoader(Class clazz) {
        super(clazz);
    }

    protected MultiFileLoader(String string) {
        super(string);
    }

    protected final DataObject handleFindDataObject(FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        MultiDataObject multiDataObject;
        FileObject fileObject2 = this.findPrimaryFileImpl(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        try {
            multiDataObject = this.createMultiObject(fileObject2);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            DataObject dataObject = dataObjectExistsException.getDataObject();
            if (dataObject.getLoader() != this) {
                dataObject = this.checkCollision(dataObject, fileObject);
            }
            if (!(dataObject instanceof MultiDataObject)) {
                throw dataObjectExistsException;
            }
            multiDataObject = (MultiDataObject)dataObject;
        }
        if (multiDataObject.getLoader() != this) {
            return null;
        }
        multiDataObject.markSecondaryEntriesRecognized(recognizedFiles);
        multiDataObject.registerEntry(fileObject);
        return multiDataObject;
    }

    protected abstract FileObject findPrimaryFile(FileObject var1);

    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    protected abstract MultiDataObject.Entry createPrimaryEntry(MultiDataObject var1, FileObject var2);

    protected abstract MultiDataObject.Entry createSecondaryEntry(MultiDataObject var1, FileObject var2);

    DataObject checkCollision(DataObject dataObject, FileObject fileObject) {
        FileObject fileObject2 = dataObject.getPrimaryFile();
        Set set = DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(fileObject2)));
        DataObject dataObject2 = DataObjectPool.getPOOL().find(fileObject2);
        return dataObject2;
    }

    void checkConsistency(MultiDataObject multiDataObject) {
        FileObject fileObject = multiDataObject.getPrimaryFile();
        if (fileObject.equals(this.findPrimaryFileImpl(fileObject))) {
            return;
        }
        try {
            multiDataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void checkFiles(MultiDataObject multiDataObject) {
        FileObject fileObject = multiDataObject.getPrimaryFile();
        FileObject fileObject2 = fileObject.getParent();
        FileObject[] fileObjectArray = fileObject2.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject3 = this.findPrimaryFileImpl(fileObjectArray[n]);
            if (fileObject3 == fileObject) {
                try {
                    DataObject dataObject = DataObject.find(fileObjectArray[n]);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    MultiDataObject.Entry createSecondaryEntryImpl(MultiDataObject multiDataObject, FileObject fileObject) {
        return this.createSecondaryEntry(multiDataObject, fileObject);
    }

    FileObject findPrimaryFileImpl(FileObject fileObject) {
        return this.findPrimaryFile(fileObject);
    }
}

