/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Collection;
import java.util.WeakHashMap;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;

final class ChildrenArray
extends NodeAdapter {
    private Children children;
    private Node[] nodes;
    private WeakHashMap map;

    private ChildrenArray() {
    }

    protected void finalize() {
        this.children.finalizedChildrenArray();
    }

    public static ChildrenArray create(Children children) {
        ChildrenArray childrenArray = new ChildrenArray();
        children.registerChildrenArray(childrenArray, true);
        children.callAddNotify();
        childrenArray.children = children;
        return childrenArray;
    }

    public Node[] nodes() {
        if (this.children == null) {
            return null;
        }
        if (this.nodes == null) {
            this.nodes = this.children.justComputeNodes();
            int n = 0;
            while (n < this.nodes.length) {
                this.nodes[n].addNodeListener(this);
                ++n;
            }
            this.children.registerChildrenArray(this, this.nodes.length > 0);
        }
        return this.nodes;
    }

    public void clear() {
        if (this.nodes != null) {
            int n = 0;
            while (n < this.nodes.length) {
                this.nodes[n].removeNodeListener(this);
                ++n;
            }
            this.nodes = null;
            this.children.registerChildrenArray(this, false);
        }
    }

    public void finalizeNodes() {
        WeakHashMap weakHashMap = this.map;
        if (weakHashMap != null) {
            weakHashMap.remove(null);
        }
    }

    public boolean isInitialized() {
        return this.nodes != null;
    }

    public Collection nodesFor(Children.Info info) {
        Collection collection;
        if (this.map == null) {
            this.map = new WeakHashMap(7);
        }
        if ((collection = (Collection)this.map.get(info)) == null) {
            collection = info.entry.nodes();
            info.length = collection.size();
            this.map.put(info, collection);
        }
        return collection;
    }

    public void useNodes(Children.Info info, Collection collection) {
        if (this.map == null) {
            this.map = new WeakHashMap(7);
        }
        info.length = collection.size();
        this.map.put(info, collection);
    }
}

