/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.jarpackager.api.ArchiveController;
import org.netbeans.modules.jarpackager.api.ArchiveEntry;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.api.FOArchiveEntry;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.ProgressListener;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class JarCreator {
    private static final int BLOCKSIZE = 65536;
    private static MessageFormat progressInfo;
    private static List builders;
    private List myBuilders;
    ArchiveDescriptor ad;
    HashSet listeners;
    ArchiveEntry curEntry;
    private static Map extendedProperties;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarCreator;

    public JarCreator(ArchiveDescriptor archiveDescriptor) {
        this.ad = archiveDescriptor;
        if (progressInfo == null) {
            progressInfo = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_ProgressInfo"));
        }
    }

    public void createJar(FileObject fileObject) throws IOException {
        FileLock fileLock = fileObject.lock();
        OutputStream outputStream = fileObject.getOutputStream(fileLock);
        File file = NbClassPath.toFile((FileObject)fileObject);
        try {
            this.doCreateJar(outputStream, file);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            outputStream.close();
            fileLock.releaseLock();
            throw throwable;
        }
        outputStream.close();
        fileLock.releaseLock();
    }

    public void createJar(OutputStream outputStream, File file) throws IOException {
        this.doCreateJar(outputStream, file);
    }

    public FileObject getProcessedFileObject() {
        ArchiveEntry archiveEntry = this.getProcessedEntry();
        if (archiveEntry == null || !(archiveEntry instanceof FOArchiveEntry)) {
            ContentMemberList contentMemberList = ((JarContent)this.ad).getContentList();
            if (contentMemberList.size() > 0) {
                return (FileObject)contentMemberList.get(0);
            }
            return null;
        }
        return ((FOArchiveEntry)archiveEntry).getFileObject();
    }

    public ArchiveEntry getProcessedEntry() {
        return this.curEntry;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(progressListener);
    }

    public static synchronized boolean addBuilder(ArchiveBuilder archiveBuilder) {
        return builders.contains(archiveBuilder) ? false : builders.add(archiveBuilder);
    }

    public static synchronized boolean removeBuilder(ArchiveBuilder archiveBuilder) {
        return builders.remove(archiveBuilder);
    }

    public synchronized boolean addSpecificBuilder(ArchiveBuilder archiveBuilder) {
        if (this.myBuilders == null) {
            this.myBuilders = new ArrayList();
        }
        return this.myBuilders.contains(archiveBuilder) ? false : this.myBuilders.add(archiveBuilder);
    }

    public synchronized boolean removeSpecificBuilder(ArchiveBuilder archiveBuilder) {
        return this.myBuilders == null ? false : this.myBuilders.remove(archiveBuilder);
    }

    synchronized ArchiveBuilder[] getBuilders() {
        ArrayList arrayList;
        if (this.myBuilders == null) {
            arrayList = builders;
        } else {
            arrayList = new ArrayList(builders);
            arrayList.addAll(this.myBuilders);
        }
        ArchiveBuilder[] archiveBuilderArray = new ArchiveBuilder[arrayList.size()];
        return arrayList.toArray(archiveBuilderArray);
    }

    protected void fireProgressEvent(int n, String string) {
        HashSet hashSet;
        if (this.listeners == null) {
            return;
        }
        JarCreator jarCreator = this;
        synchronized (jarCreator) {
            hashSet = (HashSet)this.listeners.clone();
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).progress(n, string);
        }
    }

    public static String getCanonicalTargetName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals("<root>")) {
            return string;
        }
        if (!string.endsWith("/")) {
            return string + "/";
        }
        return string;
    }

    private ArchiveController[] initControllers(File file, Map map) {
        Object object;
        ArchiveBuilder[] archiveBuilderArray = this.getBuilders();
        ArrayList<ArchiveController[]> arrayList = new ArrayList<ArchiveController[]>();
        int n = 0;
        while (n < archiveBuilderArray.length) {
            object = archiveBuilderArray[n].initController(file, map);
            if (object != null) {
                arrayList.add((ArchiveController[])object);
            }
            ++n;
        }
        object = new ArchiveController[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    private ArchiveMember[] processMemberSet(ArchiveDescriptor archiveDescriptor, ArchiveController[] archiveControllerArray) throws IOException {
        ContentMemberList.ArchiveMemberSetImpl archiveMemberSetImpl = new ContentMemberList.ArchiveMemberSetImpl(archiveDescriptor.getContentList());
        do {
            archiveMemberSetImpl.setUnchanged();
            int n = 0;
            while (n < archiveControllerArray.length) {
                archiveControllerArray[n].processMemberSet(archiveMemberSetImpl);
                ++n;
            }
        } while (archiveMemberSetImpl.wasChanged());
        return archiveMemberSetImpl.allMembers();
    }

    private List makeArchiveEntries(ArchiveFilter archiveFilter, ArchiveMember[] archiveMemberArray) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < archiveMemberArray.length) {
            Iterator iterator = archiveMemberArray[n].getDataObject().files().iterator();
            while (iterator.hasNext()) {
                Object object;
                FileObject fileObject = (FileObject)iterator.next();
                if (archiveFilter != null && !archiveFilter.accept(fileObject)) {
                    fileObject = null;
                } else {
                    object = archiveMemberArray[n].getFilter();
                    if (object != null && !object.accept(fileObject)) {
                        fileObject = null;
                    }
                }
                if (fileObject == null) continue;
                String string = JarCreator.getCanonicalTargetName(archiveMemberArray[n].getTargetDirectory());
                object = string == null ? new FOArchiveEntry(fileObject) : (string.equals("<root>") ? new FOArchiveEntry(fileObject, fileObject.getNameExt()) : new FOArchiveEntry(fileObject, string + fileObject.getNameExt()));
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    private void addEntries(ArchiveController[] archiveControllerArray, List list) throws IOException {
        int n = 0;
        while (n < archiveControllerArray.length) {
            ArchiveEntry[] archiveEntryArray = archiveControllerArray[n].addEntry();
            if (archiveEntryArray != null) {
                list.addAll(Arrays.asList(archiveEntryArray));
            }
            ++n;
        }
    }

    private List willPostprocess(ArchiveController[] archiveControllerArray, List list) throws IOException {
        ArrayList<ArchiveController> arrayList = null;
        ArrayList<AnnotatedEntry> arrayList2 = new ArrayList<AnnotatedEntry>();
        int n = 0;
        while (n < list.size()) {
            ArchiveEntry archiveEntry = (ArchiveEntry)list.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<ArchiveController>();
            }
            ArchiveController archiveController = null;
            ArchiveController archiveController2 = null;
            int n2 = 0;
            while (n2 < archiveControllerArray.length) {
                int n3 = archiveControllerArray[n2].willPostprocess(archiveEntry);
                switch (n3) {
                    case 1: {
                        arrayList.add(archiveControllerArray[n2]);
                        break;
                    }
                    case 2: {
                        if (archiveController != null) {
                            // empty if block
                        }
                        archiveController = archiveControllerArray[n2];
                        break;
                    }
                    case 3: {
                        if (archiveController2 != null) {
                            // empty if block
                        }
                        archiveController2 = archiveControllerArray[n2];
                    }
                }
                ++n2;
            }
            if (archiveController != null) {
                arrayList.add(0, archiveController);
            }
            if (archiveController2 != null) {
                arrayList.add(archiveController2);
            }
            ArrayList<ArchiveController> arrayList3 = null;
            if (arrayList.size() > 0) {
                arrayList3 = arrayList;
                arrayList = null;
            }
            AnnotatedEntry annotatedEntry = new AnnotatedEntry(archiveEntry, arrayList3);
            arrayList2.add(annotatedEntry);
            ++n;
        }
        return arrayList2;
    }

    boolean doCreateJar(OutputStream outputStream, File file) throws IOException {
        long l = System.currentTimeMillis();
        ArchiveController[] archiveControllerArray = this.initControllers(file, this.ad.getExtendedProperties());
        ArchiveMember[] archiveMemberArray = this.processMemberSet(this.ad, archiveControllerArray);
        List list = this.makeArchiveEntries(this.ad.getFilter(), archiveMemberArray);
        this.addEntries(archiveControllerArray, list);
        List list2 = this.willPostprocess(archiveControllerArray, list);
        Manifest manifest = this.ad.getManifest();
        JarOutputStream jarOutputStream = manifest == null ? new JarOutputStream(outputStream) : new JarOutputStream(outputStream, manifest);
        try {
            jarOutputStream.setMethod(8);
            jarOutputStream.setLevel(this.ad.getCompLevel().getValue());
            this.curEntry = null;
            BufferedInputStream bufferedInputStream = null;
            JarEntry jarEntry = null;
            long l2 = 0L;
            InputStream inputStream = null;
            long l3 = 1L;
            double d = (double)list2.size() / 100.0;
            String string = file.getAbsolutePath();
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string + "." + JarPackagerOption.singleton().getContentExt();
            File file2 = new File(string);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Object var29_25;
                Object object;
                AnnotatedEntry annotatedEntry = (AnnotatedEntry)iterator.next();
                this.curEntry = annotatedEntry.entry;
                if (this.curEntry instanceof FOArchiveEntry && (object = NbClassPath.toFile((FileObject)((FOArchiveEntry)this.curEntry).getFileObject())) != null && (file.compareTo((File)object) == 0 || file2.compareTo((File)object) == 0)) continue;
                try {
                    inputStream = this.curEntry.createInputStream();
                }
                catch (IOException iOException) {
                    JarCreator.cannotAdd(this.curEntry);
                    continue;
                }
                bufferedInputStream = new BufferedInputStream(inputStream);
                jarEntry = new JarEntry(this.curEntry.getName());
                jarOutputStream.putNextEntry(jarEntry);
                try {
                    object = bufferedInputStream;
                    if (annotatedEntry.controllers != null) {
                        int n2 = 0;
                        while (n2 < annotatedEntry.controllers.size()) {
                            ArchiveController archiveController = (ArchiveController)annotatedEntry.controllers.get(n2);
                            object = archiveController.postProcess(this.curEntry, (InputStream)object);
                            ++n2;
                        }
                    }
                    JarCreator.writeEntry(jarOutputStream, (InputStream)object);
                    var29_25 = null;
                }
                catch (Throwable throwable) {
                    var29_25 = null;
                    bufferedInputStream.close();
                    throw throwable;
                }
                bufferedInputStream.close();
                jarOutputStream.closeEntry();
                this.fireProgressEvent((int)Math.round((double)l3++ / d), progressInfo.format(new Object[]{this.curEntry.getName()}));
            }
            Object var31_27 = null;
        }
        catch (Throwable throwable) {
            Object var31_28 = null;
            jarOutputStream.finish();
            this.curEntry = null;
            throw throwable;
        }
        jarOutputStream.finish();
        this.curEntry = null;
        return true;
    }

    static void writeEntry(JarOutputStream jarOutputStream, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[65536];
        boolean bl = false;
        while (true) {
            int n = 0;
            while (n < 65536) {
                int n2 = inputStream.read(byArray, n, 65536 - n);
                if (n2 < 0) {
                    bl = true;
                    if (n <= 0) break;
                    jarOutputStream.write(byArray, 0, n);
                    break;
                }
                n += n2;
            }
            if (bl) break;
            jarOutputStream.write(byArray, 0, 65536);
        }
    }

    private static void showWarning(String string) {
        String string2 = NbBundle.getBundle((String)"org.openide.compiler.Bundle").getString("CTL_CompileTab");
        TopManager.getDefault().getStdOut().println(string);
        InputOutput inputOutput = TopManager.getDefault().getIO(string2, false);
        if (inputOutput != null) {
            inputOutput.getOut().println(string);
        }
    }

    private static void cannotAdd(ArchiveEntry archiveEntry) {
        String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_CannotAddFo"), archiveEntry.getName());
        JarCreator.showWarning(string);
    }

    public static synchronized boolean addExtendedProperty(ExtendedPropertyFactory extendedPropertyFactory) {
        String string = extendedPropertyFactory.getName();
        ExtendedPropertyFactory extendedPropertyFactory2 = extendedProperties.put(string, extendedPropertyFactory);
        return extendedPropertyFactory2 != extendedPropertyFactory;
    }

    public static synchronized boolean removeExtendedProperty(String string) {
        return extendedProperties.remove(string) != null;
    }

    static synchronized Map getExtendedProperties() {
        return new HashMap(extendedProperties);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        builders = new ArrayList();
        extendedProperties = new HashMap();
    }

    static class AnnotatedEntry {
        ArchiveEntry entry;
        List controllers;

        AnnotatedEntry(ArchiveEntry archiveEntry, List list) {
            this.entry = archiveEntry;
            this.controllers = list;
        }
    }
}

