/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.bdb.util.FastInputStream;
import com.sleepycat.bdb.util.UtfOps;
import java.io.EOFException;
import java.io.IOException;

public class TupleInput
extends FastInputStream {
    public TupleInput(byte[] buffer) {
        super(buffer);
    }

    public TupleInput(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public TupleInput(TupleOutput output) {
        super(output.getBufferBytes(), output.getBufferOffset(), output.getBufferLength());
    }

    public final String readString() throws IOException {
        byte[] buf = this.getBufferBytes();
        int off = this.getBufferOffset();
        int byteLen = UtfOps.getZeroTerminatedByteLength(buf, off);
        this.skip(byteLen + 1);
        return UtfOps.bytesToString(buf, off, byteLen);
    }

    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public final boolean readBoolean() throws IOException {
        int c = this.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c != 0;
    }

    public final byte readByte() throws IOException {
        byte val = (byte)this.readUnsignedByte();
        val = val < 0 ? (byte)(val & 0x7F) : (byte)(val | 0xFFFFFF80);
        return val;
    }

    public final short readShort() throws IOException {
        short val = (short)this.readUnsignedShort();
        val = val < 0 ? (short)(val & Short.MAX_VALUE) : (short)(val | Short.MIN_VALUE);
        return val;
    }

    public final int readInt() throws IOException {
        int val = (int)this.readUnsignedInt();
        val = val < 0 ? (val &= Integer.MAX_VALUE) : (val |= Integer.MIN_VALUE);
        return val;
    }

    public final long readLong() throws IOException {
        long val = this.readUnsignedLong();
        val = val < 0L ? (val &= Long.MAX_VALUE) : (val |= Long.MIN_VALUE);
        return val;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat((int)this.readUnsignedInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readUnsignedLong());
    }

    public final int readUnsignedByte() throws IOException {
        int c = this.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public final int readUnsignedShort() throws IOException {
        int c2;
        int c1 = this.read();
        if ((c1 | (c2 = this.read())) < 0) {
            throw new EOFException();
        }
        return c1 << 8 | c2;
    }

    public final long readUnsignedInt() throws IOException {
        long c4;
        long c3;
        long c2;
        long c1 = this.read();
        if ((c1 | (c2 = (long)this.read()) | (c3 = (long)this.read()) | (c4 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private final long readUnsignedLong() throws IOException {
        long c8;
        long c7;
        long c6;
        long c5;
        long c4;
        long c3;
        long c2;
        long c1 = this.read();
        if ((c1 | (c2 = (long)this.read()) | (c3 = (long)this.read()) | (c4 = (long)this.read()) | (c5 = (long)this.read()) | (c6 = (long)this.read()) | (c7 = (long)this.read()) | (c8 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return c1 << 56 | c2 << 48 | c3 << 40 | c4 << 32 | c5 << 24 | c6 << 16 | c7 << 8 | c8;
    }

    public final String readBytes(int length) throws IOException {
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            int c = this.read();
            if (c < 0) {
                throw new EOFException();
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public final String readChars(int length) throws IOException {
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            buf.append(this.readChar());
        }
        return buf.toString();
    }

    public final void readBytes(char[] chars) throws IOException {
        for (int i = 0; i < chars.length; ++i) {
            int c = this.read();
            if (c < 0) {
                throw new EOFException();
            }
            chars[i] = (char)c;
        }
    }

    public final void readChars(char[] chars) throws IOException {
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.readChar();
        }
    }

    public final String readString(int length) throws IOException {
        char[] chars = new char[length];
        this.readString(chars);
        return new String(chars);
    }

    public final void readString(char[] chars) throws IOException {
        byte[] buf = this.getBufferBytes();
        this.off = UtfOps.bytesToChars(buf, this.off, chars, 0, chars.length, false);
    }
}

