/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.filter.config.tools.merge;

import com.sun.star.filter.config.tools.merge.Merger;
import com.sun.star.filter.config.tools.utils.ConfigHelper;
import com.sun.star.filter.config.tools.utils.Logger;

public class FCFGMerge {
    private static final String CFGFILE = "com/sun/star/filter/config/tools/merge/FCFGMerge.cfg";
    private static final String PROP_LOGLEVEL = "loglevel";

    public static void main(String[] stringArray) {
        FCFGMerge.printCopyright();
        Logger logger = new Logger();
        try {
            ConfigHelper configHelper = null;
            configHelper = new ConfigHelper(CFGFILE, stringArray);
            int n = configHelper.getInt(PROP_LOGLEVEL, 2);
            logger = new Logger(n);
            if (configHelper.isHelp()) {
                FCFGMerge.printHelp();
                System.exit(-1);
            }
            Merger merger = new Merger(configHelper, logger);
            merger.merge();
        }
        catch (Throwable throwable) {
            logger.setException(throwable);
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void printCopyright() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("FCFGMerge\n");
        stringBuffer.append("Copyright: 2003 by Sun Microsystems, Inc.\n");
        stringBuffer.append("All Rights Reserved.\n");
        System.out.println(stringBuffer.toString());
    }

    private static void printHelp() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("____________________________________________________________\n");
        stringBuffer.append("usage: FCFGMerge cfg=<file name>\n");
        stringBuffer.append("parameters:\n");
        stringBuffer.append("\tcfg=<file name>\n");
        stringBuffer.append("\t\tmust point to a system file, which contains\n");
        stringBuffer.append("\t\tall neccessary configuration data for the merge process.\n");
        stringBuffer.append("\n\tFurther cou can specify every parameter allowed in the\n");
        stringBuffer.append("\n\tconfig file as command line parameter too, to overwrite\n");
        stringBuffer.append("\n\tthe value from the file.\n");
        System.out.println(stringBuffer.toString());
    }
}

