/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.filter.config.tools.utils;

import com.sun.star.filter.config.tools.utils.FileHelper;
import com.sun.star.filter.config.tools.utils.Logger;
import com.sun.star.filter.config.tools.utils.XMLHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Cache {
    public static final int E_TYPE = 0;
    public static final int E_FILTER = 1;
    public static final int E_DETECTSERVICE = 2;
    public static final int E_FRAMELOADER = 3;
    public static final int E_CONTENTHANDLER = 4;
    public static final int FORMAT_UNSUPPORTED = -1;
    public static final int FORMAT_60 = 0;
    public static final int FORMAT_6Y = 1;
    public static final int FORMAT_INTERNAL = 2;
    public static final String CMDVAL_FORMAT_60 = "6.0";
    public static final String CMDVAL_FORMAT_6Y = "6.Y";
    public static final String CMDVAL_FORMAT_INTERNAL = "internal";
    public static final String PROPNAME_DATA = "Data";
    public static final String PROPNAME_NAME = "Name";
    public static final String PROPNAME_UINAME = "UIName";
    public static final String PROPNAME_UINAMES = "UINames";
    public static final String PROPNAME_MEDIATYPE = "MediaType";
    public static final String PROPNAME_PREFERRED = "Preferred";
    public static final String PROPNAME_CLIPBOARDFORMAT = "ClipboardFormat";
    public static final String PROPNAME_DOCUMENTICONID = "DocumentIconID";
    public static final String PROPNAME_URLPATTERN = "URLPattern";
    public static final String PROPNAME_EXTENSIONS = "Extensions";
    public static final String PROPNAME_UIORDER = "UIOrder";
    public static final String PROPNAME_PREFERREDFILTER = "PreferredFilter";
    public static final String PROPNAME_DETECTSERVICE = "DetectService";
    public static final String PROPNAME_FRAMELOADER = "FrameLoader";
    public static final String PROPNAME_CONTENTHANDLER = "ContentHandler";
    public static final String PROPNAME_DOCUMENTSERVICE = "DocumentService";
    public static final String PROPNAME_FILEFORMATVERSION = "FileFormatVersion";
    public static final String PROPNAME_FILTERSERVICE = "FilterService";
    public static final String PROPNAME_FLAGS = "Flags";
    public static final String PROPNAME_ORDER = "Order";
    public static final String PROPNAME_TEMPLATENAME = "TemplateName";
    public static final String PROPNAME_TYPE = "Type";
    public static final String PROPNAME_UICOMPONENT = "UIComponent";
    public static final String PROPNAME_USERDATA = "UserData";
    public static final String PROPNAME_TYPES = "Types";
    private static final String FILTERSERVICE_NATIVEWARPPER = "com.sun.star.filter.NativeFilterWrapper";
    private static final String GENERIC_DETECTSERVICE = "com.sun.star.comp.office.FrameLoader";
    private static final String CFGNODE_TYPES = "Types";
    private static final String CFGNODE_FILTERS = "Filters";
    private static final String CFGNODE_DETECTSERVICES = "DetectServices";
    private static final String CFGNODE_FRAMELOADERS = "FrameLoaders";
    private static final String CFGNODE_CONTENTHANDLERS = "ContentHandlers";
    private static final String FLAGNAME_3RDPARTYFILTER = "3RDPARTYFILTER";
    private static final String FLAGNAME_ALIEN = "ALIEN";
    private static final String FLAGNAME_ASYNCHRON = "ASYNCHRON";
    private static final String FLAGNAME_BROWSERPREFERRED = "BROWSERPREFERRED";
    private static final String FLAGNAME_CONSULTSERVICE = "CONSULTSERVICE";
    private static final String FLAGNAME_DEFAULT = "DEFAULT";
    private static final String FLAGNAME_EXPORT = "EXPORT";
    private static final String FLAGNAME_IMPORT = "IMPORT";
    private static final String FLAGNAME_INTERNAL = "INTERNAL";
    private static final String FLAGNAME_NOTINCHOOSER = "NOTINCHOOSER";
    private static final String FLAGNAME_NOTINFILEDIALOG = "NOTINFILEDIALOG";
    private static final String FLAGNAME_NOTINSTALLED = "NOTINSTALLED";
    private static final String FLAGNAME_OWN = "OWN";
    private static final String FLAGNAME_PACKED = "PACKED";
    private static final String FLAGNAME_PREFERRED = "PREFERRED";
    private static final String FLAGNAME_READONLY = "READONLY";
    private static final String FLAGNAME_SILENTEXPORT = "SILENTEXPORT";
    private static final String FLAGNAME_TEMPLATE = "TEMPLATE";
    private static final String FLAGNAME_TEMPLATEPATH = "TEMPLATEPATH";
    private static final String FLAGNAME_USESOPTIONS = "USESOPTIONS";
    private static final String FLAGNAME_COMBINED = "COMBINED";
    private static final String FLAGNAME_SUPPORTSSELECTION = "SUPPORTSSELECTION";
    private static final int FLAGVAL_3RDPARTYFILTER = 524288;
    private static final int FLAGVAL_ALIEN = 64;
    private static final int FLAGVAL_ALL = -1;
    private static final int FLAGVAL_ASYNCHRON = 16384;
    private static final int FLAGVAL_BROWSERPREFERRED = 0x400000;
    private static final int FLAGVAL_CONSULTSERVICE = 262144;
    private static final int FLAGVAL_DEFAULT = 256;
    private static final int FLAGVAL_EXPORT = 2;
    private static final int FLAGVAL_IMPORT = 1;
    private static final int FLAGVAL_INTERNAL = 8;
    private static final int FLAGVAL_NOTINCHOOSER = 8192;
    private static final int FLAGVAL_NOTINFILEDIALOG = 4096;
    private static final int FLAGVAL_NOTINSTALLED = 131072;
    private static final int FLAGVAL_OWN = 32;
    private static final int FLAGVAL_PACKED = 0x100000;
    private static final int FLAGVAL_PREFERRED = 0x10000000;
    private static final int FLAGVAL_READONLY = 65536;
    private static final int FLAGVAL_SILENTEXPORT = 0x200000;
    private static final int FLAGVAL_TEMPLATE = 4;
    private static final int FLAGVAL_TEMPLATEPATH = 16;
    private static final int FLAGVAL_USESOPTIONS = 128;
    private static final int FLAGVAL_COMBINED = 0x800000;
    private static final int FLAGVAL_SUPPORTSSELECTION = 1024;
    private HashMap m_lTypes;
    private HashMap m_lFilters;
    private HashMap m_lDetectServices;
    private HashMap m_lFrameLoaders;
    private HashMap m_lContentHandlers;
    private HashMap m_lFilterToTypeRegistrations;
    private int m_nDoubleRegisteredFilters;
    private int m_nTypesForFilters;
    private int m_nTypesForDetectServices;
    private int m_nTypesForFrameLoaders;
    private int m_nTypesForContentHandlers;
    private Logger m_aDebug;

    public Cache(Logger logger) {
        this.reset();
        this.m_aDebug = logger;
    }

    public synchronized void reset() {
        this.m_lTypes = new HashMap();
        this.m_lFilters = new HashMap();
        this.m_lFrameLoaders = new HashMap();
        this.m_lDetectServices = new HashMap();
        this.m_lContentHandlers = new HashMap();
        this.m_lFilterToTypeRegistrations = new HashMap();
        this.m_aDebug = new Logger();
        this.m_nDoubleRegisteredFilters = 0;
        this.m_nTypesForFilters = 0;
        this.m_nTypesForDetectServices = 0;
        this.m_nTypesForFrameLoaders = 0;
        this.m_nTypesForContentHandlers = 0;
    }

    public static int mapFormatString2Format(String string) {
        int n = -1;
        if (string.equalsIgnoreCase(CMDVAL_FORMAT_60)) {
            n = 0;
        } else if (string.equalsIgnoreCase(CMDVAL_FORMAT_6Y)) {
            n = 1;
        } else if (string.equalsIgnoreCase(CMDVAL_FORMAT_INTERNAL)) {
            n = 2;
        }
        return n;
    }

    public synchronized String getStatistics() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("types                          = " + this.m_lTypes.size() + "\n");
        stringBuffer.append("filters                        = " + this.m_lFilters.size() + "\n");
        stringBuffer.append("detect services                = " + this.m_lDetectServices.size() + "\n");
        stringBuffer.append("frame loaders                  = " + this.m_lFrameLoaders.size() + "\n");
        stringBuffer.append("content handler                = " + this.m_lContentHandlers.size() + "\n");
        stringBuffer.append("double registered filters      = " + this.m_nDoubleRegisteredFilters + "\n");
        stringBuffer.append("types used by filters          = " + this.m_nTypesForFilters + "\n");
        stringBuffer.append("types used by detect services  = " + this.m_nTypesForDetectServices + "\n");
        stringBuffer.append("types used by frame loaders    = " + this.m_nTypesForFrameLoaders + "\n");
        stringBuffer.append("types used by content handlers = " + this.m_nTypesForContentHandlers + "\n");
        return stringBuffer.toString();
    }

    public synchronized void fromXML(File file, int n) throws Exception {
        this.reset();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        System.out.println("TODO: must be adapted to java 1.3 :-(");
        System.exit(-1);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        Element element = document.getDocumentElement();
        Vector vector = XMLHelper.extractChildNodesByTagName(element, "node");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string = XMLHelper.extractNodeAttribByName(node, "oor:name");
            if (string == null) {
                throw new IOException("unsupported format: could not extract set name on node ...\n" + node);
            }
            int n2 = -1;
            HashMap hashMap = null;
            if (string.equals("Types")) {
                n2 = 0;
                hashMap = this.m_lTypes;
            } else if (string.equals(CFGNODE_FILTERS)) {
                n2 = 1;
                hashMap = this.m_lFilters;
            } else if (string.equals(CFGNODE_FRAMELOADERS)) {
                n2 = 3;
                hashMap = this.m_lFrameLoaders;
            } else if (string.equals(CFGNODE_DETECTSERVICES)) {
                n2 = 2;
                hashMap = this.m_lDetectServices;
            } else if (string.equals(CFGNODE_CONTENTHANDLERS)) {
                n2 = 4;
                hashMap = this.m_lContentHandlers;
            } else {
                throw new IOException("unsupported format: unknown set name [\"" + string + "\"] detected on node ...\n" + node);
            }
            Vector vector2 = XMLHelper.extractChildNodesByTagName(node, "node");
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                String string2 = XMLHelper.extractNodeAttribByName(node2, "oor:name");
                if (string2 == null) {
                    throw new IOException("unsupported format: could not extract child node name on node ...\n" + node2);
                }
                HashMap hashMap2 = null;
                HashMap hashMap3 = XMLHelper.convertNodeToPropSet(node2);
                switch (n2) {
                    case 0: {
                        hashMap2 = Cache.convertTypePropsToInternal(hashMap3, n);
                        this.m_aDebug.setDetailedInfo("type [\"" + string2 + "\"] converted to internal format");
                        break;
                    }
                    case 1: {
                        hashMap2 = Cache.convertFilterPropsToInternal(hashMap3, n);
                        this.m_aDebug.setDetailedInfo("filter [\"" + string2 + "\"] converted to internal format");
                        break;
                    }
                    case 2: {
                        hashMap2 = Cache.convertDetectServicePropsToInternal(hashMap3, n);
                        this.m_aDebug.setDetailedInfo("detect service [\"" + string2 + "\"] converted to internal format");
                        break;
                    }
                    case 3: {
                        hashMap2 = Cache.convertFrameLoaderPropsToInternal(hashMap3, n);
                        this.m_aDebug.setDetailedInfo("frame loader [\"" + string2 + "\"] converted to internal format");
                        break;
                    }
                    case 4: {
                        hashMap2 = Cache.convertContentHandlerPropsToInternal(hashMap3, n);
                        this.m_aDebug.setDetailedInfo("content handler [\"" + string2 + "\"] converted to internal format");
                    }
                }
                this.m_aDebug.setDetailedInfo("props = " + hashMap3);
                hashMap.put(string2, hashMap2);
            }
        }
    }

    public synchronized void toHTML(File file, int n, String string) throws Exception {
        Vector<Object> vector;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (n != 1) {
            throw new Exception("HTML views are supported for the new 6.y format only yet.");
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<html><header><title>Relation View</title></header><body>");
        stringBuffer.append("<table border=1>");
        stringBuffer.append("<tr><td><b>type</b></td><td><b>detect service</b></td><td><b>preferred filter</b></td><td><b>frame loader</b></td><td><b>content handler</b></td></tr>");
        Iterator iterator = this.m_lTypes.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = (HashMap)this.m_lTypes.get(object4);
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>" + (String)object4 + "</td>");
            object2 = (String)((HashMap)object3).get(PROPNAME_DETECTSERVICE);
            if (object2 == null || ((String)object2).length() < 1) {
                stringBuffer.append("<td> - </td>");
            } else {
                stringBuffer.append("<td>" + (String)object2 + "</td>");
            }
            object2 = (String)((HashMap)object3).get(PROPNAME_PREFERREDFILTER);
            if (object2 == null || ((String)object2).length() < 1) {
                stringBuffer.append("<td> - </td>");
            } else {
                stringBuffer.append("<td>" + (String)object2 + "</td>");
            }
            object2 = (String)((HashMap)object3).get(PROPNAME_FRAMELOADER);
            if (object2 == null || ((String)object2).length() < 1) {
                stringBuffer.append("<td> - </td>");
            } else {
                stringBuffer.append("<td>" + (String)object2 + "</td>");
            }
            object2 = (String)((HashMap)object3).get(PROPNAME_CONTENTHANDLER);
            if (object2 == null || ((String)object2).length() < 1) {
                stringBuffer.append("<td> - </td>");
            } else {
                stringBuffer.append("<td>" + (String)object2 + "</td>");
            }
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        stringBuffer.append("</body>");
        FileHelper.writeEncodedBufferToFile(new File(file, "relation_view.html"), string, false, stringBuffer);
        object4 = new HashMap();
        iterator = this.m_lFilters.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            object2 = (HashMap)this.m_lFilters.get(object3);
            object = (String)((HashMap)object2).get(PROPNAME_TYPE);
            vector = (Vector<Object>)((HashMap)object4).get(object);
            if (vector == null) {
                vector = new Vector<Object>();
            }
            vector.add(object3);
            ((HashMap)object4).put(object, vector);
        }
        object3 = new StringBuffer(1000);
        ((StringBuffer)object3).append("<html><header><title>Type2Filters View</title></header><body>");
        ((StringBuffer)object3).append("<table border=1>");
        ((StringBuffer)object3).append("<tr><td><b>type</b></td><td><b>filters</b></td></tr>");
        iterator = ((HashMap)object4).keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (Vector)((HashMap)object4).get(object2);
            ((StringBuffer)object3).append("<tr><td>" + (String)object2 + "</td><td>");
            vector = ((Vector)object).elements();
            while (vector.hasMoreElements()) {
                ((StringBuffer)object3).append(vector.nextElement() + "<br>");
            }
            ((StringBuffer)object3).append("</td></tr>");
        }
        ((StringBuffer)object3).append("</table>");
        ((StringBuffer)object3).append("</body>");
        FileHelper.writeEncodedBufferToFile(new File(file, "type2filters_view.html"), string, false, (StringBuffer)object3);
    }

    public synchronized void toXML(File file, int n, String string) throws Exception {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(500000);
        for (int i = 0; i < 5; ++i) {
            object2 = null;
            object = null;
            int n2 = -1;
            switch (i) {
                case 0: {
                    object2 = "Types";
                    object = this.m_lTypes;
                    n2 = 0;
                    break;
                }
                case 1: {
                    object2 = CFGNODE_FILTERS;
                    object = this.m_lFilters;
                    n2 = 1;
                    break;
                }
                case 2: {
                    object2 = CFGNODE_DETECTSERVICES;
                    object = this.m_lDetectServices;
                    n2 = 2;
                    break;
                }
                case 3: {
                    object2 = CFGNODE_FRAMELOADERS;
                    object = this.m_lFrameLoaders;
                    n2 = 3;
                    break;
                }
                case 4: {
                    object2 = CFGNODE_CONTENTHANDLERS;
                    object = this.m_lContentHandlers;
                    n2 = 4;
                }
            }
            stringBuffer.append("<node oor:name=\"" + (String)object2 + "\" oor:op=\"replace\">\n");
            Iterator iterator = ((HashMap)object).keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                stringBuffer.append("<node oor:name=\"" + string2 + "\" oor:op=\"replace\">\n");
                stringBuffer.append(this.getItemAsXML(n2, string2, n));
                stringBuffer.append("</node>\n");
            }
            stringBuffer.append("</node>\n");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), false);
        object2 = new OutputStreamWriter((OutputStream)fileOutputStream, string);
        object = stringBuffer.toString();
        ((OutputStreamWriter)object2).write((String)object, 0, ((String)object).length());
        ((OutputStreamWriter)object2).flush();
        ((OutputStreamWriter)object2).close();
    }

    private static HashMap convertTypePropsToExternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = new HashMap();
        if (hashMap.containsKey(PROPNAME_NAME)) {
            hashMap2.put(PROPNAME_NAME, hashMap.get(PROPNAME_NAME));
        }
        switch (n) {
            case 0: {
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append(hashMap.get(PROPNAME_PREFERRED));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_MEDIATYPE));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_CLIPBOARDFORMAT));
                stringBuffer.append(",");
                Vector vector = (Vector)hashMap.get(PROPNAME_URLPATTERN);
                int n2 = vector.size();
                int n3 = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(vector.elementAt(n3));
                    if (n3 >= n2 - 1) continue;
                    stringBuffer.append(";");
                }
                vector = (Vector)hashMap.get(PROPNAME_EXTENSIONS);
                n2 = vector.size();
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(vector.elementAt(n3));
                    if (n3 >= n2 - 1) continue;
                    stringBuffer.append(";");
                }
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_DOCUMENTICONID));
                stringBuffer.append(",");
                hashMap2.put(PROPNAME_DATA, stringBuffer.toString());
                break;
            }
            case 1: {
                hashMap2.put(PROPNAME_PREFERRED, hashMap.get(PROPNAME_PREFERRED));
                hashMap2.put(PROPNAME_MEDIATYPE, hashMap.get(PROPNAME_MEDIATYPE));
                hashMap2.put(PROPNAME_URLPATTERN, hashMap.get(PROPNAME_URLPATTERN));
                hashMap2.put(PROPNAME_EXTENSIONS, hashMap.get(PROPNAME_EXTENSIONS));
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                hashMap2.put(PROPNAME_PREFERREDFILTER, hashMap.get(PROPNAME_PREFERREDFILTER));
                hashMap2.put(PROPNAME_DETECTSERVICE, hashMap.get(PROPNAME_DETECTSERVICE));
                hashMap2.put(PROPNAME_CLIPBOARDFORMAT, hashMap.get(PROPNAME_CLIPBOARDFORMAT));
                hashMap2.put(PROPNAME_UIORDER, hashMap.get(PROPNAME_UIORDER));
                break;
            }
            default: {
                throw new Exception("unknown format");
            }
        }
        return hashMap2;
    }

    private static HashMap convertFilterPropsToExternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = new HashMap();
        if (hashMap.containsKey(PROPNAME_NAME)) {
            hashMap2.put(PROPNAME_NAME, hashMap.get(PROPNAME_NAME));
        }
        switch (n) {
            case 0: {
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append(hashMap.get(PROPNAME_ORDER));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_TYPE));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_DOCUMENTSERVICE));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_FILTERSERVICE));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_FLAGS));
                stringBuffer.append(",");
                Vector vector = (Vector)hashMap.get(PROPNAME_USERDATA);
                int n2 = vector.size();
                int n3 = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(vector.elementAt(n3));
                    if (n3 >= n2 - 1) continue;
                    stringBuffer.append(";");
                }
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_FILEFORMATVERSION));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_TEMPLATENAME));
                stringBuffer.append(",");
                stringBuffer.append(hashMap.get(PROPNAME_UICOMPONENT));
                stringBuffer.append(",");
                hashMap2.put(PROPNAME_DATA, stringBuffer.toString());
                break;
            }
            case 1: {
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                hashMap2.put(PROPNAME_TYPE, hashMap.get(PROPNAME_TYPE));
                hashMap2.put(PROPNAME_DOCUMENTSERVICE, hashMap.get(PROPNAME_DOCUMENTSERVICE));
                hashMap2.put(PROPNAME_FILTERSERVICE, hashMap.get(PROPNAME_FILTERSERVICE));
                hashMap2.put(PROPNAME_USERDATA, hashMap.get(PROPNAME_USERDATA));
                hashMap2.put(PROPNAME_FILEFORMATVERSION, hashMap.get(PROPNAME_FILEFORMATVERSION));
                hashMap2.put(PROPNAME_TEMPLATENAME, hashMap.get(PROPNAME_TEMPLATENAME));
                hashMap2.put(PROPNAME_UICOMPONENT, hashMap.get(PROPNAME_UICOMPONENT));
                Integer n4 = (Integer)hashMap.get(PROPNAME_FLAGS);
                Vector vector = Cache.convertFilterFlagValues2Names(n4);
                hashMap2.put(PROPNAME_FLAGS, vector);
                break;
            }
            default: {
                throw new Exception("unknown format");
            }
        }
        return hashMap2;
    }

    private static HashMap convertDetectServicePropsToExternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = null;
        switch (n) {
            case 0: {
                hashMap2 = hashMap;
                break;
            }
            case 1: {
                hashMap2 = hashMap;
                hashMap2.remove(PROPNAME_UINAME);
                break;
            }
            default: {
                throw new Exception("unknown format");
            }
        }
        return hashMap2;
    }

    private static HashMap convertFrameLoaderPropsToExternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = null;
        switch (n) {
            case 0: {
                hashMap2 = hashMap;
                break;
            }
            case 1: {
                hashMap2 = hashMap;
                hashMap2.remove(PROPNAME_UINAME);
                break;
            }
            default: {
                throw new Exception("unknown format");
            }
        }
        return hashMap2;
    }

    private static HashMap convertContentHandlerPropsToExternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = null;
        switch (n) {
            case 0: {
                hashMap2 = hashMap;
                break;
            }
            case 1: {
                hashMap2 = hashMap;
                hashMap2.remove(PROPNAME_UINAME);
                break;
            }
            default: {
                throw new Exception("unknown format");
            }
        }
        return hashMap2;
    }

    private static HashMap convertTypePropsToInternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = new HashMap();
        if (hashMap.containsKey(PROPNAME_NAME)) {
            hashMap2.put(PROPNAME_NAME, hashMap.get(PROPNAME_NAME));
        }
        switch (n) {
            case 0: {
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                hashMap2.put(PROPNAME_UIORDER, new Integer(0));
                hashMap2.put(PROPNAME_PREFERREDFILTER, new String());
                hashMap2.put(PROPNAME_DETECTSERVICE, new String());
                String string = (String)hashMap.get(PROPNAME_DATA);
                Vector vector = Cache.splitTokenString(string, ",");
                int n2 = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    switch (n2) {
                        case 0: {
                            hashMap2.put(PROPNAME_PREFERRED, new Boolean(string2));
                            break;
                        }
                        case 1: {
                            hashMap2.put(PROPNAME_MEDIATYPE, string2);
                            break;
                        }
                        case 2: {
                            int n3 = string2.indexOf("%20");
                            if (n3 != -1) {
                                String string3;
                                string2 = string3 = string2.substring(0, n3) + " " + string2.substring(n3 + 3);
                            }
                            hashMap2.put(PROPNAME_CLIPBOARDFORMAT, string2);
                            break;
                        }
                        case 3: {
                            hashMap2.put(PROPNAME_URLPATTERN, Cache.splitTokenString(string2, ";"));
                            break;
                        }
                        case 4: {
                            hashMap2.put(PROPNAME_EXTENSIONS, Cache.splitTokenString(string2, ";"));
                            break;
                        }
                        case 5: {
                            hashMap2.put(PROPNAME_DOCUMENTICONID, new Integer(string2));
                            break;
                        }
                        default: {
                            throw new Exception("unsupported format for data value of a type \"" + hashMap.get(PROPNAME_NAME) + "\" detected.");
                        }
                    }
                    ++n2;
                }
                break;
            }
            case 1: {
                hashMap2.put(PROPNAME_PREFERRED, hashMap.get(PROPNAME_PREFERRED));
                hashMap2.put(PROPNAME_MEDIATYPE, hashMap.get(PROPNAME_MEDIATYPE));
                hashMap2.put(PROPNAME_CLIPBOARDFORMAT, hashMap.get(PROPNAME_CLIPBOARDFORMAT));
                hashMap2.put(PROPNAME_URLPATTERN, hashMap.get(PROPNAME_URLPATTERN));
                hashMap2.put(PROPNAME_EXTENSIONS, hashMap.get(PROPNAME_EXTENSIONS));
                hashMap2.put(PROPNAME_DOCUMENTICONID, hashMap.get(PROPNAME_DOCUMENTICONID));
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                hashMap2.put(PROPNAME_UIORDER, hashMap.get(PROPNAME_UIORDER));
                hashMap2.put(PROPNAME_PREFERREDFILTER, hashMap.get(PROPNAME_PREFERREDFILTER));
                hashMap2.put(PROPNAME_DETECTSERVICE, hashMap.get(PROPNAME_DETECTSERVICE));
                break;
            }
            default: {
                throw new Exception("unknown format");
            }
        }
        return hashMap2;
    }

    private static HashMap convertFilterPropsToInternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = new HashMap();
        if (hashMap.containsKey(PROPNAME_NAME)) {
            hashMap2.put(PROPNAME_NAME, hashMap.get(PROPNAME_NAME));
        }
        switch (n) {
            case 0: {
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                String string = (String)hashMap.get(PROPNAME_DATA);
                Vector vector = Cache.splitTokenString(string, ",");
                int n2 = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    switch (n2) {
                        case 0: {
                            hashMap2.put(PROPNAME_ORDER, new Integer(string2));
                            break;
                        }
                        case 1: {
                            hashMap2.put(PROPNAME_TYPE, string2);
                            break;
                        }
                        case 2: {
                            hashMap2.put(PROPNAME_DOCUMENTSERVICE, string2);
                            break;
                        }
                        case 3: {
                            hashMap2.put(PROPNAME_FILTERSERVICE, string2);
                            break;
                        }
                        case 4: {
                            hashMap2.put(PROPNAME_FLAGS, new Integer(string2));
                            break;
                        }
                        case 5: {
                            hashMap2.put(PROPNAME_USERDATA, Cache.splitTokenString(string2, ";"));
                            break;
                        }
                        case 6: {
                            hashMap2.put(PROPNAME_FILEFORMATVERSION, new Integer(string2));
                            break;
                        }
                        case 7: {
                            hashMap2.put(PROPNAME_TEMPLATENAME, string2);
                            break;
                        }
                        case 8: {
                            hashMap2.put(PROPNAME_UICOMPONENT, string2);
                            break;
                        }
                        default: {
                            throw new Exception("unsupported format for data value of a filter detected.");
                        }
                    }
                    ++n2;
                }
                if (!hashMap2.containsKey(PROPNAME_TEMPLATENAME)) {
                    hashMap2.put(PROPNAME_TEMPLATENAME, new String(""));
                }
                if (hashMap2.containsKey(PROPNAME_UICOMPONENT)) break;
                hashMap2.put(PROPNAME_UICOMPONENT, new String(""));
                break;
            }
            case 1: {
                hashMap2.put(PROPNAME_ORDER, new Integer(0));
                hashMap2.put(PROPNAME_UINAME, hashMap.get(PROPNAME_UINAME));
                Vector vector = (Vector)hashMap.get(PROPNAME_FLAGS);
                Integer n3 = Cache.convertFilterFlagNames2Values(vector);
                hashMap2.put(PROPNAME_FLAGS, n3);
                hashMap2.put(PROPNAME_TYPE, hashMap.get(PROPNAME_TYPE));
                hashMap2.put(PROPNAME_DOCUMENTSERVICE, hashMap.get(PROPNAME_DOCUMENTSERVICE));
                hashMap2.put(PROPNAME_FILTERSERVICE, hashMap.get(PROPNAME_ORDER));
                hashMap2.put(PROPNAME_USERDATA, hashMap.get(PROPNAME_USERDATA));
                hashMap2.put(PROPNAME_FILEFORMATVERSION, hashMap.get(PROPNAME_FILEFORMATVERSION));
                hashMap2.put(PROPNAME_TEMPLATENAME, hashMap.get(PROPNAME_TEMPLATENAME));
                hashMap2.put(PROPNAME_UICOMPONENT, hashMap.get(PROPNAME_UICOMPONENT));
                break;
            }
            default: {
                throw new Exception("unknown format");
            }
        }
        return hashMap2;
    }

    private static HashMap convertDetectServicePropsToInternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = hashMap;
        return hashMap2;
    }

    private static HashMap convertFrameLoaderPropsToInternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = hashMap;
        return hashMap2;
    }

    private static HashMap convertContentHandlerPropsToInternal(HashMap hashMap, int n) throws Exception {
        HashMap hashMap2 = hashMap;
        return hashMap2;
    }

    private static Integer convertFilterFlagNames2Values(Vector vector) throws Exception {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals(FLAGNAME_3RDPARTYFILTER)) {
                n |= 0x80000;
                continue;
            }
            if (string.equals(FLAGNAME_ALIEN)) {
                n |= 0x40;
                continue;
            }
            if (string.equals(FLAGNAME_ASYNCHRON)) {
                n |= 0x4000;
                continue;
            }
            if (string.equals(FLAGNAME_BROWSERPREFERRED)) {
                n |= 0x400000;
                continue;
            }
            if (string.equals(FLAGNAME_CONSULTSERVICE)) {
                n |= 0x40000;
                continue;
            }
            if (string.equals(FLAGNAME_DEFAULT)) {
                n |= 0x100;
                continue;
            }
            if (string.equals(FLAGNAME_EXPORT)) {
                n |= 2;
                continue;
            }
            if (string.equals(FLAGNAME_IMPORT)) {
                n |= 1;
                continue;
            }
            if (string.equals(FLAGNAME_INTERNAL)) {
                n |= 8;
                continue;
            }
            if (string.equals(FLAGNAME_NOTINCHOOSER)) {
                n |= 0x2000;
                continue;
            }
            if (string.equals(FLAGNAME_NOTINFILEDIALOG)) {
                n |= 0x1000;
                continue;
            }
            if (string.equals(FLAGNAME_NOTINSTALLED)) {
                n |= 0x20000;
                continue;
            }
            if (string.equals(FLAGNAME_OWN)) {
                n |= 0x20;
                continue;
            }
            if (string.equals(FLAGNAME_PACKED)) {
                n |= 0x100000;
                continue;
            }
            if (string.equals(FLAGNAME_PREFERRED)) {
                n |= 0x10000000;
                continue;
            }
            if (string.equals(FLAGNAME_READONLY)) {
                n |= 0x10000;
                continue;
            }
            if (string.equals(FLAGNAME_SILENTEXPORT)) {
                n |= 0x200000;
                continue;
            }
            if (string.equals(FLAGNAME_TEMPLATE)) {
                n |= 4;
                continue;
            }
            if (string.equals(FLAGNAME_TEMPLATEPATH)) {
                n |= 0x10;
                continue;
            }
            if (string.equals(FLAGNAME_USESOPTIONS)) {
                n |= 0x80;
                continue;
            }
            if (string.equals(FLAGNAME_COMBINED)) {
                n |= 0x800000;
                continue;
            }
            throw new Exception("unsupported filter flag detected: \"" + string + "\"");
        }
        if (n == 0) {
            throw new Exception("no filter flags?");
        }
        return new Integer(n);
    }

    private static Vector convertFilterFlagValues2Names(Integer n) throws Exception {
        Vector<String> vector = new Vector<String>();
        int n2 = n;
        if (n2 == 0) {
            throw new Exception("no filter flags?");
        }
        if ((n2 & 1) == 1) {
            vector.add(FLAGNAME_IMPORT);
        }
        if ((n2 & 2) == 2) {
            vector.add(FLAGNAME_EXPORT);
        }
        if ((n2 & 4) == 4) {
            vector.add(FLAGNAME_TEMPLATE);
        }
        if ((n2 & 8) == 8) {
            vector.add(FLAGNAME_INTERNAL);
        }
        if ((n2 & 0x10) == 16) {
            vector.add(FLAGNAME_TEMPLATEPATH);
        }
        if ((n2 & 0x20) == 32) {
            vector.add(FLAGNAME_OWN);
        }
        if ((n2 & 0x40) == 64) {
            vector.add(FLAGNAME_ALIEN);
        }
        if ((n2 & 0x80) == 128) {
            vector.add(FLAGNAME_USESOPTIONS);
        }
        if ((n2 & 0x100) == 256) {
            vector.add(FLAGNAME_DEFAULT);
        }
        if ((n2 & 0x1000) == 4096) {
            vector.add(FLAGNAME_NOTINFILEDIALOG);
        }
        if ((n2 & 0x2000) == 8192) {
            vector.add(FLAGNAME_NOTINCHOOSER);
        }
        if ((n2 & 0x4000) == 16384) {
            vector.add(FLAGNAME_ASYNCHRON);
        }
        if ((n2 & 0x10000) == 65536) {
            vector.add(FLAGNAME_READONLY);
        }
        if ((n2 & 0x20000) == 131072) {
            vector.add(FLAGNAME_NOTINSTALLED);
        }
        if ((n2 & 0x40000) == 262144) {
            vector.add(FLAGNAME_CONSULTSERVICE);
        }
        if ((n2 & 0x80000) == 524288) {
            vector.add(FLAGNAME_3RDPARTYFILTER);
        }
        if ((n2 & 0x100000) == 0x100000) {
            vector.add(FLAGNAME_PACKED);
        }
        if ((n2 & 0x200000) == 0x200000) {
            vector.add(FLAGNAME_SILENTEXPORT);
        }
        if ((n2 & 0x400000) == 0x400000) {
            vector.add(FLAGNAME_BROWSERPREFERRED);
        }
        if ((n2 & 0x10000000) == 0x10000000) {
            vector.add(FLAGNAME_PREFERRED);
        }
        if ((n2 & 0x800000) == 0x800000) {
            vector.add(FLAGNAME_COMBINED);
        }
        if ((n2 & 0x800000) == 1024) {
            vector.add(FLAGNAME_SUPPORTSSELECTION);
        }
        return vector;
    }

    private HashMap getItemMap(int n) throws Exception {
        HashMap hashMap = null;
        switch (n) {
            case 0: {
                hashMap = this.m_lTypes;
                break;
            }
            case 1: {
                hashMap = this.m_lFilters;
                break;
            }
            case 2: {
                hashMap = this.m_lDetectServices;
                break;
            }
            case 3: {
                hashMap = this.m_lFrameLoaders;
                break;
            }
            case 4: {
                hashMap = this.m_lContentHandlers;
                break;
            }
            default: {
                throw new Exception("Invalid item map specified.");
            }
        }
        return hashMap;
    }

    public synchronized int getItemCount(int n) throws Exception {
        HashMap hashMap = this.getItemMap(n);
        return hashMap.size();
    }

    public synchronized Vector getItemNames(int n) throws Exception {
        Vector vector = new Vector();
        HashMap hashMap = this.getItemMap(n);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        return vector;
    }

    public synchronized Vector getMatchedItemNames(int n, HashMap hashMap) throws Exception {
        Vector<String> vector = new Vector<String>();
        HashMap hashMap2 = this.getItemMap(n);
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashMap hashMap3 = (HashMap)hashMap2.get(string);
            boolean bl = Cache.matchPropSet(hashMap3, hashMap);
            if (bl) {
                vector.add(string);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append("entry [" + n + "] \"" + string + "\" does not match.\n");
            stringBuffer.append("\torg items = {" + hashMap3 + "}\n");
            stringBuffer.append("\treq items = {" + hashMap + "}\n");
            this.m_aDebug.setDetailedInfo(stringBuffer.toString());
        }
        return vector;
    }

    private static boolean matchPropSet(HashMap hashMap, HashMap hashMap2) {
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = hashMap2.get(string);
            if (hashMap.containsKey(string) && hashMap.get(string).equals(v)) continue;
            return false;
        }
        return true;
    }

    public synchronized HashMap getItem(int n, String string) throws Exception {
        HashMap hashMap = this.getItemMap(n);
        HashMap hashMap2 = (HashMap)hashMap.get(string);
        if (hashMap2 == null) {
            throw new Exception("Queried item \"" + string + "\" does not exist inside this cache.");
        }
        return hashMap2;
    }

    public synchronized String getItemAsXML(int n, String string, int n2) throws Exception {
        int n3;
        HashMap hashMap = this.getItem(n, string);
        HashMap hashMap2 = null;
        switch (n) {
            case 0: {
                hashMap2 = Cache.convertTypePropsToExternal(hashMap, n2);
                this.m_aDebug.setGlobalInfo("type to external \"" + string + "\"");
                break;
            }
            case 1: {
                hashMap2 = Cache.convertFilterPropsToExternal(hashMap, n2);
                this.m_aDebug.setGlobalInfo("filter to external \"" + string + "\"");
                break;
            }
            case 2: {
                hashMap2 = Cache.convertDetectServicePropsToExternal(hashMap, n2);
                this.m_aDebug.setGlobalInfo("detect service to external \"" + string + "\"");
                break;
            }
            case 3: {
                hashMap2 = Cache.convertFrameLoaderPropsToExternal(hashMap, n2);
                this.m_aDebug.setGlobalInfo("frame loader to external \"" + string + "\"");
                break;
            }
            case 4: {
                hashMap2 = Cache.convertContentHandlerPropsToExternal(hashMap, n2);
                this.m_aDebug.setGlobalInfo("content handler to external \"" + string + "\"");
            }
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        int n4 = 1;
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append("\t");
        }
        stringBuffer.append("<node oor:name=\"" + XMLHelper.encodeHTMLSigns(string) + "\" " + "oor:op" + "=\"" + "replace" + "\">\n");
        stringBuffer.append(XMLHelper.convertPropSetToXML(hashMap2, n4 + 1));
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append("\t");
        }
        stringBuffer.append("</node>\n");
        return stringBuffer.toString();
    }

    private static Vector splitTokenString(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                if (bl) {
                    vector.add("");
                    continue;
                }
                bl = true;
                continue;
            }
            vector.add(string3);
            bl = false;
        }
        return vector;
    }

    public synchronized void analyze() {
        Cloneable cloneable;
        String string;
        Object object;
        String string2;
        this.m_nDoubleRegisteredFilters = 0;
        this.m_nTypesForFilters = 0;
        this.m_nTypesForDetectServices = 0;
        this.m_nTypesForFrameLoaders = 0;
        this.m_nTypesForContentHandlers = 0;
        this.m_lFilterToTypeRegistrations = new HashMap();
        Iterator iterator = this.m_lFilters.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            object = (HashMap)this.m_lFilters.get(string2);
            string = (String)((HashMap)object).get(PROPNAME_TYPE);
            cloneable = (Vector<String>)this.m_lFilterToTypeRegistrations.get(string);
            if (cloneable == null) {
                cloneable = new Vector<String>();
            } else {
                ++this.m_nDoubleRegisteredFilters;
            }
            ((Vector)cloneable).add(string2);
            this.m_lFilterToTypeRegistrations.put(string, cloneable);
        }
        iterator = this.m_lTypes.keySet().iterator();
        block1: while (iterator.hasNext()) {
            Object object2;
            string2 = (String)iterator.next();
            object = this.m_lFilters.keySet().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                cloneable = (HashMap)this.m_lFilters.get(string);
                object2 = (String)((HashMap)cloneable).get(PROPNAME_TYPE);
                if (!((String)object2).equals(string2)) continue;
                ++this.m_nTypesForFilters;
                break;
            }
            object = this.m_lDetectServices.keySet().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                cloneable = (HashMap)this.m_lDetectServices.get(string);
                object2 = (Vector)((HashMap)cloneable).get("Types");
                if (!((Vector)object2).contains(string2)) continue;
                ++this.m_nTypesForDetectServices;
                break;
            }
            object = this.m_lFrameLoaders.keySet().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                cloneable = (HashMap)this.m_lFrameLoaders.get(string);
                object2 = (Vector)((HashMap)cloneable).get("Types");
                if (!((Vector)object2).contains(string2)) continue;
                ++this.m_nTypesForFrameLoaders;
                break;
            }
            object = this.m_lContentHandlers.keySet().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                cloneable = (HashMap)this.m_lContentHandlers.get(string);
                object2 = (Vector)((HashMap)cloneable).get("Types");
                if (!((Vector)object2).contains(string2)) continue;
                ++this.m_nTypesForContentHandlers;
                continue block1;
            }
        }
    }

    public synchronized void validate(int n) throws Exception {
        this.validateTypes(n);
        this.validateFilters(n);
    }

    private void validateTypes(int n) throws Exception {
        Iterator iterator = this.m_lTypes.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            HashMap hashMap = (HashMap)this.m_lTypes.get(string2);
            if (hashMap == null) {
                throw new Exception("type [" + string2 + "] dos not exist realy?!");
            }
            if (!(hashMap.containsKey(PROPNAME_MEDIATYPE) && hashMap.containsKey(PROPNAME_PREFERRED) && hashMap.containsKey(PROPNAME_CLIPBOARDFORMAT) && hashMap.containsKey(PROPNAME_DOCUMENTICONID) && hashMap.containsKey(PROPNAME_URLPATTERN) && hashMap.containsKey(PROPNAME_EXTENSIONS) && hashMap.containsKey(PROPNAME_UINAME))) {
                throw new Exception("Type \"" + string2 + "\" does not contain all neccessary properties for a 6.0/6.Y format.");
            }
            if (((Vector)hashMap.get(PROPNAME_EXTENSIONS)).isEmpty() && ((Vector)hashMap.get(PROPNAME_URLPATTERN)).isEmpty()) {
                throw new Exception("Type \"" + string2 + "\" does not contain any extension nor an url pattern.");
            }
            if (((HashMap)hashMap.get(PROPNAME_UINAME)).isEmpty()) {
                throw new Exception("Type \"" + string2 + "\" is not localized.");
            }
            if (n != 1) continue;
            if (!(hashMap.containsKey(PROPNAME_UIORDER) && hashMap.containsKey(PROPNAME_PREFERREDFILTER) && hashMap.containsKey(PROPNAME_DETECTSERVICE))) {
                throw new Exception("Type \"" + string2 + "\" does not contain all neccessary properties for a 6.Y format.");
            }
            if ((Integer)hashMap.get(PROPNAME_UIORDER) < 0) {
                throw new Exception("Type \"" + string2 + "\" has invalid value for prop UIOrder.");
            }
            if (((String)hashMap.get(PROPNAME_DETECTSERVICE)).length() < 1) {
                this.m_aDebug.setWarning("Type \"" + string2 + "\" has no detect service registered.");
            }
            if ((string = (String)hashMap.get(PROPNAME_PREFERREDFILTER)) == null || string.length() < 1) {
                this.m_aDebug.setWarning("Type \"" + string2 + "\" has no preferred filter ...");
                continue;
            }
            if (this.m_lFilters.containsKey(string)) continue;
            throw new Exception("Type \"" + string2 + "\" has no valid preferred filter registration [\"" + string + "\"].");
        }
    }

    public synchronized void validateFilters(int n) throws Exception {
        Iterator iterator = this.m_lFilters.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashMap hashMap = (HashMap)this.m_lFilters.get(string);
            if (hashMap == null) {
                throw new Exception("filter [" + string + "] dos not exist realy?!");
            }
            if (!(hashMap.containsKey(PROPNAME_DOCUMENTSERVICE) && hashMap.containsKey(PROPNAME_FILEFORMATVERSION) && hashMap.containsKey(PROPNAME_FILTERSERVICE) && hashMap.containsKey(PROPNAME_FLAGS) && hashMap.containsKey(PROPNAME_TEMPLATENAME) && hashMap.containsKey(PROPNAME_TYPE) && hashMap.containsKey(PROPNAME_UICOMPONENT) && hashMap.containsKey(PROPNAME_USERDATA))) {
                throw new Exception("Filter \"" + string + "\" does not contain all neccessary properties for a 6.0/6.Y format.");
            }
            if ((Integer)hashMap.get(PROPNAME_FLAGS) < 1) {
                throw new Exception("Filter \"" + string + "\" does not have a valid flag field.");
            }
            if (!this.m_lTypes.containsKey(hashMap.get(PROPNAME_TYPE))) {
                throw new Exception("Filter \"" + string + "\" is not registered for a well known type.");
            }
            if (n != 0) continue;
            if (!hashMap.containsKey(PROPNAME_ORDER) || !hashMap.containsKey(PROPNAME_UINAME)) {
                throw new Exception("Filter \"" + string + "\" does not contain all neccessary properties for a 6.0 format.");
            }
            if ((Integer)hashMap.get(PROPNAME_ORDER) < 0) {
                throw new Exception("Filter \"" + string + "\" does not have a valid Order value.");
            }
            if (!((HashMap)hashMap.get(PROPNAME_UINAME)).isEmpty()) continue;
            throw new Exception("Filter \"" + string + "\" is not localized.");
        }
    }

    public synchronized void transform60to6Y(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws Exception {
        Object object;
        Object object2;
        HashMap hashMap;
        Object object3;
        Cloneable cloneable;
        Object object4;
        Enumeration enumeration;
        if (this.m_lTypes.containsKey("macro")) {
            this.m_lTypes.remove("macro");
            this.m_aDebug.setDetailedInfo("superflous type \"macro\" was removed");
        }
        if (this.m_lFrameLoaders.containsKey("com.sun.star.comp.sfx2.SfxMacroLoader")) {
            this.m_lFrameLoaders.remove("com.sun.star.comp.sfx2.SfxMacroLoader");
            this.m_aDebug.setDetailedInfo("superflous frame loader \"com.sun.star.comp.sfx2.SfxMacroLoader\" was removed");
        }
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = new Vector();
        Iterator iterator = this.m_lFilters.keySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Object object5;
            String string;
            String string2;
            enumeration = (String)iterator.next();
            object4 = (HashMap)this.m_lFilters.get(enumeration);
            if (bl6 && ((String)((HashMap)object4).get(PROPNAME_DOCUMENTSERVICE)).length() < 1) {
                vector2.add(enumeration);
                continue;
            }
            String string3 = (String)((HashMap)object4).get(PROPNAME_TYPE);
            cloneable = (HashMap)this.m_lTypes.get(string3);
            object3 = (HashMap)((HashMap)object4).get(PROPNAME_UINAME);
            hashMap = (HashMap)((HashMap)cloneable).get(PROPNAME_UINAME);
            object2 = new HashMap<String, String>();
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                string = (String)hashMap.get(string2);
                ((HashMap)object2).put(string2, string);
            }
            object = ((HashMap)object3).keySet().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                string = (String)((HashMap)object3).get(string2);
                ((HashMap)object2).put(enumeration + ":" + string2, string);
            }
            ((HashMap)cloneable).put(PROPNAME_UINAME, object2);
            if (bl7 && ((String)((HashMap)object4).get(PROPNAME_FILTERSERVICE)).length() < 1) {
                ((HashMap)cloneable).put(PROPNAME_DETECTSERVICE, GENERIC_DETECTSERVICE);
            }
            int n2 = (Integer)((HashMap)object4).get(PROPNAME_FLAGS);
            string = (String)((HashMap)object4).get(PROPNAME_DOCUMENTSERVICE);
            if (string.length() > 0) {
                boolean bl8;
                boolean bl9 = bl8 = (n2 & 0x10000000) == 0x10000000;
                if (bl8) {
                    vector.add(object4);
                }
                if (((String)(object5 = (String)((HashMap)cloneable).get(PROPNAME_PREFERREDFILTER))).length() < 1) {
                    ((HashMap)cloneable).put(PROPNAME_PREFERREDFILTER, enumeration);
                } else {
                    boolean bl10;
                    HashMap hashMap2 = (HashMap)this.m_lFilters.get(object5);
                    n = (Integer)hashMap2.get(PROPNAME_FLAGS);
                    boolean bl11 = bl10 = (n & 0x10000000) == 0x10000000;
                    if (bl8 && bl10) {
                        StringBuffer stringBuffer = new StringBuffer(256);
                        stringBuffer.append("More the one preferred filter detected for the same type.\n");
                        stringBuffer.append("\ttype      = \"" + string3 + "\"\n");
                        stringBuffer.append("\tfilter[1] = \"" + (String)object5 + "\"\n");
                        stringBuffer.append("\tfilter[2] = \"" + enumeration + "\"\n");
                        throw new Exception(stringBuffer.toString());
                    }
                    if (bl8 && !bl10) {
                        ((HashMap)cloneable).put(PROPNAME_PREFERREDFILTER, enumeration);
                    }
                }
            }
            if (bl && (n2 & 1) == 1 && (n2 & 2) == 2) {
                n2 |= 0x800000;
                n2 &= 0xFFFFFFFE;
                ((HashMap)object4).put(PROPNAME_FLAGS, new Integer(n2 &= 0xFFFFFFFD));
            }
            if (bl2) {
                ((HashMap)object4).put(PROPNAME_FLAGS, new Integer(n2 &= 0xFFBFFFFF));
            }
            if (bl4) {
                ((HashMap)object4).put(PROPNAME_FLAGS, new Integer(n2 &= 0xFFF7FFFF));
            }
            Integer n3 = (Integer)((HashMap)object4).get(PROPNAME_ORDER);
            object5 = (Integer)((HashMap)cloneable).get(PROPNAME_UIORDER);
            int n4 = n3;
            n = (Integer)object5;
            if (n4 <= 0) continue;
            if (n < 1 || n > n4) {
                ((HashMap)cloneable).put(PROPNAME_UIORDER, n3);
                this.m_aDebug.setDetailedInfo("moved order value " + n3 + " from filter \"" + enumeration + "\" to type \"" + string3 + "\"");
                continue;
            }
            this.m_aDebug.setDetailedInfo("ignore order value [order=" + n3 + ",uiorder=" + object5 + "] for filter \"" + enumeration + "\" and type \"" + string3 + "\"");
        }
        enumeration = null;
        if (bl3) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object4 = (HashMap)enumeration.nextElement();
                int n = (Integer)((HashMap)object4).get(PROPNAME_FLAGS);
                ((HashMap)object4).put(PROPNAME_FLAGS, new Integer(n &= 0xEFFFFFFF));
            }
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            this.m_lFilters.remove(enumeration.nextElement());
        }
        iterator = this.m_lDetectServices.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            HashMap hashMap3 = (HashMap)this.m_lDetectServices.get(object4);
            cloneable = (Vector)hashMap3.get("Types");
            enumeration = ((Vector)cloneable).elements();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                hashMap = (HashMap)this.m_lTypes.get(object3);
                if (hashMap == null) {
                    this.m_aDebug.setWarning("Detector \"" + (String)object4 + "\" seem to be registered for unknown type \"" + (String)object3 + "\"");
                    continue;
                }
                object2 = hashMap.get(PROPNAME_DETECTSERVICE);
                if (object2 != null && ((String)object2).length() > 0) {
                    object = new StringBuffer(256);
                    ((StringBuffer)object).append("type \"" + (String)object3 + "\" has ambigous registrations of a detect service\n");
                    ((StringBuffer)object).append("\tdetect service[1] = \"" + (String)object2 + "\"\n");
                    ((StringBuffer)object).append("\tdetect service[2] = \"" + (String)object4 + "\"\n");
                    this.m_aDebug.setWarning(((StringBuffer)object).toString());
                }
                hashMap.put(PROPNAME_DETECTSERVICE, object4);
                this.m_aDebug.setGlobalInfo("move detector \"" + (String)object4 + "\" to type \"" + (String)object3 + "\"");
            }
        }
        this.m_lDetectServices.clear();
        iterator = this.m_lFrameLoaders.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            HashMap hashMap4 = (HashMap)this.m_lFrameLoaders.get(object4);
            cloneable = (Vector)hashMap4.get("Types");
            enumeration = ((Vector)cloneable).elements();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                hashMap = (HashMap)this.m_lTypes.get(object3);
                object2 = (String)hashMap.get(PROPNAME_FRAMELOADER);
                if (object2 != null && ((String)object2).length() > 0) {
                    object = new StringBuffer(256);
                    ((StringBuffer)object).append("type \"" + (String)object3 + "\" has ambigous registrations of a frame loader\n");
                    ((StringBuffer)object).append("\tframe loader[1] = \"" + (String)object2 + "\"\n");
                    ((StringBuffer)object).append("\tframe loader[2] = \"" + (String)object4 + "\"\n");
                    this.m_aDebug.setWarning(((StringBuffer)object).toString());
                }
                hashMap.put(PROPNAME_FRAMELOADER, object4);
                System.out.println("move loader \"" + (String)object4 + "\" to type \"" + (String)object3 + "\"");
            }
        }
        this.m_lFrameLoaders.clear();
        iterator = this.m_lContentHandlers.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            HashMap hashMap5 = (HashMap)this.m_lContentHandlers.get(object4);
            cloneable = (Vector)hashMap5.get("Types");
            enumeration = ((Vector)cloneable).elements();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                hashMap = (HashMap)this.m_lTypes.get(object3);
                object2 = (String)hashMap.get(PROPNAME_CONTENTHANDLER);
                if (object2 != null && ((String)object2).length() > 0) {
                    object = new StringBuffer(256);
                    ((StringBuffer)object).append("type \"" + (String)object3 + "\" has ambigous registrations of a content handler\n");
                    ((StringBuffer)object).append("\tcontent handler[1] = \"" + (String)object2 + "\"\n");
                    ((StringBuffer)object).append("\tcontent handler[2] = \"" + (String)object4 + "\"\n");
                    this.m_aDebug.setWarning(((StringBuffer)object).toString());
                }
                hashMap.put(PROPNAME_CONTENTHANDLER, object4);
                System.out.println("move handler \"" + (String)object4 + "\" to type \"" + (String)object3 + "\"");
            }
        }
        this.m_lContentHandlers.clear();
    }
}

