/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sun.star.help.HelpDatabases;
import com.sun.star.help.HelpIndexer;
import com.sun.star.help.HelpURLStreamHandlerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HelpCompiler {
    private static final String makeRelPrefix = ".." + File.separator;
    private static HelpURLStreamHandlerFactory urlHandler;
    private Hashtable streamTable;
    private String inputFile;
    private String src;
    private String module;
    private String lang;
    private String resEmbStylesheet;
    static HelpIndexer.ParseStuff stuff;

    public static void initURLHandler() {
        try {
            String string = HelpDatabases.getURLMode();
            urlHandler = new HelpURLStreamHandlerFactory(string);
            URL.setURLStreamHandlerFactory(urlHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public HelpCompiler(Hashtable hashtable, String string, String string2, String string3, String string4, String string5) {
        this.streamTable = hashtable;
        this.inputFile = string;
        this.src = string2;
        this.resEmbStylesheet = string3;
        this.module = string4;
        this.lang = string5;
        HelpURLStreamHandlerFactory.setMode(null);
    }

    private Object[] switchFind(Document document) {
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = document.getElementsByTagName("switchinline");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.getAttribute("select").equals("appl")) continue;
            NodeList nodeList2 = element.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeName().equals("caseinline")) {
                    String string = ((Element)nodeList2.item(j)).getAttribute("select");
                    hashSet.add(string);
                    continue;
                }
                if (!nodeList2.item(j).getNodeName().equals("defaultinline")) continue;
                hashSet.add("DEFAULT");
            }
        }
        hashSet.add("DEFAULT");
        return hashSet.toArray();
    }

    private Node clone(Node node, String string) {
        Node node2 = node.cloneNode(false);
        NodeList nodeList = node.getChildNodes();
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (node3 == null) continue;
            if ((node3.getNodeName().equals("switchinline") || node3.getNodeName().equals("switch")) && ((Element)node3).getAttribute("select").equals("appl")) {
                int n;
                NodeList nodeList2;
                Node node4;
                int n2;
                NodeList nodeList3 = node3.getChildNodes();
                if (string.equals("DEFAULT")) {
                    for (n2 = 0; n2 < nodeList3.getLength(); ++n2) {
                        node4 = nodeList3.item(n2);
                        if (!node4.getNodeName().equals("defaultinline")) continue;
                        nodeList2 = node4.getChildNodes();
                        for (n = 0; n < nodeList2.getLength(); ++n) {
                            node2.appendChild(this.clone(node4.getChildNodes().item(n), string));
                        }
                        continue block0;
                    }
                    continue;
                }
                for (n2 = 0; n2 < nodeList3.getLength(); ++n2) {
                    node4 = nodeList3.item(n2);
                    if (!node4.getNodeName().equals("caseinline") || !((Element)node4).getAttribute("select").equals(string)) continue;
                    nodeList2 = node4.getChildNodes();
                    for (n = 0; n < nodeList2.getLength(); ++n) {
                        node2.appendChild(this.clone(node4.getChildNodes().item(n), string));
                    }
                    continue block0;
                }
                continue;
            }
            node2.appendChild(this.clone(nodeList.item(i), string));
        }
        return node2;
    }

    static byte[] docToBytes(Document document) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        block7: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            String string = document.getClass().getName();
            try {
                if (string.equals("com.sun.xml.tree.XmlDocument")) {
                    object = Class.forName("com.sun.xml.tree.XmlDocument");
                    Method method = ((Class)object).getMethod("write", Class.forName("java.io.OutputStream"));
                    method.invoke((Object)document, byteArrayOutputStream);
                    break block7;
                }
                if (string.equals("org.apache.crimson.tree.XmlDocument")) {
                    object = Class.forName("org.apache.crimson.tree.XmlDocument");
                    Method method = ((Class)object).getMethod("write", Class.forName("java.io.OutputStream"));
                    method.invoke((Object)document, byteArrayOutputStream);
                    break block7;
                }
                if (string.equals("gnu.xml.dom.DomDocument")) {
                    object = Class.forName("gnu.xml.dom.ls.DomLSSerializer");
                    Method method = ((Class)object).getMethod("serialize", Class.forName("org.w3c.dom.Node"), Class.forName("java.io.OutputStream"));
                    Object obj = ((Class)object).newInstance();
                    method.invoke(obj, document, byteArrayOutputStream);
                    break block7;
                }
                if (string.equals("org.apache.xerces.dom.DocumentImpl") || string.equals("org.apache.xerces.dom.DeferredDocumentImpl")) {
                    object = Class.forName("org.apache.xml.serialize.XMLSerializer");
                    Constructor<?> constructor = ((Class)object).getConstructor(Class.forName("java.io.OutputStream"), Class.forName("org.apache.xml.serialize.OutputFormat"));
                    Method method = ((Class)object).getMethod("serialize", Class.forName("org.w3c.dom.Document"));
                    Object obj = constructor.newInstance(byteArrayOutputStream, null);
                    method.invoke(obj, document);
                    break block7;
                }
                throw new IOException("No appropriate API (JAXP/Xerces) to serialize XML document: " + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        object = byteArrayOutputStream.toByteArray();
        return object;
    }

    public boolean compile() throws UnsupportedEncodingException, IOException {
        Object object;
        Object object2;
        InputStreamReader inputStreamReader;
        String string;
        String string2;
        File file = new File(this.inputFile);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file.getAbsolutePath();
        }
        try {
            string = new File(this.src).getCanonicalPath();
        }
        catch (IOException iOException) {
            string = new File(this.inputFile).getAbsolutePath();
        }
        byte[] byArray = null;
        try {
            byArray = this.getSourceDocument(file.toURL().toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ERROR: malformed URL '" + this.inputFile + "': " + malformedURLException.getMessage());
            return false;
        }
        if (byArray == null) {
            System.err.println("ERROR: file not existing: " + string);
            System.exit(1);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("ERROR: unsupported Encoding '" + this.inputFile + "': " + unsupportedEncodingException.getMessage());
            return false;
        }
        InputSource inputSource = new InputSource(inputStreamReader);
        inputSource.setEncoding("UTF8");
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setValidating(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputSource);
        }
        catch (Exception exception) {
            System.err.println("ERROR: XmlDocument.createXmlDocument() failed for '" + this.inputFile + "': " + exception.getMessage());
            return false;
        }
        object2 = null;
        object = null;
        String string3 = null;
        Object[] objectArray = this.switchFind(document);
        for (int i = 0; i < objectArray.length; ++i) {
            String string4 = (String)objectArray[i];
            Element element = (Element)this.clone(document.getDocumentElement(), string4);
            myparser myparser2 = new myparser((String)object2, (String)object, string3);
            myparser2.traverse(element);
            object2 = myparser2.documentId;
            object = myparser2.fileName;
            string3 = myparser2.title;
            this.addEntryToJarFile(string4, "text", HelpCompiler.docToBytes(element.getOwnerDocument()));
            this.addEntryToJarFile(string4, "hidlist", myparser2.hidlist);
            this.addEntryToJarFile(string4, "helptexts", myparser2.helptexts);
            this.addEntryToJarFile(string4, "keywords", myparser2.keywords);
        }
        try {
            this.addEntryToJarFile("document", "id", object2 != null ? ((String)object2).getBytes("UTF8") : "".getBytes("UTF8"));
            this.addEntryToJarFile("document", "path", object != null ? ((String)object).getBytes("UTF8") : "".getBytes("UTF8"));
            this.addEntryToJarFile("document", "title", string3 != null ? string3.getBytes("UTF8") : "".getBytes("UTF8"));
            String string5 = this.module;
            if (object != null && ((String)object).length() != 0 && ((String)object).startsWith("/text/")) {
                string5 = ((String)object).substring("/text/".length());
                string5 = string5.substring(0, string5.indexOf(47));
            }
            this.addEntryToJarFile("document", "module", string5.getBytes("UTF8"));
        }
        catch (IOException iOException) {
            System.err.println("ERROR: IOException in compile(): '" + iOException.getMessage());
            return false;
        }
        return true;
    }

    private byte[] getSourceDocument(String string) {
        if (stuff == null) {
            stuff = new HelpIndexer.ParseStuff(this.resEmbStylesheet);
            stuff.setParameter("Language", this.lang);
            try {
                stuff.setParameter("fsroot", new File(this.src).toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("ERROR: malformed URL '" + this.src + "': " + malformedURLException.getMessage());
                System.exit(1);
            }
        }
        return stuff.parse(string);
    }

    private String dump(Node node) {
        String string = new String();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                string = string + this.dump(nodeList.item(i));
            }
        }
        if (node.getNodeType() == 3) {
            string = string + ((Text)node).getData();
        }
        return string;
    }

    private void addEntryToJarFile(String string, String string2, Object object) {
        if (object == null) {
            return;
        }
        this.streamTable.put((string + "/" + string2).toLowerCase().trim(), object);
    }

    private void addEntryToJarFile(String string, String string2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.streamTable.put((string + "/" + string2).toLowerCase().trim(), byArray);
    }

    static {
        stuff = null;
    }

    public class myparser {
        HashSet hidlist = new HashSet();
        HashSet extendedHelpText = new HashSet();
        Hashtable keywords = new Hashtable();
        Hashtable helptexts = new Hashtable();
        String documentId = null;
        String fileName = null;
        String title = null;

        public myparser(String string, String string2, String string3) {
            this.documentId = string;
            this.fileName = string2;
            this.title = string3;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void traverse(Node node) {
            Node node2 = node.getFirstChild();
            while (true) {
                block17: {
                    block13: {
                        NodeList nodeList;
                        LinkedList<String> linkedList;
                        String string;
                        block19: {
                            Object object4;
                            Object object2;
                            block15: {
                                block18: {
                                    block16: {
                                        block14: {
                                            block12: {
                                                if (node2 == null) {
                                                    return;
                                                }
                                                if (this.fileName != null || !node2.getNodeName().equals("filename")) break block12;
                                                object2 = node2.getChildNodes();
                                                object4 = object2.item(0);
                                                if (object4.getNodeType() == 3) {
                                                    this.fileName = ((Text)object4).getData();
                                                }
                                                break block13;
                                            }
                                            if (this.title != null || !node2.getNodeName().equals("title")) break block14;
                                            this.title = HelpCompiler.this.dump(node2);
                                            if (this.title == null || this.title.length() == 0) {
                                                this.title = "<notitle>";
                                            }
                                            break block13;
                                        }
                                        if (!node2.getNodeName().equals("bookmark")) break block15;
                                        object2 = (Element)node2;
                                        object4 = object2.getAttribute("branch");
                                        Object object3 = null;
                                        string = object2.getAttribute("id");
                                        if (!((String)object4).startsWith("hid")) break block16;
                                        int n = ((String)object4).indexOf(47);
                                        if (n == -1) break block17;
                                        object3 = ((String)object4).substring(1 + n);
                                        if (this.documentId == null) {
                                            this.documentId = object3;
                                        }
                                        this.extendedHelpText.add(object3);
                                        this.hidlist.add(string == null || string.length() == 0 ? object3 : (String)object3 + "#" + string);
                                        break block13;
                                    }
                                    if (!((String)object4).equals("index")) break block18;
                                    linkedList = new LinkedList<String>();
                                    nodeList = object2.getChildNodes();
                                    break block19;
                                }
                                if (!((String)object4).equals("contents")) {
                                    // empty if block
                                }
                                break block13;
                            }
                            if (node2.getNodeName().equals("ahelp")) {
                                object2 = HelpCompiler.this.dump(node2).trim();
                                object4 = null;
                                for (Object object4 : this.extendedHelpText) {
                                    this.helptexts.put(object4, object2);
                                }
                                if (!this.extendedHelpText.isEmpty()) {
                                    this.extendedHelpText = new HashSet();
                                }
                            }
                            break block13;
                        }
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            boolean bl;
                            Node node3 = nodeList.item(i);
                            if (!node3.getNodeName().equals("bookmark_value")) continue;
                            String string2 = ((Element)node3).getAttribute("embedded");
                            boolean bl2 = bl = string2 != null && "true".equals(string2.toLowerCase());
                            if (bl) continue;
                            String string3 = HelpCompiler.this.dump(node3);
                            int n = string3.indexOf(59);
                            if (n != -1) {
                                String string4 = string3.substring(0, n).trim();
                                String string5 = string3.substring(1 + n).trim();
                                string3 = string4 + ";" + string5;
                            }
                            linkedList.add(string3);
                        }
                        if (!linkedList.isEmpty()) {
                            this.keywords.put(string, linkedList);
                        }
                    }
                    this.traverse(node2);
                }
                node2 = node2.getNextSibling();
            }
        }
    }
}

