/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;

public abstract class StoredContainer
implements Cloneable {
    DataView view;

    StoredContainer(DataView dataView) {
        this.view = dataView;
    }

    public final boolean isWriteAllowed() {
        return this.view.isWriteAllowed();
    }

    public final boolean isDirtyReadAllowed() {
        return this.view.isDirtyReadAllowed();
    }

    public final boolean isDirtyReadEnabled() {
        return this.view.isDirtyReadEnabled();
    }

    public final boolean isAutoCommit() {
        return this.view.isAutoCommit();
    }

    public final boolean isTransactional() {
        return this.view.isTransactional();
    }

    final StoredContainer dirtyReadClone() {
        if (!this.isDirtyReadAllowed()) {
            return this;
        }
        try {
            StoredContainer storedContainer = (StoredContainer)this.clone();
            storedContainer.view = storedContainer.view.dirtyReadView(true);
            return storedContainer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    final StoredContainer autoCommitClone() {
        if (!this.isTransactional()) {
            return this;
        }
        try {
            StoredContainer storedContainer = (StoredContainer)this.clone();
            storedContainer.view = storedContainer.view.autoCommitView(true);
            return storedContainer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final boolean areDuplicatesAllowed() {
        return this.view.areDuplicatesAllowed();
    }

    public final boolean areDuplicatesOrdered() {
        return this.view.areDuplicatesOrdered();
    }

    public final boolean areKeysRenumbered() {
        return this.view.areKeysRenumbered();
    }

    public final boolean isOrdered() {
        return this.view.isOrdered();
    }

    public final boolean isIndexed() {
        return this.view.getIndex() != null;
    }

    public int size() {
        throw new UnsupportedOperationException("collection size not available");
    }

    public boolean isEmpty() {
        try {
            return this.view.isEmpty();
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public void clear() {
        boolean bl = this.beginAutoCommit();
        try {
            this.view.clear(null);
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    Object get(Object object) {
        try {
            Object[] objectArray = new Object[1];
            int n = this.view.get(object, null, Db.DB_SET, false, objectArray);
            return n == 0 ? objectArray[0] : null;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    Object put(Object object, Object object2) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.put(object, object2, 0, objectArray);
            this.commitAutoCommit(bl);
            return objectArray[0];
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    final boolean removeKey(Object object, Object[] objectArray) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            boolean bl2 = false;
            int n = dataCursor.get(object, null, Db.DB_SET, true);
            while (n == 0) {
                dataCursor.delete();
                bl2 = true;
                if (objectArray != null && objectArray[0] == null) {
                    objectArray[0] = dataCursor.getCurrentValue();
                }
                n = dataCursor.get(null, null, Db.DB_NEXT_DUP, true);
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    boolean containsKey(Object object) {
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            int n = dataCursor.get(object, null, Db.DB_SET, false);
            boolean bl = n == 0;
            this.closeCursor(dataCursor);
            return bl;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    final boolean removeValue(Object object) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            int n = dataCursor.find(object, true);
            if (n == 0) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return n == 0;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    boolean containsValue(Object object) {
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            int n = dataCursor.find(object, true);
            boolean bl = n == 0;
            this.closeCursor(dataCursor);
            return bl;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    final void closeCursor(DataCursor dataCursor) {
        if (dataCursor != null) {
            try {
                dataCursor.close();
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
    }

    final boolean beginAutoCommit() {
        if (this.isAutoCommit()) {
            try {
                CurrentTransaction currentTransaction = this.view.getCurrentTxn();
                if (currentTransaction.getTxn() == null) {
                    currentTransaction.beginTxn();
                    return true;
                }
            }
            catch (DbException dbException) {
                throw new RuntimeExceptionWrapper(dbException);
            }
        }
        return false;
    }

    final void commitAutoCommit(boolean bl) throws DbException {
        if (bl) {
            this.view.getCurrentTxn().commitTxn();
        }
    }

    final RuntimeException handleException(Exception exception, boolean bl) {
        if (bl) {
            try {
                this.view.getCurrentTxn().abortTxn();
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return StoredContainer.convertException(exception);
    }

    static RuntimeException convertException(Exception exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeExceptionWrapper(exception);
    }
}

