/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastOutputStream
extends OutputStream {
    public static final int DEFAULT_INIT_SIZE = 100;
    public static final int DEFAULT_BUMP_SIZE = 100;
    private int len;
    private int bumpLen;
    private byte[] buf;

    public FastOutputStream() {
        this.buf = new byte[100];
        this.bumpLen = 100;
    }

    public FastOutputStream(int n) {
        this.buf = new byte[n];
        this.bumpLen = 100;
    }

    public FastOutputStream(int n, int n2) {
        this.buf = new byte[n];
        this.bumpLen = n2;
    }

    public FastOutputStream(byte[] byArray) {
        this.buf = byArray;
        this.bumpLen = 100;
    }

    public FastOutputStream(byte[] byArray, int n) {
        this.buf = byArray;
        this.bumpLen = n;
    }

    public int size() {
        return this.len;
    }

    public void reset() {
        this.len = 0;
    }

    public void write(int n) throws IOException {
        if (this.len + 1 > this.buf.length) {
            this.bump(1);
        }
        this.buf[this.len++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        int n = this.len + byArray.length - this.buf.length;
        if (n > 0) {
            this.bump(n);
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.buf[this.len++] = byArray[i];
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.len + n2 - this.buf.length;
        if (n3 > 0) {
            this.bump(n3);
        }
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            this.buf[this.len++] = byArray[i];
        }
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.len);
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.len, string);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.len];
        for (int i = 0; i < this.len; ++i) {
            byArray[i] = this.buf[i];
        }
        return byArray;
    }

    public void toByteArray(byte[] byArray, int n) {
        int n2 = byArray.length > this.len ? this.len : byArray.length;
        for (int i = n; i < n2; ++i) {
            byArray[i] = this.buf[i];
        }
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.len;
    }

    public void makeSpace(int n) {
        int n2 = this.len + n - this.buf.length;
        if (n2 > 0) {
            this.bump(n2);
        }
    }

    public void addSize(int n) {
        this.len += n;
    }

    private void bump(int n) {
        byte[] byArray = new byte[this.buf.length + n + this.bumpLen];
        for (int i = 0; i < this.len; ++i) {
            byArray[i] = this.buf[i];
        }
        this.buf = byArray;
    }
}

