/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.ProjectCookie;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CallableSystemAction;

public class OpenProjectAction
extends CallableSystemAction
implements Runnable {
    private static final long serialVersionUID = -1785983127137412341L;
    static /* synthetic */ Class class$org$openide$actions$OpenProjectAction;
    static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public String getName() {
        return NbBundle.getMessage(class$org$openide$actions$OpenProjectAction == null ? (class$org$openide$actions$OpenProjectAction = OpenProjectAction.class$("org.openide.actions.OpenProjectAction")) : class$org$openide$actions$OpenProjectAction, "OpenProject");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$OpenProjectAction == null ? (class$org$openide$actions$OpenProjectAction = OpenProjectAction.class$("org.openide.actions.OpenProjectAction")) : class$org$openide$actions$OpenProjectAction);
    }

    public String iconResource() {
        return "org/openide/resources/actions/openProject.gif";
    }

    public void performAction() {
        try {
            Panel panel = new Panel();
            Node node = TopManager.getDefault().getNodeOperation().select(NbBundle.getMessage(class$org$openide$actions$OpenProjectAction == null ? (class$org$openide$actions$OpenProjectAction = OpenProjectAction.class$("org.openide.actions.OpenProjectAction")) : class$org$openide$actions$OpenProjectAction, "CTL_OpenTitle"), NbBundle.getMessage(class$org$openide$actions$OpenProjectAction == null ? (class$org$openide$actions$OpenProjectAction = OpenProjectAction.class$("org.openide.actions.OpenProjectAction")) : class$org$openide$actions$OpenProjectAction, "CTL_OpenDescr"), OpenProjectAction.getProjectRoot(panel), panel)[0];
            ProjectCookie projectCookie = (ProjectCookie)node.getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = OpenProjectAction.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie);
            TopManager.getDefault().openProject(projectCookie);
        }
        catch (UserCancelException userCancelException) {
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(iOException);
        }
    }

    private static Node getProjectRoot(DataFilter dataFilter) {
        DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
        Children children = dataFolder.createNodeChildren(dataFilter);
        children = new ProjectChildren(new AbstractNode(children));
        return new PresentationFilterNode(dataFolder.getNodeDelegate(), children);
    }

    public void run() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PresentationFilterNode
    extends FilterNode {
        public PresentationFilterNode(Node node, Children children) {
            super(node, children);
        }

        public PresentationFilterNode(Node node) {
            super(node);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }
    }

    private static class ProjectChildren
    extends FilterNode.Children {
        public ProjectChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            DataFolder dataFolder = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = OpenProjectAction.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (dataFolder == null) {
                return new PresentationFilterNode(node, Children.LEAF);
            }
            return new PresentationFilterNode(node, new ProjectChildren(node));
        }
    }

    private static class Panel
    implements NodeAcceptor,
    DataFilter {
        static final long serialVersionUID = -3217011757079457914L;

        Panel() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return dataObject.getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = OpenProjectAction.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie) != null;
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray.length != 1) {
                return false;
            }
            return nodeArray[0].getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = OpenProjectAction.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie) != null;
        }
    }
}

