/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;

public abstract class URLMapper {
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int NETWORK = 2;
    private static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$URLMapper == null ? (class$org$openide$filesystems$URLMapper = URLMapper.class$("org.openide.filesystems.URLMapper")) : class$org$openide$filesystems$URLMapper));
    static /* synthetic */ Class class$org$openide$filesystems$URLMapper;

    public static URL findURL(FileObject fileObject, int n) {
        URL uRL = URLMapper.getURLBasicImpl(fileObject, n);
        if (uRL != null) {
            return uRL;
        }
        Iterator iterator = result.allInstances().iterator();
        while (iterator.hasNext()) {
            URLMapper uRLMapper = (URLMapper)iterator.next();
            uRL = uRLMapper.getURL(fileObject, n);
            if (uRL == null) continue;
            return uRL;
        }
        if (n == 0) {
            try {
                uRL = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
        }
        return uRL;
    }

    public abstract URL getURL(FileObject var1, int var2);

    public static FileObject[] findFileObjects(URL uRL) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        FileObject[] fileObjectArray = URLMapper.geFileObjectBasicImpl(uRL);
        if (fileObjectArray != null) {
            hashSet.addAll(Arrays.asList(fileObjectArray));
        }
        Iterator iterator = result.allInstances().iterator();
        while (iterator.hasNext()) {
            URLMapper uRLMapper = (URLMapper)iterator.next();
            fileObjectArray = uRLMapper.getFileObjects(uRL);
            if (fileObjectArray == null) continue;
            hashSet.addAll(Arrays.asList(fileObjectArray));
        }
        fileObjectArray = new FileObject[hashSet.size()];
        hashSet.toArray(fileObjectArray);
        return fileObjectArray;
    }

    public abstract FileObject[] getFileObjects(URL var1);

    private static URL getURLBasicImpl(FileObject fileObject, int n) {
        if (fileObject == null) {
            return null;
        }
        if (n == 2) {
            return null;
        }
        URL uRL = null;
        FileSystem fileSystem = null;
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
        if (fileSystem instanceof LocalFileSystem) {
            if (n != 1) {
                return null;
            }
            LocalFileSystem localFileSystem = (LocalFileSystem)fileSystem;
            File file = localFileSystem.getRootDirectory();
            if (file == null) {
                return null;
            }
            try {
                uRL = new URL(file.toURL(), fileObject.toString());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        } else if (fileSystem instanceof JarFileSystem) {
            if (n != 1) {
                return null;
            }
            if (fileObject.isFolder()) {
                return null;
            }
            JarFileSystem jarFileSystem = (JarFileSystem)fileSystem;
            File file = jarFileSystem.getJarFile();
            if (file == null) {
                return null;
            }
            try {
                uRL = new URL("jar:" + file.toURL().toString() + "!/" + fileObject.toString());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        } else {
            if (fileSystem instanceof MultiFileSystem) {
                FileObject fileObject2 = ((MultiFileObject)fileObject).getLeader();
                return URLMapper.getURLBasicImpl(fileObject2, n);
            }
            if (fileSystem instanceof XMLFileSystem) {
                URL uRL2 = null;
                try {
                    uRL2 = ((XMLFileSystem)fileSystem).getURL(fileObject.toString());
                    if (uRL2 == null) {
                        return null;
                    }
                    if (n == 0) {
                        return uRL2;
                    }
                    boolean bl = uRL2.getProtocol().startsWith("nbres");
                    if (n == 1 && !bl) {
                        return uRL2;
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }
        return uRL;
    }

    private static FileObject[] geFileObjectBasicImpl(URL uRL) {
        String string = uRL.getProtocol();
        if (string.equals("nbfs")) {
            FileObject[] fileObjectArray;
            FileObject fileObject = FileURL.decodeURL(uRL);
            if (fileObject == null) {
                fileObjectArray = null;
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = fileObject;
            }
            return fileObjectArray;
        }
        if (string.equals("jar")) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection != null && uRLConnection instanceof JarURLConnection) {
                    URL uRL2 = ((JarURLConnection)uRLConnection).getJarFileURL();
                    String string2 = new File(uRL2.getFile()).getCanonicalPath();
                    FileSystem fileSystem = Repository.getDefault().findFileSystem(string2);
                    if (fileSystem != null && fileSystem instanceof JarFileSystem) {
                        FileObject[] fileObjectArray;
                        FileObject fileObject = fileSystem.findResource(((JarURLConnection)uRLConnection).getEntryName());
                        if (fileObject == null) {
                            fileObjectArray = null;
                        } else {
                            FileObject[] fileObjectArray3 = new FileObject[1];
                            fileObjectArray = fileObjectArray3;
                            fileObjectArray3[0] = fileObject;
                        }
                        return fileObjectArray;
                    }
                }
            }
            catch (IOException iOException) {
                return null;
            }
            return null;
        }
        if (string.equals("file")) {
            try {
                File file = new File(uRL.getFile()).getCanonicalFile();
                FileObject[] fileObjectArray = FileUtil.fromFile(file);
                if (fileObjectArray != null && fileObjectArray.length > 0) {
                    return fileObjectArray;
                }
            }
            catch (IOException iOException) {
                return null;
            }
            return null;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

