/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ConvWatchCancelException;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.OSHelper;
import convwatch.OfficePrint;
import helper.ProcessHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import util.utils;

public class MSOfficePrint {
    private String m_sPrinterName;

    public void setPrinterName(String string) {
        this.m_sPrinterName = string;
    }

    static boolean isWordDocument(String string) {
        return string.toLowerCase().endsWith(".doc") || string.toLowerCase().endsWith(".rtf") || string.toLowerCase().endsWith(".dot");
    }

    static boolean isExcelDocument(String string) {
        return string.toLowerCase().endsWith(".xls");
    }

    static boolean isPowerPointDocument(String string) {
        return string.toLowerCase().endsWith(".pps") || string.toLowerCase().endsWith(".ppt");
    }

    public static boolean isMSOfficeDocumentFormat(String string) {
        String string2 = FileHelper.getSuffix(string);
        if (MSOfficePrint.isWordDocument(string2)) {
            return true;
        }
        if (MSOfficePrint.isExcelDocument(string2)) {
            return true;
        }
        if (MSOfficePrint.isPowerPointDocument(string2)) {
            return true;
        }
        return string2.toLowerCase().endsWith(".xml");
    }

    public void storeToFileWithMSOffice(GraphicalTestArguments graphicalTestArguments, String string, String string2) throws ConvWatchCancelException, IOException {
        String string3 = FileHelper.getSuffix(string);
        String string4 = graphicalTestArguments.getExportFilterName();
        ArrayList arrayList = new ArrayList();
        if (MSOfficePrint.isWordDocument(string3)) {
            arrayList = this.createWordStoreHelper();
        } else if (MSOfficePrint.isExcelDocument(string3)) {
            arrayList = this.createExcelStoreHelper();
        } else if (!MSOfficePrint.isPowerPointDocument(string3)) {
            if (string3.toLowerCase().equals(".xml")) {
                if (graphicalTestArguments.getDefaultXMLFormatApp().toLowerCase().equals("excel")) {
                    arrayList = this.createExcelStoreHelper();
                }
            } else {
                GlobalLogWriter.get().println("No Microsoft Office document format found.");
                throw new ConvWatchCancelException("No MS office document format found.");
            }
        }
        if (arrayList != null) {
            if (string4 == null) {
                string4 = "";
            }
            arrayList.add(string);
            arrayList.add(string4);
            arrayList.add(string2);
            this.realStartCommand(arrayList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printToFileWithMSOffice(GraphicalTestArguments graphicalTestArguments, String string, String string2) throws ConvWatchCancelException, IOException {
        String string3;
        String string4;
        String string5 = FileHelper.getSuffix(string);
        this.setPrinterName(graphicalTestArguments.getPrinterName());
        ArrayList arrayList = new ArrayList();
        if (MSOfficePrint.isWordDocument(string5)) {
            arrayList = this.createWordPrintHelper();
        } else if (MSOfficePrint.isExcelDocument(string5)) {
            arrayList = this.createExcelPrintHelper();
        } else if (MSOfficePrint.isPowerPointDocument(string5)) {
            arrayList = this.createPowerPointPrintHelper();
        } else if (string5.toLowerCase().equals(".xml")) {
            string4 = this.getOfficeType(string);
            if (string4.equals("excel")) {
                arrayList = this.createExcelPrintHelper();
            } else {
                if (!string4.equals("word")) return;
                arrayList = this.createWordPrintHelper();
            }
        } else {
            GlobalLogWriter.get().println("No Microsoft Office document format found.");
            throw new ConvWatchCancelException("No Mircosoft Office document format found.");
        }
        if (!arrayList.isEmpty()) {
            string4 = this.m_sPrinterName;
            if (string4 == null) {
                string4 = "";
            }
            arrayList.add(string);
            arrayList.add(this.m_sPrinterName);
            arrayList.add(string2);
            this.realStartCommand(arrayList);
        }
        if (!(string4 = System.getProperty("user.home")).endsWith(string3 = System.getProperty("file.separator"))) {
            string4 = string4 + string3;
        }
        graphicalTestArguments.getPerformance().readWordValuesFromFile(string4 + "msofficeloadtimes.txt");
        OfficePrint.createInfoFile(string2, graphicalTestArguments, "msoffice");
        OfficePrint.waitInSeconds(2, "Give Microsoft Office some time to print.");
    }

    public void realStartCommand(ArrayList arrayList) throws ConvWatchCancelException {
        if (arrayList.isEmpty()) {
            throw new ConvWatchCancelException("Given list is empty.");
        }
        try {
            int n = arrayList.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                if (string == null) {
                    string = "";
                }
                if (string.length() == 0) {
                    string = "\"\"";
                }
                stringArray[i] = new String(string);
            }
            if (!OSHelper.isWindows()) {
                throw new ConvWatchCancelException("We doesn't work within windows environment.");
            }
            ProcessHandler processHandler = new ProcessHandler(stringArray);
            boolean bl = processHandler.executeSynchronously();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ConvWatchCancelException("Given list is too short.");
        }
    }

    ArrayList createWordPrintHelper() throws IOException {
        String string = utils.getUsersTempDir();
        String string2 = System.getProperty("line.separator");
        String string3 = System.getProperty("file.separator");
        String string4 = "printViaWord.pl";
        ArrayList arrayList = this.searchLocalFile(string4);
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        String string5 = string + string3 + string4;
        File file = new File(string5);
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                          " + string2);
        fileWriter.write("   if 0;                                                                                     " + string2);
        fileWriter.write("use strict;                                                                                  " + string2);
        fileWriter.write("use Time::HiRes;                                                                             " + string2);
        fileWriter.write("if ( $^O ne \"MSWin32\")                                                                     " + string2);
        fileWriter.write("{                                                                                            " + string2);
        fileWriter.write("   print 'Windows only.\\n';                                                                  " + string2);
        fileWriter.write("   print_usage();                                                                            " + string2);
        fileWriter.write("   exit(1);                                                                                  " + string2);
        fileWriter.write("}                                                                                            " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("use Win32::OLE;                                                                              " + string2);
        fileWriter.write("use Win32::OLE::Const 'Microsoft Word';                                                      " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("# ------ usage ------                                                                        " + string2);
        fileWriter.write("sub print_usage()                                                                            " + string2);
        fileWriter.write("{                                                                                            " + string2);
        fileWriter.write("    print STDERR \"Usage: word_print.pl  <Word file> <name of printer> <output file> .\\n     " + string2);
        fileWriter.write("                  Please use the same string for the name of the printer as you can find \\n  " + string2);
        fileWriter.write("                  under Start-Control Panel-Printer and Faxes  \\n                        " + string2);
        fileWriter.write("                  The name could look like the the following line: \\n                        " + string2);
        fileWriter.write("                  Apple LaserWriter II NT v47.0 \\n                                           " + string2);
        fileWriter.write("                  Sample command line: \\n                                                    " + string2);
        fileWriter.write("                  execl_print.pl  c:\\book1.doc Apple LaserWriter II NT v47.0 c:\\output\\book1.ps \\n\";  " + string2);
        fileWriter.write("}                                                                                            " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("if ($#ARGV != 2)                                                                             " + string2);
        fileWriter.write("{                                                                                            " + string2);
        fileWriter.write("   print 'Too less arguments.\\n';                                                            " + string2);
        fileWriter.write("   print_usage();                                                                            " + string2);
        fileWriter.write("   exit(1);                                                                                  " + string2);
        fileWriter.write("}                                                                                            " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("my $startWordTime = Time::HiRes::time(); " + string2);
        fileWriter.write("my $Word = Win32::OLE->new('Word.Application');                                              " + string2);
        fileWriter.write("my $stopWordTime = Time::HiRes::time() - $startWordTime; " + string2);
        fileWriter.write("# $Word->{'Visible'} = 1;         # if you want to see what's going on                       " + string2);
        fileWriter.write("# , ReadOnly => 1})" + string2);
        fileWriter.write(string2);
        fileWriter.write("my $startLoadWordTime = Time::HiRes::time(); " + string2);
        fileWriter.write("$Word->Documents->Open({Filename => $ARGV[0]})                                               " + string2);
        fileWriter.write("    || die('Unable to open document ', Win32::OLE->LastError());                             " + string2);
        fileWriter.write("my $stopLoadWordTime = Time::HiRes::time() - $startLoadWordTime; " + string2);
        fileWriter.write(string2);
        fileWriter.write("my $startPrintWordTime = Time::HiRes::time(); " + string2);
        fileWriter.write("my $oldActivePrinte = $Word->{ActivePrinter} ;                                               " + string2);
        fileWriter.write("$Word->{ActivePrinter} = $ARGV[1];                                                           " + string2);
        fileWriter.write("$Word->ActiveDocument->PrintOut({                                                            " + string2);
        fileWriter.write("                                 Background => 0,                                            " + string2);
        fileWriter.write("                                 Append     => 0,                                            " + string2);
        fileWriter.write("                                 Range      => wdPrintAllDocument,                           " + string2);
        fileWriter.write("                                 Item       => wdPrintDocumentContent,                       " + string2);
        fileWriter.write("                                 Copies     => 1,                                            " + string2);
        fileWriter.write("                                 PageType   => wdPrintAllPages,                              " + string2);
        fileWriter.write("                                 PrintToFile => 1,                                           " + string2);
        fileWriter.write("                                 OutputFileName => $ARGV[2]                                  " + string2);
        fileWriter.write("  });                                                                                        " + string2);
        fileWriter.write("$Word->{ActivePrinter} = $oldActivePrinte;                                                   " + string2);
        fileWriter.write("my $stopPrintWordTime = Time::HiRes::time() - $startPrintWordTime;" + string2);
        fileWriter.write("# ActiveDocument.Close(SaveChanges:=WdSaveOptions.wdDoNotSaveChanges)" + string2);
        fileWriter.write("my $sVersion = $Word->Application->Version();" + string2);
        fileWriter.write("$Word->ActiveDocument->Close({SaveChanges => 0});                                                           " + string2);
        fileWriter.write("$Word->Quit();                                                                               " + string2);
        fileWriter.write("local *FILE;" + string2);
        fileWriter.write("if (open(FILE, \">$ENV{HOME}/msofficeloadtimes.txt\"))" + string2);
        fileWriter.write("{" + string2);
        fileWriter.write("   print FILE \"name=$ARGV[0]\\n\";" + string2);
        fileWriter.write("   print FILE \"WordVersion=$sVersion\\n\";" + string2);
        fileWriter.write("   print FILE \"WordStartTime=$stopWordTime\\n\";" + string2);
        fileWriter.write("   print FILE \"WordLoadTime=$stopLoadWordTime\\n\";" + string2);
        fileWriter.write("   print FILE \"WordPrintTime=$stopPrintWordTime\\n\";" + string2);
        fileWriter.write("   close(FILE);" + string2);
        fileWriter.write("}" + string2);
        fileWriter.close();
        arrayList.add("perl");
        arrayList.add(string5);
        return arrayList;
    }

    ArrayList searchLocalFile(String string) {
        String string2 = System.getProperty("user.dir");
        String string3 = System.getProperty("file.separator");
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string2 + string3 + string);
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("Search for local existance of " + file.getAbsolutePath());
        }
        if (file.exists()) {
            if (FileHelper.isDebugEnabled()) {
                GlobalLogWriter.get().println("OK, found it, use this instead the internal one.");
            }
            String string4 = file.getAbsolutePath();
            arrayList.add("perl");
            arrayList.add(string4);
            return arrayList;
        }
        return arrayList;
    }

    ArrayList createWordStoreHelper() throws IOException {
        String string = utils.getUsersTempDir();
        String string2 = System.getProperty("line.separator");
        String string3 = System.getProperty("file.separator");
        String string4 = "saveViaWord.pl";
        ArrayList arrayList = this.searchLocalFile(string4);
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        String string5 = string + string3 + string4;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a perl script: " + string5);
        }
        File file = new File(string5);
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                          " + string2);
        fileWriter.write("   if 0;                                                                                     " + string2);
        fileWriter.write("use strict;                                                                                  " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("if ( $^O ne \"MSWin32\")                                                                     " + string2);
        fileWriter.write("{                                                                                            " + string2);
        fileWriter.write("   print 'Windows only.\\n';                                                                  " + string2);
        fileWriter.write("   print_usage();                                                                            " + string2);
        fileWriter.write("   exit(1);                                                                                  " + string2);
        fileWriter.write("}                                                                                            " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("use Win32::OLE;                                                                              " + string2);
        fileWriter.write("use Win32::OLE::Const 'Microsoft Word';                                                      " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("# ------ usage ------                                                                        " + string2);
        fileWriter.write("sub print_usage()                                                                            " + string2);
        fileWriter.write("{                                                                                            " + string2);
        fileWriter.write("    print STDERR \"Usage: storeViaWord.pl  <Word file> <output filer> <output file> \\n\"     " + string2);
        fileWriter.write("}                                                                                            " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("if ($#ARGV != 2)                                                                             " + string2);
        fileWriter.write("{                                                                                            " + string2);
        fileWriter.write("   print 'Too less arguments.\\n';                                                            " + string2);
        fileWriter.write("   print_usage();                                                                            " + string2);
        fileWriter.write("   exit(1);                                                                                  " + string2);
        fileWriter.write("}                                                                                            " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("                                                                                             " + string2);
        fileWriter.write("my $Word = Win32::OLE->new('Word.Application');                                              " + string2);
        fileWriter.write("# $Word->{'Visible'} = 1;         # if you want to see what's going on                       " + string2);
        fileWriter.write("my $Book = $Word->Documents->Open($ARGV[0])                                                             " + string2);
        fileWriter.write("    || die('Unable to open document ', Win32::OLE->LastError());                             " + string2);
        fileWriter.write("# my $oldActivePrinte = $Word->{ActivePrinter} ;                                               " + string2);
        fileWriter.write("# $Word->{ActivePrinter} = $ARGV[1];                                                           " + string2);
        fileWriter.write("# $Word->ActiveDocument->PrintOut({                                                            " + string2);
        fileWriter.write("#                                  Background => 0,                                            " + string2);
        fileWriter.write("#                                  Append     => 0,                                            " + string2);
        fileWriter.write("#                                  Range      => wdPrintAllDocument,                           " + string2);
        fileWriter.write("#                                  Item       => wdPrintDocumentContent,                       " + string2);
        fileWriter.write("#                                  Copies     => 1,                                            " + string2);
        fileWriter.write("#                                  PageType   => wdPrintAllPages,                              " + string2);
        fileWriter.write("#                                  PrintToFile => 1,                                           " + string2);
        fileWriter.write("#                                  OutputFileName => $ARGV[2]                                  " + string2);
        fileWriter.write("#   });                                                                                        " + string2);
        fileWriter.write("# $Word->{ActivePrinter} = $oldActivePrinte;                                                   " + string2);
        fileWriter.write("$Book->savaAs($ARGV[2], $ARGV[1]);                                                             " + string2);
        fileWriter.write("# ActiveDocument.Close(SaveChanges:=WdSaveOptions.wdDoNotSaveChanges)" + string2);
        fileWriter.write("$Book->Close({SaveChanges => 0});                                                           " + string2);
        fileWriter.write("$Word->Quit();                                                                               " + string2);
        fileWriter.close();
        arrayList.add("perl");
        arrayList.add(string5);
        return arrayList;
    }

    ArrayList createExcelPrintHelper() throws IOException {
        String string = utils.getUsersTempDir();
        String string2 = System.getProperty("line.separator");
        String string3 = System.getProperty("file.separator");
        String string4 = "printViaExcel.pl";
        ArrayList arrayList = this.searchLocalFile(string4);
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        String string5 = string + string3 + string4;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a perl script: " + string5);
        }
        File file = new File(string5);
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                                                " + string2);
        fileWriter.write("   if 0;                                                                                                         " + string2);
        fileWriter.write("use strict;                                                                                                      " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("if ( $^O ne \"MSWin32\")                                                                                         " + string2);
        fileWriter.write("{                                                                                                                " + string2);
        fileWriter.write("   print \"Windows only.\\n\";                                                                                    " + string2);
        fileWriter.write("   print_usage();                                                                                                " + string2);
        fileWriter.write("   exit(1);                                                                                                      " + string2);
        fileWriter.write("}                                                                                                                " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("use Win32::OLE qw(in with);                                                                                      " + string2);
        fileWriter.write("use Win32::OLE::Const 'Microsoft Excel';                                                                         " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("# ------ usage ------                                                                                            " + string2);
        fileWriter.write("sub print_usage()                                                                                                " + string2);
        fileWriter.write("{                                                                                                                " + string2);
        fileWriter.write("    print STDERR \"Usage: printViaExcel.pl  <Excel file> <name of printer> <output file> .\\n                       " + string2);
        fileWriter.write("                  Please use the same string for the name of the printer as you can find \\n                      " + string2);
        fileWriter.write("                  under Start-Control Panel-Printer and Faxes  \\n                                            " + string2);
        fileWriter.write("                  The name could look like the the following line: \\n                                            " + string2);
        fileWriter.write("                  Apple LaserWriter II NT v47.0 \\n                                                               " + string2);
        fileWriter.write("                  Sample command line: \\n                                                                        " + string2);
        fileWriter.write("                  execl_print.pl  c:\\book1.xls Apple LaserWriter II NT v47.0 c:\\output\\book1.ps \\n\";     " + string2);
        fileWriter.write("}                                                                                                                " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("$Win32::OLE::Warn = 3;                                # die on errors...                                         " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("if ($#ARGV != 2)                                                                                                 " + string2);
        fileWriter.write("{                                                                                                                " + string2);
        fileWriter.write("   print STDERR \"Too less arguments.\\n\";                                                                      " + string2);
        fileWriter.write("   print STDERR \"ARGV[0] $ARGV[0]\\n\";                                                                         " + string2);
        fileWriter.write("   print STDERR \"ARGV[1] $ARGV[1]\\n\";                                                                         " + string2);
        fileWriter.write("   print STDERR \"ARGV[2] $ARGV[2]\\n\";                                                                         " + string2);
        fileWriter.write("   print_usage();                                                                                                " + string2);
        fileWriter.write("   exit(1);                                                                                                      " + string2);
        fileWriter.write("}                                                                                                                " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("my $Excel = Win32::OLE->GetActiveObject('Excel.Application')                                                     " + string2);
        fileWriter.write("    || Win32::OLE->new('Excel.Application', 'Quit');  # get already active Excel                                 " + string2);
        fileWriter.write("                                                      # application or open new                                  " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("my $Book = $Excel->Workbooks->Open( $ARGV[0] );                                                                  " + string2);
        fileWriter.write("   $Book->PrintOut({Copies => 1,                                                                                 " + string2);
        fileWriter.write("                    ActivePrinter => $ARGV[1],                                                                   " + string2);
        fileWriter.write("                    PrToFileName => $ARGV[2],                                                                    " + string2);
        fileWriter.write("                    Collate => 1                                                                                 " + string2);
        fileWriter.write("                    });                                                                                          " + string2);
        fileWriter.write("# Close worksheets without store changes" + string2);
        fileWriter.write("# $Book->Close({SaveChanges => 0});                                                           " + string2);
        fileWriter.write("my $sVersion = $Excel->Application->Version();" + string2);
        fileWriter.write("$Excel->Quit();                                                                                                     " + string2);
        fileWriter.write("local *FILE;" + string2);
        fileWriter.write("if (open(FILE, \">$ENV{HOME}/msofficeloadtimes.txt\"))" + string2);
        fileWriter.write("{" + string2);
        fileWriter.write("   print FILE \"name=$ARGV[0]\\n\";" + string2);
        fileWriter.write("   print FILE \"ExcelVersion=$sVersion\\n\";" + string2);
        fileWriter.write("   close(FILE);" + string2);
        fileWriter.write("}" + string2);
        fileWriter.close();
        arrayList.add("perl");
        arrayList.add(string5);
        return arrayList;
    }

    ArrayList createExcelStoreHelper() throws IOException {
        String string = utils.getUsersTempDir();
        String string2 = System.getProperty("line.separator");
        String string3 = System.getProperty("file.separator");
        String string4 = "saveViaExcel.pl";
        ArrayList arrayList = this.searchLocalFile(string4);
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        String string5 = string + string3 + string4;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a script: " + string5);
        }
        File file = new File(string5);
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                                                " + string2);
        fileWriter.write("   if 0;                                                                                                         " + string2);
        fileWriter.write("use strict;                                                                                                      " + string2);
        fileWriter.write("# This script is automatically created.                                                                          " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("use Win32::OLE qw(in with);                                                                                      " + string2);
        fileWriter.write("use Win32::OLE::Const 'Microsoft Excel';                                                                         " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("# ------ usage ------                                                                                            " + string2);
        fileWriter.write("sub print_usage()                                                                                                " + string2);
        fileWriter.write("{                                                                                                                " + string2);
        fileWriter.write("    print STDERR \"Usage: savaViaExcel.pl  <Excel file> <filefilter> <output file> .\\n                       " + string2);
        fileWriter.write("                  execl_print.pl  c:\\book1.xls Apple LaserWriter II NT v47.0 c:\\output\\book1.ps \\n\";     " + string2);
        fileWriter.write("}                                                                                                                " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("$Win32::OLE::Warn = 3;                                # die on errors...                                         " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("if ($#ARGV != 2)                                                                                                 " + string2);
        fileWriter.write("{                                                                                                                " + string2);
        fileWriter.write("   print \"Too less arguments.\\n\";                                                                              " + string2);
        fileWriter.write("   print_usage();                                                                                                " + string2);
        fileWriter.write("   exit(1);                                                                                                      " + string2);
        fileWriter.write("}                                                                                                                " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("my $Excel = Win32::OLE->GetActiveObject('Excel.Application')                                                     " + string2);
        fileWriter.write("    || Win32::OLE->new('Excel.Application', 'Quit');  # get already active Excel                                 " + string2);
        fileWriter.write("                                                      # application or open new                                  " + string2);
        fileWriter.write("my $sFilterParameter = $ARGV[1];                                                                                                                 " + string2);
        fileWriter.write("my $sFilterName = xlHTML;                                                                                                                 " + string2);
        fileWriter.write("if ($sFilterParameter eq 'xlXMLSpreadsheet')                                                                                                                 " + string2);
        fileWriter.write("{                                                                                                                 " + string2);
        fileWriter.write("    $sFilterName = xlXMLSpreadsheet;                                                                                                                " + string2);
        fileWriter.write("}                                                                                                                 " + string2);
        fileWriter.write("elsif ($sFilterParameter eq 'xlHTML')                                                                                                                 " + string2);
        fileWriter.write("{                                                                                                                 " + string2);
        fileWriter.write("    $sFilterName = xlHTML;                                                                                                                 " + string2);
        fileWriter.write("}                                                                                                                 " + string2);
        fileWriter.write("else                                                                                                                 " + string2);
        fileWriter.write("{                                                                                                                 " + string2);
        fileWriter.write("    my $undefined;                                                                                                " + string2);
        fileWriter.write("    $sFilterName = $undefined;                                                                                                              " + string2);
        fileWriter.write("}                                                                                                                 " + string2);
        fileWriter.write("                                                                                                                 " + string2);
        fileWriter.write("my $Book = $Excel->Workbooks->Open( $ARGV[0] );                                                                  " + string2);
        fileWriter.write("$Excel->{DisplayAlerts} = 0;                                                                                     " + string2);
        fileWriter.write("$Book->saveAs($ARGV[2],                                                                                          " + string2);
        fileWriter.write("              $sFilterName,                                                                                   " + string2);
        fileWriter.write("              '',                                                                                                " + string2);
        fileWriter.write("              '',                                                                                                " + string2);
        fileWriter.write("              0,                                                                                                 " + string2);
        fileWriter.write("              0,                                                                                                 " + string2);
        fileWriter.write("              xlNoChange,                                                                                        " + string2);
        fileWriter.write("              xlLocalSessionChanges,                                                                             " + string2);
        fileWriter.write("              1);                                                                                                " + string2);
        fileWriter.write("# Close worksheets without store changes" + string2);
        fileWriter.write("# $Book->Close({SaveChanges => 0}); " + string2);
        fileWriter.write("$Excel->Quit();                                                                                                     " + string2);
        fileWriter.close();
        arrayList.add("perl");
        arrayList.add(string5);
        return arrayList;
    }

    ArrayList createPowerPointPrintHelper() throws IOException {
        String string = utils.getUsersTempDir();
        String string2 = System.getProperty("line.separator");
        String string3 = System.getProperty("file.separator");
        String string4 = "printViaPowerPoint.pl";
        ArrayList arrayList = this.searchLocalFile(string4);
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        String string5 = string + string3 + string4;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a script: " + string5);
        }
        File file = new File(string5);
        FileWriter fileWriter = new FileWriter(file.toString());
        fileWriter.write("eval 'exec perl -wS $0 $1 $2 '                                                                                         " + string2);
        fileWriter.write("   if 0;                                                                                                               " + string2);
        fileWriter.write("use strict;                                                                                                            " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("if ( $^O ne \"MSWin32\")                                                                                                 " + string2);
        fileWriter.write("{                                                                                                                      " + string2);
        fileWriter.write("   print \"Windows only.\\n\";                                                                                            " + string2);
        fileWriter.write("   print_usage();                                                                                                      " + string2);
        fileWriter.write("   exit(1);                                                                                                            " + string2);
        fileWriter.write("}                                                                                                                      " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("use Win32::OLE qw(in with);                                                                                            " + string2);
        fileWriter.write("use Win32::OLE::Const 'Microsoft PowerPoint';                                                                          " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("# ------ usage ------                                                                                                  " + string2);
        fileWriter.write("sub print_usage()                                                                                                      " + string2);
        fileWriter.write("{                                                                                                                      " + string2);
        fileWriter.write("    print STDERR \"Usage: powerpoint_print.pl  <PowerPoint file> <name of printer> <output file> .\\n                    " + string2);
        fileWriter.write("                  Please use the same string for the name of the printer as you can find \\n                            " + string2);
        fileWriter.write("                  under Start-Control Panel-Printer and Faxes  \\n                                                  " + string2);
        fileWriter.write("                  The name could look like the the following line: \\n                                                  " + string2);
        fileWriter.write("                  Apple LaserWriter II NT v47.0 \\n                                                                     " + string2);
        fileWriter.write("                  Sample command line: \\n                                                                              " + string2);
        fileWriter.write("                  powerpoint_print.pl  c:\\book.ppt Apple LaserWriter II NT v47.0 c:\\output\\book.ps \\n\";         " + string2);
        fileWriter.write("}                                                                                                                      " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("$Win32::OLE::Warn = 3;                                # die on errors...                                               " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("if ($#ARGV < 2)                                                                                                        " + string2);
        fileWriter.write("{                                                                                                                      " + string2);
        fileWriter.write("   print \"Too less arguments.\\n\";                                                                                      " + string2);
        fileWriter.write("   print_usage();                                                                                                      " + string2);
        fileWriter.write("   exit(1);                                                                                                            " + string2);
        fileWriter.write("}                                                                                                                      " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("my $PowerPoint = Win32::OLE->GetActiveObject('PowerPoint.Application')                                                 " + string2);
        fileWriter.write("    || Win32::OLE->new('PowerPoint.Application', 'Quit');  # get already active Excel                                  " + string2);
        fileWriter.write("                                                      # application or open new                                        " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("   $PowerPoint->{'Visible'} = 1;                                                                                       " + string2);
        fileWriter.write("   my $Presentation = $PowerPoint->Presentations->Add;                                                                 " + string2);
        fileWriter.write("   my $Presentation = $PowerPoint->Presentations->Open( $ARGV[0] );                                                    " + string2);
        fileWriter.write("# we can't change active printer in powerpoint                                                            " + string2);
        fileWriter.write("#   $Presentation->PrintOptions->{ActivePrinter} = $ARGV[1]; " + string2);
        fileWriter.write("   print \"Active printer is: \" . $Presentation->PrintOptions->{ActivePrinter} . \"\\n\"; " + string2);
        fileWriter.write("   $Presentation->PrintOptions->{PrintInBackground} = 0;                                                               " + string2);
        fileWriter.write("   # PrintColorType = 1 means print in color and PrintColorType = 2 means print in gray                                " + string2);
        fileWriter.write("   $Presentation->PrintOptions->{PrintColorType} = 1;                                                                  " + string2);
        fileWriter.write("                                                                                                                       " + string2);
        fileWriter.write("   $Presentation->PrintOut({PrintToFile => $ARGV[2]});                                                                 " + string2);
        fileWriter.write("   sleep 5;                                                                                                            " + string2);
        fileWriter.write("   print \"Presentation has been printed\\n\";                                                                            " + string2);
        fileWriter.write("my $sVersion = $Presentation->Application->Version();" + string2);
        fileWriter.write("   $PowerPoint->Quit(); " + string2);
        fileWriter.write("local *FILE;" + string2);
        fileWriter.write("if (open(FILE, \">$ENV{HOME}/msofficeloadtimes.txt\"))" + string2);
        fileWriter.write("{" + string2);
        fileWriter.write("   print FILE \"name=$ARGV[0]\\n\";" + string2);
        fileWriter.write("   print FILE \"PowerPointVersion=$sVersion\\n\";" + string2);
        fileWriter.write("   close(FILE);" + string2);
        fileWriter.write("}" + string2);
        fileWriter.close();
        arrayList.add("perl");
        arrayList.add(string5);
        return arrayList;
    }

    public String getOfficeType(String string) {
        File file = new File(string);
        if (!file.exists()) {
            GlobalLogWriter.get().println("couldn't find file " + string);
            return "";
        }
        RandomAccessFile randomAccessFile = null;
        String string2 = "";
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            String string3 = "";
            while (string3 != null) {
                int n;
                string3 = randomAccessFile.readLine();
                if (string3 == null || (string3 = string3.trim()).length() < 2 || string3.startsWith("#") || string3.startsWith(";") || (n = string3.indexOf("mso-application")) <= 0) continue;
                if (string3.indexOf("Word.Document") > 0) {
                    string2 = "word";
                    continue;
                }
                if (string3.indexOf("Excel") > 0) {
                    string2 = "excel";
                    continue;
                }
                GlobalLogWriter.get().println("Unknown/unsupported data file: " + string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("couldn't open file " + string);
            System.out.println("Message: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Exception while reading file " + string);
            System.out.println("Message: " + iOException.getMessage());
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't close file " + string);
            System.out.println("Message: " + iOException.getMessage());
        }
        return string2;
    }
}

