/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XAccessibleSelection
extends MultiMethodTest {
    private static final String className = "com.sun.star.accessibility.XAccessibleSelection";
    public XAccessibleSelection oObj = null;
    XAccessibleContext xAC = null;
    int childCount;
    protected boolean multiSelection = true;
    protected boolean OneAlwaysSelected = false;

    protected String getTestedClassName() {
        return className;
    }

    protected void before() {
        Boolean bl;
        this.xAC = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, (Object)this.oObj);
        if (this.xAC == null) {
            throw new StatusException(Status.failed("Couldn't query XAccessibleContext. Test must be modified"));
        }
        Boolean bl2 = (Boolean)this.tEnv.getObjRelation("XAccessibleSelection.multiSelection");
        if (bl2 != null) {
            this.multiSelection = bl2;
        }
        if ((bl = (Boolean)this.tEnv.getObjRelation("XAccessibleSelection.OneAlwaysSelected")) != null) {
            this.OneAlwaysSelected = bl;
        }
        this.childCount = this.xAC.getAccessibleChildCount();
        this.log.println("Child count: " + this.childCount);
    }

    public void _selectAccessibleChild() {
        boolean bl = true;
        try {
            this.log.println("Try to select child with index " + this.childCount);
            this.oObj.selectAccessibleChild(this.childCount);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl = true;
        }
        try {
            this.log.println("Try to select child with index -1");
            this.oObj.selectAccessibleChild(-1);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        this.log.println("ChildCount: " + this.childCount);
        int n = this.childCount;
        if (this.childCount > 500) {
            this.log.println("Restricting to 500");
            n = 500;
        }
        if (n > 0) {
            try {
                for (int i = 0; i < n; ++i) {
                    this.log.print("Trying to select child with index " + i + ": ");
                    if (_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), i)) {
                        this.oObj.selectAccessibleChild(i);
                        this.log.println("OK");
                        continue;
                    }
                    this.log.println("Child isn't selectable");
                }
                bl &= true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl = false;
            }
        }
        this.tRes.tested("selectAccessibleChild()", bl);
    }

    public void _isAccessibleChildSelected() {
        this.executeMethod("selectAccessibleChild()");
        boolean bl = true;
        boolean bl2 = false;
        try {
            this.log.print("isAccessibleChildSelected(-1)? ");
            bl2 = this.oObj.isAccessibleChildSelected(-1);
            this.log.println(bl);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl = true;
        }
        try {
            this.log.print("isAccessibleChildSelected(" + this.childCount + ")? ");
            bl2 = this.oObj.isAccessibleChildSelected(this.childCount);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        int n = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        if (n > 500) {
            n = 500;
        }
        this.log.println("SelectableChildCount: " + n);
        if (n > 0) {
            try {
                this.oObj.selectAllAccessibleChildren();
                for (int i = 0; i < n; ++i) {
                    this.log.println("Trying to select child with index " + i);
                    if (_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), i)) {
                        this.oObj.selectAccessibleChild(i);
                        this.shortWait();
                        bl2 = this.oObj.isAccessibleChildSelected(i);
                        this.log.println("isAccessibleChildSelected - " + bl2);
                        bl &= bl2;
                        continue;
                    }
                    this.log.println("Child isn't selectable");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl = false;
            }
        }
        this.tRes.tested("isAccessibleChildSelected()", bl);
    }

    public void _clearAccessibleSelection() {
        this.executeMethod("isAccessibleChildSelected()");
        boolean bl = true;
        this.log.println("clearAccessibleSelection");
        this.oObj.clearAccessibleSelection();
        this.shortWait();
        if (this.childCount > 0 && !this.OneAlwaysSelected) {
            try {
                this.log.print("isAccessibleChildSelected(" + (this.childCount - 1) + ")? ");
                boolean bl2 = this.oObj.isAccessibleChildSelected(this.childCount - 1);
                this.log.println(bl2);
                bl = !bl2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl = false;
            }
        } else if (this.OneAlwaysSelected) {
            this.log.println("Can't clear selection, one child is always selected");
        }
        this.tRes.tested("clearAccessibleSelection()", bl);
    }

    public void _selectAllAccessibleChildren() {
        this.executeMethod("clearAccessibleSelection()");
        this.log.println("selectAllAccessibleChildren...");
        this.oObj.selectAllAccessibleChildren();
        this.shortWait();
        boolean bl = true;
        boolean bl2 = true;
        int n = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        if (n > 0 && this.multiSelection) {
            try {
                this.log.print("isAccessibleChildSelected(1)? ");
                bl2 = this.oObj.isAccessibleChildSelected(1);
                this.log.println(bl2);
                bl = bl2;
                this.log.print("isAccessibleChildSelected(" + (this.childCount - 1) + ")? ");
                bl2 = this.oObj.isAccessibleChildSelected(this.childCount - 1);
                this.log.println(bl2);
                bl &= bl2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl = false;
            }
        }
        this.tRes.tested("selectAllAccessibleChildren()", bl);
    }

    public void _getSelectedAccessibleChildCount() {
        int n;
        int n2;
        this.log.println("getSelectedAccessibleChildCount():");
        if (this.multiSelection) {
            this.oObj.selectAllAccessibleChildren();
        } else {
            n2 = this.childCount;
            if (this.childCount > 500) {
                this.log.println("Restricting to 500");
                n2 = 500;
            }
            if (n2 > 0) {
                try {
                    for (n = 0; n < n2; ++n) {
                        if (!_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), n)) continue;
                        this.log.print("Trying to select child with index " + n + ": ");
                        this.oObj.selectAccessibleChild(n);
                        long l = System.currentTimeMillis();
                        long l2 = System.currentTimeMillis();
                        while (!this.oObj.isAccessibleChildSelected(n) && l2 - l < 5000L) {
                            l2 = System.currentTimeMillis();
                        }
                        this.log.println("OK");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.log.println("Unexpected exception");
                    indexOutOfBoundsException.printStackTrace(this.log);
                }
            }
        }
        n2 = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        this.log.println("Found " + n2 + " selectable Childs");
        n = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("After selecting all accessible " + n + " are selected");
        boolean bl = true;
        bl = this.multiSelection ? (bl &= n == n2) : (bl &= n == 1);
        this.log.println("clearAccessibleSelection...");
        this.oObj.clearAccessibleSelection();
        this.log.print("getSelectedAccessibleChildCount: ");
        n = this.oObj.getSelectedAccessibleChildCount();
        this.log.println(n);
        bl = this.OneAlwaysSelected ? (bl &= n == 1) : (bl &= n == 0);
        this.tRes.tested("getSelectedAccessibleChildCount()", bl);
    }

    public void _getSelectedAccessibleChild() {
        this.executeMethod("getSelectedAccessibleChildCount()");
        boolean bl = true;
        int n = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("getSelectedAccessibleChildCount: " + n);
        try {
            this.log.println("getSelectedAccessibleChild(-1)");
            this.oObj.getSelectedAccessibleChild(-1);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl = true;
        }
        try {
            this.log.println("getSelectedAccessibleChild(" + n + ")");
            this.oObj.getSelectedAccessibleChild(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        int n2 = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        if (n2 > 500) {
            n2 = 500;
        }
        if (n2 > 0) {
            int n3 = 0;
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    this.log.println("Trying to select child with index " + n3);
                    if (_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), n3)) {
                        this.oObj.selectAccessibleChild(n3);
                        this.shortWait();
                        this.log.println("selected child count: " + this.oObj.getSelectedAccessibleChildCount());
                        XAccessible xAccessible = this.oObj.getSelectedAccessibleChild(0);
                        bl &= xAccessible != null;
                        this.log.println("valid child - " + (xAccessible != null));
                        continue;
                    }
                    this.log.println("Child isn't selectable");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception: Last relevant calls:\n \toObj.selectAccessibleChild(" + n3 + ")\n" + "\toObj.getSelectedAccessibleChild(0)");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl = false;
            }
        }
        this.tRes.tested("getSelectedAccessibleChild()", bl);
    }

    public void _deselectAccessibleChild() {
        this.executeMethod("getSelectedAccessibleChild()");
        boolean bl = true;
        int n = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("getSelectedAccessibleChildCount():" + n);
        try {
            this.log.println("deselectAccessibleChild(-1)");
            this.oObj.deselectAccessibleChild(-1);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.println("deselectAccessibleChild(" + (this.childCount + 1) + ")");
            this.oObj.deselectAccessibleChild(this.childCount + 1);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        this.log.println("#################");
        this.log.println("Selecting all accessible");
        this.oObj.selectAllAccessibleChildren();
        n = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("getSelectedAccessibleChildCount():" + n);
        if (this.childCount > 0 && n > 0) {
            try {
                int n2;
                int n3 = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
                if (this.childCount > 100) {
                    n3 = 100;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    this.log.println("deselectAccessibleChild(" + n2 + ")");
                    if (!this.oObj.isAccessibleChildSelected(n2)) continue;
                    this.oObj.deselectAccessibleChild(n2);
                }
                n2 = this.oObj.getSelectedAccessibleChildCount();
                this.log.println("getSelectedAccessibleChildCount():" + n2);
                if (this.OneAlwaysSelected && n == 1) {
                    this.log.println("One Child is always selected");
                    bl &= true;
                } else {
                    bl &= n > n2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl = false;
            }
        }
        this.tRes.tested("deselectAccessibleChild()", bl);
    }

    protected static int chkSelectable(Object object) {
        int n = 0;
        XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, object);
        int n2 = xAccessibleContext.getAccessibleChildCount();
        if (n2 > 500) {
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            try {
                if (!xAccessibleContext.getAccessibleChild(i).getAccessibleContext().getAccessibleStateSet().contains((short)22)) continue;
                ++n;
                System.out.println("Child " + i + " is selectable");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return n;
    }

    protected static boolean isSelectable(Object object, int n) {
        XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, object);
        boolean bl = false;
        try {
            if (xAccessibleContext.getAccessibleChild(n).getAccessibleContext().getAccessibleStateSet().contains((short)22)) {
                bl = true;
            }
            if (xAccessibleContext.getAccessibleChild(n).getAccessibleContext().getAccessibleRole() == 36 || xAccessibleContext.getAccessibleChild(n).getAccessibleContext().getAccessibleRole() == 53) {
                bl = false;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Exception while checking for selectability");
        }
        return bl;
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

