/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchResultEvent;
import com.sun.star.frame.FeatureStateEvent;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchResultListener;
import com.sun.star.frame.XNotifyingDispatch;
import com.sun.star.frame.XStatusListener;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDispatch
extends MultiMethodTest {
    public XDispatch oObj = null;
    TestStatusListener listener = null;
    TestNotificationListener notificationListener = null;
    URL url = null;

    private boolean checkXDispatchWithNotification() {
        XNotifyingDispatch xNotifyingDispatch = (XNotifyingDispatch)UnoRuntime.queryInterface(XNotifyingDispatch.class, (Object)this.oObj);
        if (xNotifyingDispatch != null) {
            this.log.println("   XNotifyingDispatch found:");
            PropertyValue[] propertyValueArray = (PropertyValue[])this.tEnv.getObjRelation("XNotifyingDispatchArgument");
            this.notificationListener = new TestNotificationListener(this.log);
            xNotifyingDispatch.dispatchWithNotification(this.url, propertyValueArray, this.notificationListener);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log.println("   Listener called: " + this.notificationListener.finishedDispatch);
            return this.notificationListener.finishedDispatch;
        }
        return false;
    }

    public void before() {
        this.listener = new TestStatusListener(this.log);
        this.url = (URL)this.tEnv.getObjRelation("XDispatch.URL");
        if (this.url == null) {
            throw new StatusException(Status.failed("Relation not found."));
        }
    }

    public void _dispatch() {
        this.requiredMethod("addStatusListener()");
        boolean bl = true;
        this.oObj.dispatch(this.url, new PropertyValue[0]);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.println("Listener called: " + this.listener.statusChangedCalled);
        bl = this.listener.statusChangedCalled;
        if (!bl) {
            bl = this.checkXDispatchWithNotification();
        }
        this.tRes.tested("dispatch()", bl);
    }

    public void _addStatusListener() {
        boolean bl = true;
        this.oObj.addStatusListener(this.listener, this.url);
        this.tRes.tested("addStatusListener()", bl);
    }

    public void _removeStatusListener() {
        this.requiredMethod("dispatch()");
        this.listener.statusChangedCalled = false;
        boolean bl = true;
        this.oObj.removeStatusListener(this.listener, this.url);
        this.oObj.dispatch(this.url, new PropertyValue[0]);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Listener called: " + this.listener.statusChangedCalled);
        bl = !this.listener.statusChangedCalled;
        this.tRes.tested("removeStatusListener()", bl);
    }

    protected class TestNotificationListener
    implements XDispatchResultListener {
        public boolean disposingCalled = false;
        public boolean finishedDispatch = false;
        private PrintWriter log = null;

        public TestNotificationListener(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public void disposing(EventObject eventObject) {
            this.disposingCalled = true;
            this.log.println("   disposing was called.");
        }

        public void dispatchFinished(DispatchResultEvent dispatchResultEvent) {
            this.finishedDispatch = true;
            this.log.println("   dispatchFinished was called.");
        }
    }

    protected class TestStatusListener
    implements XStatusListener {
        public boolean disposingCalled = false;
        public boolean statusChangedCalled = false;
        private PrintWriter log = null;

        public TestStatusListener(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public void disposing(EventObject eventObject) {
            this.disposingCalled = true;
            this.log.println(" disposing was called.");
        }

        public void statusChanged(FeatureStateEvent featureStateEvent) {
            this.statusChangedCalled = true;
            this.log.println(" statusChanged was called.");
            this.log.println("  FeatureURL = '" + featureStateEvent.FeatureURL + "'");
            this.log.println("  FeatureDescriptor = '" + featureStateEvent.FeatureDescriptor + "'");
            this.log.println("  IsEnabled = " + featureStateEvent.IsEnabled);
            this.log.println("  Requery = " + featureStateEvent.Requery);
            this.log.println("  State = '" + featureStateEvent.State.toString() + "'");
        }
    }
}

