/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XDispatchRecorder;
import com.sun.star.frame.XDispatchRecorderSupplier;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import lib.MultiMethodTest;
import lib.StatusException;
import util.SOfficeFactory;
import util.utils;

public class _XDispatchRecorderSupplier
extends MultiMethodTest {
    public static XDispatchRecorderSupplier oObj = null;
    XComponent xTextDoc = null;
    XDispatchRecorder recorder = null;
    XDesktop desktop = null;

    protected void before() {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)this.tParam.getMSF());
        try {
            this.log.println("creating a text document");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
            XInterface xInterface = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.frame.Desktop");
            this.desktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xInterface);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(this.log);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    public void _setDispatchRecorder() {
        this.requiredMethod("getDispatchRecorder()");
        boolean bl = true;
        boolean bl2 = true;
        this.log.print("Setting custom macro recorder ...");
        oObj.setDispatchRecorder(new MyRecorder());
        XDispatchRecorder xDispatchRecorder = oObj.getDispatchRecorder();
        boolean bl3 = bl2 = xDispatchRecorder != null && "MyRecorder implementation".equals(xDispatchRecorder.getRecordedMacro());
        if (bl2) {
            this.log.println("OK");
        } else {
            this.log.println("FAILED");
        }
        bl &= bl2;
        this.log.print("Setting null dispatch recorder ...");
        oObj.setDispatchRecorder(null);
        boolean bl4 = bl2 = oObj.getDispatchRecorder() == null;
        if (bl2) {
            this.log.println("OK");
        } else {
            this.log.println("FAILED");
        }
        this.log.println("Setting old macro recorder ...");
        oObj.setDispatchRecorder(this.recorder);
        this.tRes.tested("setDispatchRecorder()", bl &= bl2);
    }

    public void _getDispatchRecorder() {
        this.recorder = oObj.getDispatchRecorder();
        this.tRes.tested("getDispatchRecorder()", true);
    }

    public void _dispatchAndRecord() {
        boolean bl;
        Object object;
        this.requiredMethod("getDispatchRecorder()");
        boolean bl2 = true;
        if (this.recorder == null) {
            try {
                object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.comp.framework.DispatchRecorder");
                this.recorder = (XDispatchRecorder)UnoRuntime.queryInterface(XDispatchRecorder.class, object);
                oObj.setDispatchRecorder(this.recorder);
            }
            catch (com.sun.star.uno.Exception exception) {
                throw new StatusException("Couldn't create recorder", exception);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        object = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XFrame xFrame = object.getCurrentController().getFrame();
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
        URL uRL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        XDispatch xDispatch = xDispatchProvider.queryDispatch(uRL, "", 0);
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Text";
        propertyValueArray[0].Value = "XDispatchRecorderSupplier";
        this.log.print("Dispatching and recording ...");
        oObj.dispatchAndRecord(uRL, propertyValueArray, xDispatch);
        String string = this.recorder.getRecordedMacro();
        boolean bl3 = bl = string != null && string.indexOf("XDispatchRecorderSupplier") > -1 && string.indexOf(".uno:InsertText") > -1;
        if (bl) {
            this.log.println("OK");
        } else {
            this.log.println("FAILED");
        }
        bl2 &= bl;
        this.log.println("Recorder macro :\n" + string);
        this.log.print("Trying to set dispatch with null Dispatcher ...");
        try {
            oObj.dispatchAndRecord(uRL, propertyValueArray, null);
            this.log.println("OK");
        }
        catch (Exception exception) {
            this.log.println("Exception is OK: " + exception);
        }
        this.log.print("Trying to set dispatch recorder to null and record ...");
        oObj.setDispatchRecorder(null);
        try {
            oObj.dispatchAndRecord(uRL, propertyValueArray, xDispatch);
            this.log.println("OK");
        }
        catch (Exception exception) {
            this.log.println("Exception is OK: " + exception);
        }
        oObj.setDispatchRecorder(this.recorder);
        this.tRes.tested("dispatchAndRecord()", bl2);
    }

    protected void after() {
        this.xTextDoc.dispose();
    }

    private static class MyRecorder
    implements XDispatchRecorder {
        private MyRecorder() {
        }

        public void startRecording(XFrame xFrame) {
        }

        public void recordDispatch(URL uRL, PropertyValue[] propertyValueArray) {
        }

        public void recordDispatchAsComment(URL uRL, PropertyValue[] propertyValueArray) {
        }

        public void endRecording() {
        }

        public String getRecordedMacro() {
            return "MyRecorder implementation";
        }
    }
}

