/*
 * Decompiled with CFR 0.152.
 */
package ifc.registry;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.CannotRegisterImplementationException;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XImplementationRegistration;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import lib.MultiMethodTest;
import util.RegistryTools;
import util.utils;

public class _XImplementationRegistration
extends MultiMethodTest {
    public XImplementationRegistration oObj = null;
    private String url = null;
    private String loader = null;
    private XSimpleRegistry reg = null;

    public void _registerImplementation() throws CannotRegisterImplementationException, RuntimeException {
        this.url = utils.getFullTestURL("qadevlibs/MyPersistObjectImpl.jar");
        this.loader = "com.sun.star.loader.Java2";
        boolean bl = false;
        String string = null;
        try {
            string = utils.getOfficeTempDir((XMultiServiceFactory)this.tParam.getMSF()) + "XImplementationRegistration_tmp.rdb";
            this.reg = RegistryTools.openRegistry(string, (XMultiServiceFactory)this.tParam.getMSF());
            this.oObj.registerImplementation(this.loader, this.url, this.reg);
            RegistryTools.printRegistryInfo(this.reg.getRootKey(), this.log);
            String[] stringArray = this.reg.getRootKey().getKeyNames();
            bl = stringArray != null && stringArray.length > 0;
        }
        catch (Exception exception) {
            this.log.println("Can't open registry file: " + string);
            exception.printStackTrace(this.log);
        }
        this.tRes.tested("registerImplementation()", bl);
    }

    public void _getImplementations() throws RuntimeException {
        this.requiredMethod("registerImplementation()");
        String[] stringArray = this.oObj.getImplementations(this.loader, this.url);
        if (stringArray.length == 0) {
            this.log.println("getImplementations() returns an empty array");
        }
        boolean bl = false;
        this.log.println("Implementations found :");
        for (int i = 0; i < stringArray.length; ++i) {
            this.log.println(" '" + stringArray[i] + "'");
            if (!"com.sun.star.cmp.MyPersistObject".equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        this.tRes.tested("getImplementations()", bl);
    }

    public void _checkInstantiation() throws RuntimeException {
        this.requiredMethod("registerImplementation()");
        String[] stringArray = this.oObj.checkInstantiation("com.sun.star.comp.stoc.JavaComponentLoader");
        this.tRes.tested("checkInstantiation()", stringArray != null);
    }

    public void _revokeImplementation() throws RuntimeException {
        boolean bl = false;
        this.requiredMethod("registerImplementation()");
        this.executeMethod("getImplementations()");
        this.executeMethod("checkInstantiation()");
        this.oObj.revokeImplementation(this.url, this.reg);
        RegistryTools.printRegistryInfo(this.reg, this.log);
        try {
            String[] stringArray = this.reg.getRootKey().getKeyNames();
            bl = stringArray == null || stringArray.length == 0;
        }
        catch (InvalidRegistryException invalidRegistryException) {
            this.log.println("!!! Exception retrieving keys from registry :");
            invalidRegistryException.printStackTrace(this.log);
        }
        this.tRes.tested("revokeImplementation()", true);
    }

    public void after() {
        this.disposeEnvironment();
    }
}

