/*
 * Decompiled with CFR 0.152.
 */
package ifc.script;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.ServiceNotRegisteredException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.ScriptEvent;
import com.sun.star.script.ScriptEventDescriptor;
import com.sun.star.script.XEventAttacherManager;
import com.sun.star.script.XScriptListener;
import com.sun.star.uno.Exception;
import lib.MultiMethodTest;

public class _XEventAttacherManager
extends MultiMethodTest {
    public XEventAttacherManager oObj = null;
    int index;
    ScriptEventDescriptor desc;
    ScriptEventDescriptor[] descs;
    Object attachedObject;
    XScriptListener listener;

    public void _insertEntry() {
        this.index = 0;
        try {
            this.oObj.insertEntry(this.index);
            this.tRes.tested("insertEntry()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("insertEntry(" + this.index + ") throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("insertEntry()", false);
        }
    }

    public void _registerScriptEvent() {
        this.requiredMethod("insertEntry()");
        this.desc = new ScriptEventDescriptor("XEventListener1", "disposing", "", "Basic", "");
        try {
            this.oObj.registerScriptEvent(this.index, this.desc);
            this.tRes.tested("registerScriptEvent()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("registerScriptEvent() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("registerScriptEvent()", false);
        }
    }

    public void _registerScriptEvents() {
        this.requiredMethod("insertEntry()");
        this.descs = new ScriptEventDescriptor[]{new ScriptEventDescriptor("XEventListener2", "disposing", "", "Basic", ""), new ScriptEventDescriptor("XEventListener3", "disposing", "", "Basic", "")};
        try {
            this.oObj.registerScriptEvents(this.index, this.descs);
            this.tRes.tested("registerScriptEvents()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("registerScriptEvents() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("registerScriptEvents()", false);
        }
    }

    public void _getScriptEvents() {
        ScriptEventDescriptor[] scriptEventDescriptorArray;
        this.requiredMethod("registerScriptEvent()");
        this.requiredMethod("registerScriptEvents()");
        try {
            scriptEventDescriptorArray = this.oObj.getScriptEvents(this.index);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("registerScriptEvents() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("registerScriptEvents()", false);
            return;
        }
        this.tRes.tested("getScriptEvents()", this.contains(scriptEventDescriptorArray, this.desc) && this.containsArray(scriptEventDescriptorArray, this.descs));
        this.log.println("Script events :");
        this.printEvents(scriptEventDescriptorArray);
    }

    boolean contains(ScriptEventDescriptor[] scriptEventDescriptorArray, ScriptEventDescriptor scriptEventDescriptor) {
        for (int i = 0; i < scriptEventDescriptorArray.length; ++i) {
            if (!this.equal(scriptEventDescriptorArray[i], scriptEventDescriptor)) continue;
            return true;
        }
        return false;
    }

    boolean containsArray(ScriptEventDescriptor[] scriptEventDescriptorArray, ScriptEventDescriptor[] scriptEventDescriptorArray2) {
        for (int i = 0; i < scriptEventDescriptorArray2.length; ++i) {
            if (this.contains(scriptEventDescriptorArray, scriptEventDescriptorArray2[i])) continue;
            return false;
        }
        return true;
    }

    boolean equal(ScriptEventDescriptor scriptEventDescriptor, ScriptEventDescriptor scriptEventDescriptor2) {
        return scriptEventDescriptor.ListenerType.equals(scriptEventDescriptor2.ListenerType) && scriptEventDescriptor.EventMethod.equals(scriptEventDescriptor2.EventMethod) && scriptEventDescriptor.ScriptType.equals(scriptEventDescriptor2.ScriptType) && scriptEventDescriptor.ScriptCode.equals(scriptEventDescriptor2.ScriptCode) && scriptEventDescriptor.AddListenerParam.equals(scriptEventDescriptor2.AddListenerParam);
    }

    void printEvent(ScriptEventDescriptor scriptEventDescriptor) {
        if (scriptEventDescriptor == null) {
            this.log.println("null");
        } else {
            this.log.println("\"" + scriptEventDescriptor.ListenerType + "\",\"" + scriptEventDescriptor.EventMethod + "\",\"" + scriptEventDescriptor.ScriptType + "\",\"" + scriptEventDescriptor.ScriptCode + "\",\"" + scriptEventDescriptor.AddListenerParam + "\"");
        }
    }

    void printEvents(ScriptEventDescriptor[] scriptEventDescriptorArray) {
        if (scriptEventDescriptorArray == null) {
            this.log.println("null");
        } else {
            for (int i = 0; i < scriptEventDescriptorArray.length; ++i) {
                this.printEvent(scriptEventDescriptorArray[i]);
            }
        }
    }

    public void _attach() {
        this.requiredMethod("insertEntry()");
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)this.tParam.getMSF();
            this.attachedObject = xMultiServiceFactory.createInstance("com.sun.star.reflection.TypeDescriptionProvider");
        }
        catch (Exception exception) {
            this.log.println("Service not available");
            exception.printStackTrace(this.log);
            this.tRes.tested("attach()", false);
            return;
        }
        try {
            this.oObj.attach(this.index, this.attachedObject, "param");
            this.tRes.tested("attach()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("attach() throws exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("attach()", false);
        }
        catch (ServiceNotRegisteredException serviceNotRegisteredException) {
            this.log.println("attach() throws exception " + serviceNotRegisteredException.getMessage());
            serviceNotRegisteredException.printStackTrace(this.log);
            this.tRes.tested("attach()", false);
        }
    }

    public void _detach() {
        this.requiredMethod("attach()");
        try {
            this.oObj.detach(this.index, this.attachedObject);
            this.tRes.tested("detach()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("detach() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("detach()", false);
        }
    }

    public void _revokeScriptEvent() {
        this.requiredMethod("registerScriptEvent()");
        this.executeMethod("getScriptEvents()");
        try {
            this.oObj.revokeScriptEvent(this.index, this.desc.ListenerType, this.desc.EventMethod, "");
            ScriptEventDescriptor[] scriptEventDescriptorArray = this.oObj.getScriptEvents(this.index);
            this.tRes.tested("revokeScriptEvent()", !this.contains(scriptEventDescriptorArray, this.desc));
            this.printEvents(scriptEventDescriptorArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("revokeScriptEvent() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("revokeScriptEvent()", false);
        }
    }

    public void _revokeScriptEvents() {
        this.requiredMethod("revokeScriptEvent()");
        this.executeMethod("getScriptEvents()");
        try {
            this.oObj.revokeScriptEvents(this.index);
            ScriptEventDescriptor[] scriptEventDescriptorArray = this.oObj.getScriptEvents(this.index);
            this.tRes.tested("revokeScriptEvents()", scriptEventDescriptorArray == null || scriptEventDescriptorArray.length == 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("revokeScriptEvents() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("revokeScriptEvents()", false);
        }
    }

    public void _removeEntry() {
        this.requiredMethod("insertEntry()");
        try {
            this.oObj.removeEntry(this.index);
            this.tRes.tested("removeEntry()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("removeEntry(" + this.index + ") throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("removeEntry()", false);
        }
    }

    public void _addScriptListener() {
        this.listener = new MyScriptListener();
        try {
            this.oObj.addScriptListener(this.listener);
            this.tRes.tested("addScriptListener()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("addScriptListener() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("addScriptListener()", false);
        }
    }

    public void _removeScriptListener() {
        this.requiredMethod("addScriptListener()");
        try {
            this.oObj.removeScriptListener(this.listener);
            this.tRes.tested("removeScriptListener()", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("removeScriptListener() throws unexpected exception " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            this.tRes.tested("removeScriptListener()", false);
        }
    }

    class MyScriptListener
    implements XScriptListener {
        MyScriptListener() {
        }

        public void firing(ScriptEvent scriptEvent) {
        }

        public Object approveFiring(ScriptEvent scriptEvent) {
            return scriptEvent.Helper;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

