/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexContainer;
import com.sun.star.lang.IllegalAccessException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.ui.XImageManager;
import com.sun.star.ui.XUIConfigurationManager;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import util.dbg;

public class _XUIConfigurationManager
extends MultiMethodTest {
    public XUIConfigurationManager oObj;
    private String msResourceUrl = "private:resource/menubar/menubar";
    private String msMyResourceUrl = "private:resource/menubar/mymenubar";
    private XIndexContainer mxSettings = null;
    private XIndexAccess mxMenuBarSettings = null;
    private XMultiServiceFactory mxMSF = null;
    private String sShortCutManagerServiceName = null;

    protected void before() {
        this.mxMSF = (XMultiServiceFactory)this.tParam.getMSF();
        this.sShortCutManagerServiceName = (String)this.tEnv.getObjRelation("XConfigurationManager.ShortCutManager");
    }

    public void _reset() {
        this.requiredMethod("removeSettings()");
        this.oObj.reset();
        this.tRes.tested("reset()", true);
    }

    public void _getUIElementsInfo() {
        boolean bl = true;
        try {
            PropertyValue[][] propertyValueArray = this.oObj.getUIElementsInfo((short)0);
            for (int i = 0; i < propertyValueArray.length; ++i) {
                for (int j = 0; j < propertyValueArray[i].length; ++j) {
                    this.log.println("Prop[" + i + "][" + j + "]: " + propertyValueArray[i][j].Name + "   " + propertyValueArray[i][j].Value.toString());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            illegalArgumentException.printStackTrace(this.log);
        }
        this.tRes.tested("getUIElementsInfo()", bl);
    }

    public void _createSettings() {
        this.mxSettings = this.oObj.createSettings();
        dbg.printInterfaces(this.mxSettings);
        this.tRes.tested("createSettings()", this.mxSettings != null);
    }

    public void _hasSettings() {
        boolean bl = false;
        try {
            bl = this.oObj.hasSettings(this.msResourceUrl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println(illegalArgumentException);
            bl = false;
        }
        this.tRes.tested("hasSettings()", bl);
    }

    public void _getSettings() {
        this.requiredMethod("hasSettings()");
        boolean bl = true;
        try {
            this.mxMenuBarSettings = this.oObj.getSettings(this.msResourceUrl, true);
            bl = this.mxMenuBarSettings != null;
            for (int i = 0; i < this.mxMenuBarSettings.getCount(); ++i) {
                Object[] objectArray = (Object[])this.mxMenuBarSettings.getByIndex(i);
                this.log.println("+++++++++ i = " + i);
                for (int j = 0; j < objectArray.length; ++j) {
                    PropertyValue propertyValue = (PropertyValue)objectArray[j];
                    this.log.println("Property" + j + ": " + propertyValue.Name + "   " + propertyValue.Value.toString());
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = false;
            noSuchElementException.printStackTrace(this.log);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            illegalArgumentException.printStackTrace(this.log);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = false;
            indexOutOfBoundsException.printStackTrace(this.log);
        }
        catch (WrappedTargetException wrappedTargetException) {
            bl = false;
            wrappedTargetException.printStackTrace(this.log);
        }
        this.tRes.tested("getSettings()", bl);
    }

    public void _replaceSettings() {
        this.requiredMethod("getSettings()");
        boolean bl = true;
        PropertyValue[] propertyValueArray = _XUIConfigurationManager.createMenuBarEntry("My Entry", this.mxMenuBarSettings, this.mxMSF, this.log);
        if (propertyValueArray == null) {
            this.tRes.tested("replaceSettings()", false);
            return;
        }
        _XUIConfigurationManager.createMenuBarItem("Click for Macro", (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, propertyValueArray[3].Value), this.log);
        XIndexContainer xIndexContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.mxMenuBarSettings);
        try {
            xIndexContainer.insertByIndex(xIndexContainer.getCount(), propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            illegalArgumentException.printStackTrace(this.log);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = false;
            indexOutOfBoundsException.printStackTrace(this.log);
        }
        catch (WrappedTargetException wrappedTargetException) {
            bl = false;
            wrappedTargetException.printStackTrace(this.log);
        }
        try {
            this.oObj.replaceSettings(this.msResourceUrl, this.mxMenuBarSettings);
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = false;
            noSuchElementException.printStackTrace(this.log);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            illegalArgumentException.printStackTrace(this.log);
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = false;
            illegalAccessException.printStackTrace(this.log);
        }
        this._getSettings();
        this.tRes.tested("replaceSettings()", bl);
    }

    public void _removeSettings() {
        this.requiredMethod("insertSettings()");
        boolean bl = true;
        try {
            this.oObj.removeSettings(this.msMyResourceUrl);
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = false;
            noSuchElementException.printStackTrace(this.log);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            illegalArgumentException.printStackTrace(this.log);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("removeSettings()", bl);
    }

    public void _insertSettings() {
        this.requiredMethod("createSettings()");
        this.requiredMethod("replaceSettings()");
        boolean bl = true;
        dbg.printInterfaces(this.mxSettings);
        PropertyValue[] propertyValueArray = _XUIConfigurationManager.createMenuBarEntry("A new entry", this.mxSettings, this.mxMSF, this.log);
        if (propertyValueArray == null) {
            this.tRes.tested("replaceSettings()", false);
            return;
        }
        _XUIConfigurationManager.createMenuBarItem("A new sub entry", (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, propertyValueArray[3].Value), this.log);
        XIndexContainer xIndexContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.mxSettings);
        try {
            int n = xIndexContainer.getCount();
            xIndexContainer.insertByIndex(n, propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            illegalArgumentException.printStackTrace(this.log);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = false;
            indexOutOfBoundsException.printStackTrace(this.log);
        }
        catch (WrappedTargetException wrappedTargetException) {
            bl = false;
            wrappedTargetException.printStackTrace(this.log);
        }
        try {
            this.oObj.insertSettings(this.msMyResourceUrl, this.mxSettings);
        }
        catch (ElementExistException elementExistException) {
            elementExistException.printStackTrace(this.log);
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(this.log);
            bl = false;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("insertSettings()", bl);
    }

    public void _getImageManager() {
        Object object = this.oObj.getImageManager();
        this.log.println("###### ImageManager ");
        XImageManager xImageManager = (XImageManager)UnoRuntime.queryInterface(XImageManager.class, object);
        this.tRes.tested("getImageManager()", xImageManager != null);
    }

    public void _getShortCutManager() {
        Object object = this.oObj.getShortCutManager();
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, object);
        String[] stringArray = xServiceInfo.getSupportedServiceNames();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            this.log.println("SuppService: " + stringArray[i]);
            if (!stringArray[i].equals(this.sShortCutManagerServiceName)) continue;
            bl = true;
        }
        this.tRes.tested("getShortCutManager()", bl);
    }

    public void _getEventsManager() {
        Object object = this.oObj.getEventsManager();
        this.tRes.tested("getEventsManager()", object == null);
    }

    public static PropertyValue[] createMenuBarEntry(String string, XIndexAccess xIndexAccess, XMultiServiceFactory xMultiServiceFactory, PrintWriter printWriter) {
        PropertyValue[] propertyValueArray = new PropertyValue[4];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "CommandURL";
        propertyValueArray[0].Value = "vnd.openoffice.org:MyMenu";
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Label";
        propertyValueArray[1].Value = string;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "Type";
        propertyValueArray[2].Value = new Short(0);
        propertyValueArray[3] = new PropertyValue();
        propertyValueArray[3].Name = "ItemDescriptorContainer";
        XSingleComponentFactory xSingleComponentFactory = (XSingleComponentFactory)UnoRuntime.queryInterface(XSingleComponentFactory.class, (Object)xIndexAccess);
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMultiServiceFactory);
            XComponentContext xComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, xPropertySet.getPropertyValue("DefaultContext"));
            propertyValueArray[3].Value = xSingleComponentFactory.createInstanceWithContext(xComponentContext);
        }
        catch (Exception exception) {
            printWriter.println("Could not create an instance for ItemDescriptorContainer property.");
            exception.printStackTrace(printWriter);
            return null;
        }
        return propertyValueArray;
    }

    public static void createMenuBarItem(String string, XIndexContainer xIndexContainer, PrintWriter printWriter) {
        PropertyValue[] propertyValueArray = new PropertyValue[3];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "CommandURL";
        propertyValueArray[0].Value = "macro:///Standard.Module1.Test()";
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Label";
        propertyValueArray[1].Value = string;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "Type";
        propertyValueArray[2].Value = new Short(0);
        try {
            xIndexContainer.insertByIndex(0, propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
        }
    }
}

