/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui.dialogs;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.ui.dialogs.XControlAccess;
import com.sun.star.ui.dialogs.XControlInformation;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueChanger;
import util.ValueComparer;

public class _XControlAccess
extends MultiMethodTest {
    public XControlAccess oObj = null;
    private XControlInformation xCI = null;
    private String[] supControls = null;
    private String[][] supProperties = null;

    protected void before() {
        this.xCI = (XControlInformation)UnoRuntime.queryInterface(XControlInformation.class, (Object)this.oObj);
        if (this.xCI == null) {
            throw new StatusException(Status.failed("XControlInformation not supported"));
        }
        this.supControls = this.xCI.getSupportedControls();
        this.supProperties = new String[this.supControls.length][];
        for (int i = 0; i < this.supControls.length; ++i) {
            try {
                this.supProperties[i] = this.xCI.getSupportedControlProperties(this.supControls[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(this.log);
                throw new StatusException("Exception while init.", illegalArgumentException);
            }
        }
    }

    public void _setControlProperty() {
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.supControls.length; ++i) {
            this.log.println("Checking properties for control " + this.supControls[i]);
            for (int j = 0; j < this.supProperties[i].length; ++j) {
                this.log.println("\t" + this.supProperties[i][j]);
                try {
                    Object object = this.oObj.getControlProperty(this.supControls[i], this.supProperties[i][j]);
                    Object object2 = ValueChanger.changePValue(object);
                    if (this.supProperties[i][j].startsWith("Help")) {
                        object2 = "HID:133";
                    }
                    this.oObj.setControlProperty(this.supControls[i], this.supProperties[i][j], object2);
                    Object object3 = this.oObj.getControlProperty(this.supControls[i], this.supProperties[i][j]);
                    this.log.println("\t Old:" + object + ",New:" + object2 + ",Result:" + object3);
                    if (!ValueComparer.equalValue(object2, object3)) {
                        string = string + "####Property '" + this.supProperties[i][j] + " of " + this.supControls[i] + " didn't work\n\r" + "\t Old:" + object + ",New:" + object2 + ",Result:" + object3 + "\n\r";
                    }
                    bl &= ValueComparer.equalValue(object2, object3);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.println("Unexpected exception:");
                    illegalArgumentException.printStackTrace(this.log);
                    bl = false;
                }
            }
        }
        this.log.println(string);
        this.tRes.tested("setControlProperty()", bl);
        this.tRes.tested("getControlProperty()", bl);
    }

    public void _getControlProperty() {
    }
}

