/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.URL;
import com.sun.star.util.XCloseable;
import com.sun.star.view.XControlAccess;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;

public class ODatasourceBrowser
extends TestCase {
    XDesktop the_Desk;
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        this.the_Desk = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
        System.setProperty("hideMe", "false");
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        System.setProperty("hideMe", "true");
        if (this.xTextDoc != null) {
            printWriter.println("    disposing xTextDoc ");
            try {
                XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
                xCloseable.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                printWriter.println("couldn't close document");
            }
            catch (DisposedException disposedException) {
                printWriter.println("couldn't close document");
            }
        }
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface;
        Object object;
        printWriter.println("creating a test environment");
        if (this.xTextDoc != null) {
            printWriter.println("    disposing xTextDoc ");
            try {
                object = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
                object.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                printWriter.println("couldn't close document");
            }
            catch (DisposedException disposedException) {
                printWriter.println("couldn't close document");
            }
        }
        object = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a text document");
            this.xTextDoc = ((SOfficeFactory)object).createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        this.shortWait();
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XController xController = xModel.getCurrentController();
        XFrame xFrame = this.the_Desk.getCurrentFrame();
        if (xFrame == null) {
            printWriter.println("Current frame was not found !!!");
        }
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
        XDispatch xDispatch = null;
        printWriter.println("opening DatasourceBrowser");
        URL uRL = new URL();
        uRL.Complete = ".component:DB/DataSourceBrowser";
        xDispatch = xDispatchProvider.queryDispatch(uRL, "_beamer", 12);
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        xDispatch.dispatch(uRL, propertyValueArray);
        XFrame xFrame2 = xFrame.findFrame("_beamer", 4);
        xFrame2.setName("DatasourceBrowser");
        XController xController2 = xFrame2.getController();
        Object[] objectArray = new Object[3];
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "DataSourceName";
        propertyValue.Value = "Bibliography";
        objectArray[0] = propertyValue;
        PropertyValue propertyValue2 = new PropertyValue();
        propertyValue2.Name = "CommandType";
        propertyValue2.Value = new Integer(0);
        objectArray[1] = propertyValue2;
        PropertyValue propertyValue3 = new PropertyValue();
        propertyValue3.Name = "Command";
        propertyValue3.Value = "biblio";
        objectArray[2] = propertyValue3;
        try {
            xInterface = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)xController2);
            xInterface.initialize(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't initialize document", exception);
        }
        this.shortWait();
        xInterface = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 10000, "CommandButton");
        WriterTools.getDrawPage(this.xTextDoc).add((XShape)xInterface);
        XControlModel xControlModel = xInterface.getControl();
        XControlAccess xControlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)xController);
        XControl xControl = null;
        try {
            xControl = xControlAccess.getControl(xControlModel);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        printWriter.println("creating a new environment for ODatasourceBrowser object");
        TestEnvironment testEnvironment = new TestEnvironment(xController2);
        testEnvironment.addObjRelation("XInitialization.args", objectArray);
        testEnvironment.addObjRelation("Frame", xFrame);
        testEnvironment.addObjRelation("SecondModel", xModel);
        testEnvironment.addObjRelation("otherWindow", xWindow);
        testEnvironment.addObjRelation("SecondController", xController);
        testEnvironment.addObjRelation("HasViewData", new Boolean(false));
        testEnvironment.addObjRelation("XDispatchProvider.URL", ".uno:DataSourceBrowser/FormLetter");
        return testEnvironment;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }
}

