/*
 * Decompiled with CFR 0.152.
 */
package mod._pcr;

import com.sun.star.awt.XWindow;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.inspection.XObjectInspector;
import com.sun.star.inspection.XObjectInspectorModel;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import helper.PropertyHandlerImpl;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.utils;

public class ObjectInspector
extends TestCase {
    protected static Object StarDesktop = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("create a desktop...");
        StarDesktop = DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF());
        if (StarDesktop == null) {
            throw new StatusException("Could not get a Desktop: null", null);
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        this.cleanup(testParameters, printWriter);
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            XInterface xInterface;
            XInterface xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.inspection.ObjectInspector");
            XObjectInspector xObjectInspector = (XObjectInspector)UnoRuntime.queryInterface(XObjectInspector.class, (Object)xInterface2);
            printWriter.println("ImplementationName '" + utils.getImplName(xObjectInspector) + "'");
            XInterface xInterface3 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.inspection.ObjectInspectorModel");
            XObjectInspectorModel xObjectInspectorModel = (XObjectInspectorModel)UnoRuntime.queryInterface(XObjectInspectorModel.class, (Object)xInterface3);
            XInterface xInterface4 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.inspection.ObjectInspectorModel");
            XObjectInspectorModel xObjectInspectorModel2 = (XObjectInspectorModel)UnoRuntime.queryInterface(XObjectInspectorModel.class, (Object)xInterface4);
            printWriter.println("create a floating frame...");
            XWindow xWindow = null;
            try {
                xInterface = DesktopTools.createFloatingWindow(xMultiServiceFactory);
                xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xInterface);
            }
            catch (StatusException statusException) {
                throw new StatusException("Coud not create test object", statusException);
            }
            xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.frame.Frame");
            XFrame xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)xInterface);
            xFrame.setName("ObjectInspector");
            xFrame.initialize(xWindow);
            XFramesSupplier xFramesSupplier = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, StarDesktop);
            XFrames xFrames = xFramesSupplier.getFrames();
            xFrames.append(xFrame);
            printWriter.println("attach ObjectInspector to floating frame...");
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)xObjectInspectorModel);
            xInitialization.initialize(new Object[0]);
            xObjectInspector.setInspectorModel(xObjectInspectorModel);
            Object[] objectArray = new Object[]{new PropertyHandlerImpl()};
            TestEnvironment testEnvironment = new TestEnvironment(xObjectInspector);
            testEnvironment.addObjRelation("Frame", xFrame);
            testEnvironment.addObjRelation("XObjectInspector.toInspect", objectArray);
            testEnvironment.addObjRelation("XObjectInspector.InspectorModelToSet", xObjectInspectorModel2);
            return testEnvironment;
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Unexpected exception", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    Closing dialog if one exists ... ");
        XFrame xFrame = null;
        XFrame xFrame2 = (XFrame)UnoRuntime.queryInterface(XFrame.class, StarDesktop);
        xFrame = xFrame2.findFrame("ObjectInspector", 255);
        if (xFrame != null) {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xFrame);
            try {
                xCloseable.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                printWriter.println("Could not close inspector: " + closeVetoException.toString());
            }
        }
    }
}

