/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessiblePreviewTable
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a Spreadsheet document");
            xSheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(xComponent);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface;
        Object object;
        Object object2;
        XInterface xInterface2;
        Object object3;
        XInterface xInterface3;
        XInterface xInterface4;
        XAccessibleContext xAccessibleContext = null;
        XCell xCell = null;
        try {
            printWriter.println("Getting spreadsheet");
            xInterface4 = xSheetDoc.getSheets();
            xInterface3 = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xInterface4);
            object3 = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xInterface3.getByIndex(0));
            printWriter.println("Getting a cell from sheet");
            xCell = object3.getCellByPosition(0, 0);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Error getting cell object from spreadsheet document", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Error getting cell object from spreadsheet document", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Error getting cell object from spreadsheet document", illegalArgumentException);
        }
        xCell.setFormula("Value");
        xInterface4 = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSheetDoc);
        xInterface3 = xInterface4.getCurrentController();
        try {
            object3 = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xInterface3);
            xInterface2 = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            object2 = new URL[]{new URL()};
            object2[0].Complete = ".uno:PrintPreview";
            xInterface2.parseStrict((URL[])object2);
            object = object2[0];
            xInterface = object3.queryDispatch((URL)object, "", 0);
            if (xInterface != null) {
                xInterface.dispatch((URL)object, null);
            }
        }
        catch (Exception exception) {
            printWriter.println("Couldn't change mode");
            throw new StatusException(Status.failed("Couldn't change mode"));
        }
        this.shortWait();
        object3 = new AccessibilityTools();
        xInterface2 = AccessibilityTools.getCurrentContainerWindow((XMultiServiceFactory)testParameters.getMSF(), (XModel)xInterface4);
        object2 = AccessibilityTools.getAccessibleObject(xInterface2);
        AccessibilityTools.printAccessibleTree(printWriter, (XAccessible)object2, testParameters.getBool("DebugIsActive"));
        AccessibilityTools.getAccessibleObjectForRole((XAccessible)object2, (short)58);
        xAccessibleContext = AccessibilityTools.SearchedContext;
        printWriter.println("ImplementationName " + utils.getImplName(xAccessibleContext));
        object = new TestEnvironment(xAccessibleContext);
        xInterface = AccessibilityTools.getAccessibleObjectForRole((XAccessible)object2, (short)44, "Zoom In");
        printWriter.println("Getting " + xInterface.getAccessibleName());
        final XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xInterface);
        ((TestEnvironment)object).addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xAccessibleAction.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        return object;
    }

    protected void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }
}

