/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.document.XImporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLContentImporter
extends TestCase {
    static XSpreadsheetDocument xSheetDoc;
    static XComponent comp;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a Spreadsheet document");
            xSheetDoc = sOfficeFactory.createCalcDoc(null);
            comp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing document ");
        DesktopTools.closeDoc(comp);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        Object object;
        XInterface xInterface = null;
        Object object2 = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object2 = xMultiServiceFactory.createInstance("com.sun.star.comp.Calc.XMLContentImporter");
            object = (XImporter)UnoRuntime.queryInterface(XImporter.class, object2);
            object.setTargetDocument(comp);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        xInterface = (XInterface)object2;
        printWriter.println("creating a new environment for Paragraph object");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("TargetDocument", comp);
        String[][] stringArrayArray = new String[][]{{"start", "office:document-content", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:text", "CDATA", "http://openoffice.org/2000/text", "xmlns:table", "CDATA", "http://openoffice.org/2000/table", "office:class", "CDATA", "spreadsheet"}, {"start", "office:body"}, {"start", "table:table", "table:name", "CDATA", "XMLContentImporter_test"}, {"end", "table:table"}, {"end", "office:body"}, {"end", "office:document-content"}};
        ((TestEnvironment)object).addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        final PrintWriter printWriter2 = printWriter;
        final XSpreadsheets xSpreadsheets = xSheetDoc.getSheets();
        printWriter.println("Sheets before importing :");
        String[] stringArray = xSpreadsheets.getElementNames();
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println("  " + stringArray[i]);
        }
        ((TestEnvironment)object).addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            public boolean checkImport() {
                printWriter2.println("Sheet names :");
                String[] stringArray = xSpreadsheets.getElementNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter2.println("  " + stringArray[i]);
                }
                return xSpreadsheets.hasByName("XMLContentImporter_test");
            }
        });
        return object;
    }
}

