/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdDrawPagesAccess
extends TestCase {
    XComponent xDrawDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a draw document");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        printWriter.println("creating a test environment");
        printWriter.println("getting Drawpages");
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        xDrawPages.insertNewByIndex(1);
        xDrawPages.insertNewByIndex(2);
        XDrawPages xDrawPages2 = xDrawPages;
        printWriter.println("creating a new environment for drawpage object");
        TestEnvironment testEnvironment = new TestEnvironment(xDrawPages2);
        return testEnvironment;
    }
}

