/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XLayer;
import com.sun.star.drawing.XLayerManager;
import com.sun.star.drawing.XLayerSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdLayer
extends TestCase {
    XComponent xDrawDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a draw document");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XLayer xLayer = null;
        XLayerManager xLayerManager = null;
        printWriter.println("creating a test environment");
        printWriter.println("getting LayerManager");
        XLayerSupplier xLayerSupplier = (XLayerSupplier)UnoRuntime.queryInterface(XLayerSupplier.class, (Object)this.xDrawDoc);
        XNameAccess xNameAccess = xLayerSupplier.getLayerManager();
        xLayerManager = (XLayerManager)UnoRuntime.queryInterface(XLayerManager.class, (Object)xNameAccess);
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xLayerManager);
        printWriter.println("getting LayerManager");
        try {
            xLayer = (XLayer)AnyConverter.toObject((Type)new Type(XLayer.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", illegalArgumentException);
        }
        printWriter.println("creating a new environment for drawpage object");
        TestEnvironment testEnvironment = new TestEnvironment(xLayer);
        return testEnvironment;
    }
}

