/*
 * Decompiled with CFR 0.152.
 */
package mod._streams.uno;

import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XObjectInputStream;
import com.sun.star.io.XObjectOutputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XPersistObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.CannotRegisterImplementationException;
import com.sun.star.registry.XImplementationRegistration;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.util.Vector;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class ObjectInputStream
extends TestCase {
    public void initialize(TestParameters testParameters, PrintWriter printWriter) {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.cmp.PersistObject");
        }
        catch (Exception exception) {
            printWriter.println("Could not create instance of PersistObject");
            exception.printStackTrace(printWriter);
            printWriter.println("Going on with test...");
        }
        if (object == null) {
            XImplementationRegistration xImplementationRegistration;
            Object object2;
            String string = utils.getFullTestURL("qadevlibs/MyPersistObjectImpl.jar");
            try {
                object2 = xMultiServiceFactory.createInstance("com.sun.star.registry.ImplementationRegistration");
                xImplementationRegistration = (XImplementationRegistration)UnoRuntime.queryInterface(XImplementationRegistration.class, object2);
            }
            catch (Exception exception) {
                System.err.println("Couldn't create implementation registration");
                exception.printStackTrace();
                throw new StatusException("Couldn't create ImplReg", exception);
            }
            object2 = null;
            try {
                System.out.println("Register library: " + string);
                xImplementationRegistration.registerImplementation("com.sun.star.loader.Java2", string, (XSimpleRegistry)object2);
                System.out.println("...done");
            }
            catch (CannotRegisterImplementationException cannotRegisterImplementationException) {
                System.err.println("Name: " + string + "  msg: " + cannotRegisterImplementationException.getMessage());
                cannotRegisterImplementationException.printStackTrace();
                throw new StatusException("Couldn't register MyPersistObject", cannotRegisterImplementationException);
            }
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Vector<Object> vector;
        System.out.println("create TestEnvironment started.");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        XInterface xInterface = null;
        try {
            object5 = xMultiServiceFactory.createInstance("com.sun.star.io.ObjectInputStream");
            object = xMultiServiceFactory.createInstance("com.sun.star.io.ObjectOutputStream");
            object2 = xMultiServiceFactory.createInstance("com.sun.star.io.Pipe");
            object4 = xMultiServiceFactory.createInstance("com.sun.star.io.MarkableInputStream");
            object3 = xMultiServiceFactory.createInstance("com.sun.star.io.MarkableOutputStream");
            xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.io.DataInputStream");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create instance", exception);
        }
        XActiveDataSource xActiveDataSource = (XActiveDataSource)UnoRuntime.queryInterface(XActiveDataSource.class, object);
        XActiveDataSource xActiveDataSource2 = (XActiveDataSource)UnoRuntime.queryInterface(XActiveDataSource.class, object3);
        XOutputStream xOutputStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, object3);
        XOutputStream xOutputStream2 = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, object2);
        XInputStream xInputStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, object2);
        xActiveDataSource.setOutputStream(xOutputStream);
        xActiveDataSource2.setOutputStream(xOutputStream2);
        XObjectInputStream xObjectInputStream = (XObjectInputStream)UnoRuntime.queryInterface(XObjectInputStream.class, object5);
        XObjectOutputStream xObjectOutputStream = null;
        xObjectOutputStream = (XObjectOutputStream)UnoRuntime.queryInterface(XObjectOutputStream.class, object);
        XActiveDataSink xActiveDataSink = (XActiveDataSink)UnoRuntime.queryInterface(XActiveDataSink.class, object4);
        XInputStream xInputStream2 = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, object4);
        XActiveDataSink xActiveDataSink2 = (XActiveDataSink)UnoRuntime.queryInterface(XActiveDataSink.class, object5);
        xActiveDataSink2.setInputStream(xInputStream2);
        xActiveDataSink.setInputStream(xInputStream);
        XPersistObject xPersistObject = null;
        try {
            vector = xMultiServiceFactory.createInstance("com.sun.star.cmp.PersistObject");
            xPersistObject = (XPersistObject)UnoRuntime.queryInterface(XPersistObject.class, (Object)vector);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't write persist object.", exception);
        }
        vector = new Vector<Object>();
        vector.add(new Boolean(true));
        vector.add(new Byte(123));
        vector.add(new Character('\u04d2'));
        vector.add(new Short(1234));
        vector.add(new Integer(123456));
        vector.add(new Float(1.234));
        vector.add(new Double(1.23456));
        vector.add("DataInputStream");
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        System.out.println("create environment");
        XObjectInputStream xObjectInputStream2 = xObjectInputStream;
        printWriter.println("creating a new environment for object");
        TestEnvironment testEnvironment = new TestEnvironment(xObjectInputStream2);
        testEnvironment.addObjRelation("PersistObject", xPersistObject);
        testEnvironment.addObjRelation("Connectable", xInterface);
        testEnvironment.addObjRelation("StreamWriter", xObjectOutputStream);
        testEnvironment.addObjRelation("InputStream", object2);
        testEnvironment.addObjRelation("StreamData", vector);
        testEnvironment.addObjRelation("ByteData", byArray);
        System.out.println("create TestEnvironment finished.");
        return testEnvironment;
    }
}

