/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleTabBar
extends TestCase {
    XComponent xDoc;

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xCalcDoc");
        if (this.xDoc != null) {
            this.closeDoc(this.xDoc);
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        if (this.xDoc != null) {
            this.closeDoc(this.xDoc);
        }
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory(xMultiServiceFactory);
        try {
            printWriter.println("creating a calc document");
            this.xDoc = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)sOfficeFactory.createCalcDoc(null));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        this.shortWait();
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        this.shortWait();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)40);
        printWriter.println("ImplementationName: " + utils.getImplName(xInterface));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        final XWindow xWindow2 = xWindow;
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                xWindow2.setPosSize(100, 100, 500, 500, (short)15);
            }
        });
        return testEnvironment;
    }

    private void shortWait() {
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }

    protected void closeDoc(XComponent xComponent) {
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xComponent);
        try {
            xCloseable.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            this.log.println("Couldn't close document " + closeVetoException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            this.log.println("Couldn't close document " + nullPointerException.getMessage());
        }
    }
}

