/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapeGrouper;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;

public class SvxShapeGroup
extends TestCase {
    XComponent xDrawDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a draw document");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XInterface xInterface;
        XInterface xInterface2;
        XInterface xInterface3;
        XInterface xInterface4 = null;
        XShapes xShapes = null;
        printWriter.println("creating a test environment");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("getting Drawpage");
            xInterface3 = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
            xInterface2 = xInterface3.getDrawPages();
            xInterface = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xInterface2);
            xInterface4 = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)xInterface.getByIndex(0));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get DrawPage", exception);
        }
        if (xInterface4 == null) {
            System.out.println("**************************");
            System.out.println("    XDrawPage is NULL");
            System.out.println("**************************");
        }
        printWriter.println("inserting some Shapes");
        xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xInterface4);
        xInterface3 = sOfficeFactory.createShape(this.xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse");
        xShapes.add(sOfficeFactory.createShape(this.xDrawDoc, 2000, 1500, 1000, 1000, "Line"));
        xShapes.add((XShape)xInterface3);
        xInterface2 = sOfficeFactory.createShape(this.xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
        xShapes.add((XShape)xInterface2);
        printWriter.println("adding two style as ObjRelation for ShapeDescriptor");
        xInterface = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface3);
        XStyle xStyle = null;
        try {
            xStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)xInterface.getPropertyValue("Style"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        xInterface = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface2);
        XStyle xStyle2 = null;
        try {
            xStyle2 = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)xInterface.getPropertyValue("Style"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            printWriter.println("get XShapeGroup");
            object = (XShapeGrouper)UnoRuntime.queryInterface(XShapeGrouper.class, (Object)xInterface4);
            xInterface4 = object.group(xShapes);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException(" Couldn't get XShapeGroup: ", exception);
        }
        printWriter.println("creating a new environment for drawpage object");
        object = new TestEnvironment(xInterface4);
        ShapeDsc shapeDsc = new ShapeDsc(5000, 3500, 7500, 10000, "Rectangle");
        printWriter.println("adding Shape as mod relation to environment");
        ((TestEnvironment)object).addObjRelation("Shape", new InstCreator(this.xDrawDoc, shapeDsc));
        ((TestEnvironment)object).addObjRelation("Style1", xStyle);
        ((TestEnvironment)object).addObjRelation("Style2", xStyle2);
        for (int i = 0; i < 6; ++i) {
            xInterface2 = sOfficeFactory.createShape(this.xDrawDoc, 5000 + 100 * i, 3500 + 100 * i, 7500 + 100 * i, 5000 + 100 * i, "Rectangle");
            xShapes.add((XShape)xInterface2);
        }
        return object;
    }
}

