/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleEdit
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface;
        XInterface xInterface2 = null;
        try {
            xInterface2 = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface2);
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XController xController = xModel.getCurrentController();
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
        XURLTransformer xURLTransformer = null;
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.util.URLTransformer");
            xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)xInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create URLTransformer", exception);
        }
        xInterface = null;
        printWriter.println("opening HyperlinkDialog");
        URL[] uRLArray = new URL[]{new URL()};
        uRLArray[0].Complete = ".uno:HyperlinkDialog";
        xURLTransformer.parseStrict(uRLArray);
        xInterface = xDispatchProvider.queryDispatch(uRLArray[0], "", 0);
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        xInterface.dispatch(uRLArray[0], propertyValueArray);
        this.shortWait();
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xInterface2 = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)44, "Close");
        action = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xInterface2);
        xInterface2 = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)60);
        printWriter.println("ImplementationName " + utils.getImplName(xInterface2));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface2);
        final XAccessibleEditableText xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)xInterface2);
        xAccessibleEditableText.setText("AccessibleEdit");
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                xAccessibleEditableText.setText("firing event ...");
                xAccessibleEditableText.setText("firing event ... 2");
                xAccessibleEditableText.setText("AccessibleEdit");
            }
        });
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)xInterface2);
        testEnvironment.addObjRelation("XAccessibleText.Text", xAccessibleText.getText());
        testEnvironment.addObjRelation("XAccessibleEditableText.hasAttr", Boolean.FALSE);
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    Closing dialog ... ");
        try {
            action.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("Couldn't close dialog");
        }
        catch (DisposedException disposedException) {
            printWriter.println("Dialog already disposed");
        }
        DesktopTools.closeDoc(xTextDoc);
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        try {
            SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            throw new StatusException("Can't create document", exception);
        }
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }
}

