/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleMenuSeparator
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;
    private static XMultiServiceFactory msf = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)msf.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        this.shortWait();
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XTopWindow xTopWindow = xExtendedToolkit.getActiveTopWindow();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xTopWindow);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)35);
        XAccessibleAction xAccessibleAction = null;
        try {
            object = xAccessibleContext.getAccessibleChild(1);
            xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, object);
            xAccessibleAction.doAccessibleAction(0);
            this.shortWait();
            xInterface = object.getAccessibleContext().getAccessibleChild(3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
        }
        printWriter.println("ImplementationName " + utils.getImplName(xInterface));
        object = new TestEnvironment(xInterface);
        final XAccessibleAction xAccessibleAction2 = xAccessibleAction;
        ((TestEnvironment)object).addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xAccessibleAction2.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                }
            }
        });
        return object;
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        try {
            msf = (XMultiServiceFactory)testParameters.getMSF();
            SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory(msf);
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            throw new StatusException("Can't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        DesktopTools.closeDoc(xTextDoc);
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }
}

