/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.awt.XGraphics;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XTextListener;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import ifc.awt._XTextListener;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class UnoControlDateField
extends TestCase {
    private static XTextDocument xTextDoc;
    private static XTextDocument xTD2;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            xTextDoc = sOfficeFactory.createTextDoc(null);
            xTD2 = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(xTextDoc);
        DesktopTools.closeDoc(xTD2);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface;
        XInterface xInterface2;
        XControl xControl = null;
        XWindowPeer xWindowPeer = null;
        XToolkit xToolkit = null;
        XDevice xDevice = null;
        XGraphics xGraphics = null;
        XWindow xWindow = null;
        XControlShape xControlShape = FormTools.createUnoControlShape(xTextDoc, 3000, 4500, 15000, 10000, "DateField", "UnoControlDateField");
        WriterTools.getDrawPage(xTextDoc).add(xControlShape);
        XControlModel xControlModel = xControlShape.getControl();
        XControlAccess xControlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDoc.getCurrentController());
        try {
            xControl = xControlAccess.getControl(xControlModel);
            xWindowPeer = xControlAccess.getControl(xControlModel).getPeer();
            xToolkit = xWindowPeer.getToolkit();
            xDevice = xToolkit.createScreenCompatibleDevice(200, 200);
            xGraphics = xDevice.createGraphics();
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get DateFieldControl");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get DateFieldControl", exception);
        }
        printWriter.println("creating a new environment for UnoControlDateField object");
        TestEnvironment testEnvironment = new TestEnvironment(xControl);
        testEnvironment.addObjRelation("GRAPHICS", xGraphics);
        testEnvironment.addObjRelation("CONTEXT", xTextDoc);
        testEnvironment.addObjRelation("WINPEER", xWindowPeer);
        testEnvironment.addObjRelation("TOOLKIT", xToolkit);
        testEnvironment.addObjRelation("MODEL", xControlModel);
        System.out.println("ImplementationName: " + utils.getImplName(xControl));
        try {
            xInterface2 = xTD2.getCurrentController();
            xInterface = xInterface2.getFrame();
            xWindow = xInterface.getComponentWindow();
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create XWindow", exception);
        }
        testEnvironment.addObjRelation("XWindow.AnotherWindow", xWindow);
        testEnvironment.addObjRelation("XWindow.ControlShape", xControlShape);
        xInterface2 = new _XTextListener.TestTextListener();
        xInterface = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)xControl);
        xInterface.addTextListener((XTextListener)xInterface2);
        testEnvironment.addObjRelation("TestTextListener", xInterface2);
        return testEnvironment;
    }
}

