/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLContentImporter
extends TestCase {
    XComponent xDrawDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a drawdocument");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing document ");
        this.xDrawDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface = null;
        Object object = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.comp.Draw.XMLContentImporter");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        xInterface = (XInterface)object;
        printWriter.println("creating a new environment for Paragraph object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("TargetDocument", this.xDrawDoc);
        String[][] stringArrayArray = new String[][]{{"start", "office:document", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:draw", "CDATA", "http://openoffice.org/2000/drawing", "office:class", "CDATA", "drawing", "office:version", "CDATA", "1.0"}, {"start", "office:body"}, {"start", "draw:page", "draw:name", "CDATA", "NewSlide1", "draw:master-page-name", "CDATA", "Default"}, {"end", "draw:page"}, {"start", "draw:page", "draw:name", "CDATA", "NewSlide2", "draw:master-page-name", "CDATA", "Default"}, {"end", "draw:page"}, {"end", "draw:page"}, {"end", "office:body"}, {"end", "office:document"}};
        testEnvironment.addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        final PrintWriter printWriter2 = printWriter;
        testEnvironment.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            public boolean checkImport() {
                int n;
                XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)XMLContentImporter.this.xDrawDoc);
                XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
                XNamed[] xNamedArray = new XNamed[xDrawPages.getCount()];
                for (n = 0; n < xDrawPages.getCount(); ++n) {
                    try {
                        xNamedArray[n] = (XNamed)UnoRuntime.queryInterface(XNamed.class, xDrawPages.getByIndex(n));
                        continue;
                    }
                    catch (com.sun.star.uno.Exception exception) {
                        exception.printStackTrace(printWriter2);
                        throw new StatusException("Can't get page name by index.", exception);
                    }
                }
                printWriter2.println("Slide names after import:");
                for (n = 0; n < xDrawPages.getCount(); ++n) {
                    if (!xNamedArray[n].getName().equals("NewSlide1") && !xNamedArray[n].getName().equals("NewSlide2")) {
                        printWriter2.println("Error: some imported values are not exist in target document!");
                        return false;
                    }
                    printWriter2.println("  " + xNamedArray[n].getName());
                }
                return true;
            }
        });
        return testEnvironment;
    }
}

