/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;

final class LineBuffer {
    static final int BUFLEN = 256;
    private static final int EOL_HINT_MASK = 57296;
    private Reader in;
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int offset = 0;
    private int end = 0;
    private int otherEnd;
    private int lineno;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;
    private static final boolean checkSelf = true;

    LineBuffer(Reader reader, int n) {
        this.in = reader;
        this.lineno = n;
    }

    int read() throws IOException {
        char c;
        do {
            if (this.end == this.offset && !this.fill()) {
                return -1;
            }
            c = this.buffer[this.offset];
            ++this.offset;
            if ((c & 0xDFD0) != 0) continue;
            switch (c) {
                case '\r': {
                    if (this.offset != this.end) {
                        if (this.buffer[this.offset] == '\n') {
                            ++this.offset;
                        }
                    } else {
                        this.lastWasCR = true;
                    }
                }
                case '\n': 
                case '\u2028': 
                case '\u2029': {
                    this.prevStart = this.lineStart;
                    this.lineStart = this.offset;
                    ++this.lineno;
                    return 10;
                }
            }
        } while (c >= '\u0080' && LineBuffer.formatChar(c));
        return c;
    }

    void unread() {
        if (this.offset == 0 && !this.hitEOF) {
            Context.codeBug();
        }
        if (this.offset == 0) {
            return;
        }
        --this.offset;
        char c = this.buffer[this.offset];
        if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
            this.lineStart = this.prevStart;
            --this.lineno;
        }
    }

    private void skipFormatChar() {
        if (!LineBuffer.formatChar(this.buffer[this.offset])) {
            Context.codeBug();
        }
        if (this.offset != 0) {
            char c = this.buffer[this.offset];
            this.buffer[this.offset] = this.buffer[this.offset - 1];
            this.buffer[this.offset - 1] = c;
        } else if (this.otherEnd != 0) {
            char c = this.buffer[this.offset];
            this.buffer[this.offset] = this.otherBuffer[this.otherEnd - 1];
            this.otherBuffer[this.otherEnd - 1] = c;
        }
        ++this.offset;
    }

    int peek() throws IOException {
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
                return 10;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return c;
            }
            this.skipFormatChar();
        }
        return -1;
    }

    boolean match(int n) throws IOException {
        if ((n & 0xDFD0) == 0 && LineBuffer.eolChar(n)) {
            Context.codeBug();
        }
        if (n >= 128 && LineBuffer.formatChar(n)) {
            Context.codeBug();
        }
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if (n == c) {
                ++this.offset;
                return true;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return false;
            }
            this.skipFormatChar();
        }
        return false;
    }

    String getLine() {
        int n;
        int n2 = this.offset;
        while (true) {
            if (n2 == this.end) {
                if (this.end == this.buffer.length) {
                    char[] cArray = new char[this.buffer.length * 2];
                    System.arraycopy(this.buffer, 0, cArray, 0, this.end);
                    this.buffer = cArray;
                }
                n = 0;
                try {
                    n = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
                }
                catch (IOException iOException) {
                    break;
                }
                if (n < 0) break;
                this.end += n;
            }
            if (((n = this.buffer[n2]) & 0xDFD0) == 0 && LineBuffer.eolChar(n)) break;
            ++n2;
        }
        n = this.lineStart;
        if (this.lineStart < 0) {
            StringBuffer stringBuffer = new StringBuffer(this.otherEnd - this.otherStart + n2);
            stringBuffer.append(this.otherBuffer, this.otherStart, this.otherEnd - this.otherStart);
            stringBuffer.append(this.buffer, 0, n2);
            return stringBuffer.toString();
        }
        return new String(this.buffer, this.lineStart, n2 - this.lineStart);
    }

    int getOffset() {
        if (this.lineStart < 0) {
            return this.offset + (this.otherEnd - this.otherStart);
        }
        return this.offset - this.lineStart;
    }

    private boolean fill() throws IOException {
        if (this.end != this.offset) {
            Context.codeBug();
        }
        char[] cArray = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = cArray;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart >= 0 ? this.lineStart : 0;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : -1;
        this.prevStart = this.lineStart;
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.offset;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.offset;
            this.lastWasCR = false;
        }
        return true;
    }

    int getLineno() {
        return this.lineno;
    }

    boolean eof() {
        return this.hitEOF;
    }

    private static boolean formatChar(int n) {
        return Character.getType((char)n) == 16;
    }

    private static boolean eolChar(int n) {
        return n == 13 || n == 10 || n == 8232 || n == 8233;
    }
}

