/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ImageHelper {
    Image m_aImage;
    int[] m_aPixels;
    int m_w = 0;
    int m_h = 0;
    boolean m_bGrabbed = false;

    public ImageHelper(Image image) {
        this.m_aImage = image;
        this.m_w = this.getWidth();
        this.m_h = this.getHeight();
        int n = 0;
        int n2 = 0;
        this.m_aPixels = new int[this.m_w * this.m_h];
        PixelGrabber pixelGrabber = new PixelGrabber(this.m_aImage, n, n2, this.m_w, this.m_h, this.m_aPixels, 0, this.m_w);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        this.m_bGrabbed = true;
    }

    public int getWidth() {
        return this.m_aImage.getWidth(null);
    }

    public int getHeight() {
        return this.m_aImage.getHeight(null);
    }

    public int getPixel(int n, int n2) {
        return this.m_aPixels[n2 * this.m_w + n];
    }

    public static ImageHelper createImageHelper(String string) throws IOException {
        Object object;
        Image image = null;
        File file = new File(string);
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            object = Class.forName("javax.imageio.ImageIO");
            Method method = ((Class)object).getDeclaredMethod("read", File.class);
            Object object2 = method.invoke(object, file);
            image = (Image)object2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reflectiveOperationException = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            reflectiveOperationException = invocationTargetException;
        }
        if (reflectiveOperationException != null) {
            object = System.getProperty("java.version");
            throw new IOException("Cannot construct object with current Java version " + (String)object + ": " + reflectiveOperationException.getMessage());
        }
        return new ImageHelper(image);
    }
}

