/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PerformanceContainer {
    private long m_nStartTime;
    static final int Load = 0;
    static final int Store = 1;
    static final int Print = 2;
    static final int OfficeStart = 3;
    static final int StoreAsPDF = 4;
    private long[] m_nTime = new long[5];
    private String m_sMSOfficeVersion;

    public long getStartTime() {
        return System.currentTimeMillis();
    }

    public void setStartTime(long l) {
        this.m_nStartTime = l;
    }

    private long meanTime(long l) {
        if (l == 0L) {
            GlobalLogWriter.get().println("Forgotten to initialise a start timer.");
            return 0L;
        }
        long l2 = System.currentTimeMillis();
        return l2 - l;
    }

    public PerformanceContainer() {
        for (int i = 0; i < 5; ++i) {
            this.m_nTime[i] = 0L;
        }
    }

    public void setTime(int n, long l) {
        this.m_nTime[n] = l;
    }

    public long getTime(int n) {
        return this.m_nTime[n];
    }

    public void startTime(int n) {
        this.m_nTime[n] = this.getStartTime();
    }

    public void stopTime(int n) {
        this.m_nTime[n] = this.meanTime(this.m_nTime[n]);
    }

    public String getMSOfficeVersion() {
        return this.m_sMSOfficeVersion;
    }

    public void print(FileWriter fileWriter) throws IOException {
        String string = System.getProperty("line.separator");
        fileWriter.write("loadtime=" + String.valueOf(this.m_nTime[0]) + string);
        fileWriter.write("storetime=" + String.valueOf(this.m_nTime[1]) + string);
        fileWriter.write("printtime=" + String.valueOf(this.m_nTime[2]) + string);
        fileWriter.write("officestarttime=" + String.valueOf(this.m_nTime[3]) + string);
        fileWriter.write("storeaspdftime=" + String.valueOf(this.m_nTime[4]) + string);
    }

    public static double stringToDouble(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            GlobalLogWriter.get().println("Can't convert string to double " + string);
        }
        return d;
    }

    public static long secondsToMilliSeconds(double d) {
        return (long)(d * 1000.0);
    }

    public void readWordValuesFromFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            GlobalLogWriter.get().println("couldn't find file " + string);
            return;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            String string2 = "";
            while (string2 != null) {
                String string3;
                string2 = randomAccessFile.readLine();
                if (string2 == null || string2.length() < 2 || string2.startsWith("#")) continue;
                if (string2.startsWith("WordStartTime=")) {
                    string3 = string2.substring(14);
                    this.m_nTime[3] = PerformanceContainer.secondsToMilliSeconds(PerformanceContainer.stringToDouble(string3));
                    continue;
                }
                if (string2.startsWith("WordLoadTime=")) {
                    string3 = string2.substring(13);
                    this.m_nTime[0] = PerformanceContainer.secondsToMilliSeconds(PerformanceContainer.stringToDouble(string3));
                    continue;
                }
                if (string2.startsWith("WordPrintTime=")) {
                    string3 = string2.substring(14);
                    this.m_nTime[2] = PerformanceContainer.secondsToMilliSeconds(PerformanceContainer.stringToDouble(string3));
                    continue;
                }
                if (string2.startsWith("WordVersion=")) {
                    string3 = string2.substring(12);
                    this.m_sMSOfficeVersion = "Word:" + string3;
                    continue;
                }
                if (string2.startsWith("ExcelVersion=")) {
                    string3 = string2.substring(13);
                    this.m_sMSOfficeVersion = "Excel:" + string3;
                    continue;
                }
                if (!string2.startsWith("PowerPointVersion=")) continue;
                string3 = string2.substring(18);
                this.m_sMSOfficeVersion = "PowerPoint:" + string3;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            GlobalLogWriter.get().println("couldn't open file " + string);
            GlobalLogWriter.get().println("Message: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            GlobalLogWriter.get().println("Exception while reading file " + string);
            GlobalLogWriter.get().println("Message: " + iOException.getMessage());
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            GlobalLogWriter.get().println("Couldn't close file " + string);
            GlobalLogWriter.get().println("Message: " + iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
    }
}

