/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.XLibraryContainer;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XChangesBatch;
import com.sun.star.util.XURLTransformer;
import util.utils;

public class BasicMacroTools {
    private final XDispatchProvider mDispProv;
    private final XMultiServiceFactory mMSF;
    private final XURLTransformer mParser;
    private final XNameAccess mLCxNA;
    private final XLibraryContainer mLCxLC;

    public BasicMacroTools(XMultiServiceFactory xMultiServiceFactory, XModel xModel, XComponent xComponent) throws Exception {
        try {
            this.mMSF = xMultiServiceFactory;
            this.mDispProv = BasicMacroTools.makeDispatchProvider(this.mMSF, xModel);
            this.mParser = BasicMacroTools.makeParser(this.mMSF);
            Object object = null;
            try {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xComponent);
                object = xPropertySet.getPropertyValue("BasicLibraries");
            }
            catch (com.sun.star.uno.Exception exception) {
                throw new Exception("Couldn't get BasicLibraries-Container from document: " + exception.toString());
            }
            this.mLCxNA = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, object);
            this.mLCxLC = (XLibraryContainer)UnoRuntime.queryInterface(XLibraryContainer.class, object);
        }
        catch (Exception exception) {
            throw new Exception("could not initialize BasicMacros " + exception.toString());
        }
    }

    public BasicMacroTools(XMultiServiceFactory xMultiServiceFactory, XModel xModel) throws Exception {
        try {
            this.mMSF = xMultiServiceFactory;
            this.mDispProv = BasicMacroTools.makeDispatchProvider(this.mMSF, xModel);
            this.mParser = BasicMacroTools.makeParser(this.mMSF);
            Object object = null;
            try {
                object = this.mMSF.createInstance("com.sun.star.script.ApplicationScriptLibraryContainer");
            }
            catch (com.sun.star.uno.Exception exception) {
                throw new Exception("Couldn't create ApplicationScriptLibraryContainer" + exception.toString());
            }
            this.mLCxNA = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, object);
            this.mLCxLC = (XLibraryContainer)UnoRuntime.queryInterface(XLibraryContainer.class, object);
        }
        catch (Exception exception) {
            throw new Exception("could not initialize BasicMacros " + exception.toString());
        }
    }

    private static XDispatchProvider makeDispatchProvider(XMultiServiceFactory xMultiServiceFactory, XModel xModel) throws Exception {
        XController xController = xModel.getCurrentController();
        XFrame xFrame = xController.getFrame();
        if (xFrame == null) {
            throw new Exception("Could not create DispatchProvider");
        }
        return (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
    }

    private static XURLTransformer makeParser(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        try {
            return (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, xMultiServiceFactory.createInstance("com.sun.star.util.URLTransformer"));
        }
        catch (Exception exception) {
            throw new Exception("could not create UTL-Transformer " + exception.toString());
        }
    }

    public void loadLibrary(String string, String string2) throws Exception {
        try {
            this.appendLibrary(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("ERROR: Could not append Library " + string + exception.toString());
        }
        try {
            this.mLCxLC.loadLibrary(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new Exception("ERROR: Could not load Library " + string + noSuchElementException.toString());
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace();
            throw new Exception("ERROR: Could not load Library " + string + wrappedTargetException.toString());
        }
    }

    private void appendLibrary(String string, String string2) throws Exception {
        try {
            this.removeLibrary(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mLCxLC.createLibraryLink(string, string2, false);
        }
        catch (ElementExistException elementExistException) {
            elementExistException.printStackTrace();
            throw new Exception("ERROR: Library " + string + "already exist." + elementExistException.toString());
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
            throw new Exception("Could not link Basic library:" + string + exception.toString());
        }
    }

    public void removeLibrary(String string) throws Exception {
        if (this.mLCxNA.hasByName(string)) {
            try {
                this.mLCxLC.removeLibrary(string);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
                throw new Exception("Could not remove Basic library:" + string + ": Library does not exist" + noSuchElementException.toString());
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
                throw new Exception("Could not remove Basic library:" + string + wrappedTargetException.toString());
            }
        }
    }

    public void runMarco(String string) throws Exception {
        URL[] uRLArray = new URL[]{new URL()};
        uRLArray[0].Complete = "macro://./" + string;
        this.mParser.parseStrict(uRLArray);
        URL uRL = uRLArray[0];
        XDispatch xDispatch = this.mDispProv.queryDispatch(uRL, "", 0);
        if (xDispatch == null) {
            throw new Exception("Could not run Macro " + string);
        }
        xDispatch.dispatch(uRL, null);
    }

    public static void addSecureBasicMarcosURL(XMultiServiceFactory xMultiServiceFactory, String string) throws Exception {
        string = utils.getFullURL(string);
        Object[] objectArray = new PropertyValue[1];
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "nodepath";
        propertyValue.Value = "/org.openoffice.Office.Common/Security";
        objectArray[0] = propertyValue;
        Object object = xMultiServiceFactory.createInstance("com.sun.star.configuration.ConfigurationProvider");
        XMultiServiceFactory xMultiServiceFactory2 = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, object);
        Object object2 = xMultiServiceFactory2.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", objectArray);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, object2);
        Object object3 = xPropertySet.getPropertyValue("Scripting");
        XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, object3);
        xPropertySet2.setPropertyValue("SecureURL", new String[]{string});
        xPropertySet2.setPropertyValue("OfficeBasic", new Integer(2));
        XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, object2);
        xChangesBatch.commitChanges();
    }
}

