/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.FontSlant;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.TabAlign;
import com.sun.star.style.TabStop;
import com.sun.star.uno.RuntimeException;
import java.util.ArrayList;
import java.util.Vector;
import javax.accessibility.AccessibleEditableText;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import org.openoffice.java.accessibility.AccessibleTextImpl;

public class AccessibleEditableTextImpl
extends AccessibleTextImpl
implements AccessibleEditableText {
    static final double toPointFactor = 0.028985507246376812;

    public AccessibleEditableTextImpl(XAccessibleEditableText xAccessibleEditableText) {
        super((XAccessibleText)xAccessibleEditableText);
    }

    public void cut(int n, int n2) {
        try {
            ((XAccessibleEditableText)this.unoObject).cutText(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void delete(int n, int n2) {
        try {
            ((XAccessibleEditableText)this.unoObject).deleteText(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public String getTextRange(int n, int n2) {
        try {
            return this.unoObject.getTextRange(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {
        }
        return null;
    }

    public void insertTextAtIndex(int n, String string) {
        try {
            ((XAccessibleEditableText)this.unoObject).insertText(string, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void paste(int n) {
        try {
            ((XAccessibleEditableText)this.unoObject).pasteText(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void replaceText(int n, int n2, String string) {
        try {
            ((XAccessibleEditableText)this.unoObject).replaceText(n, n2, string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void selectText(int n, int n2) {
        try {
            this.unoObject.setSelection(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void setAttributes(int n, int n2, AttributeSet attributeSet) {
        PropertyValue propertyValue;
        Vector<PropertyValue> vector = new Vector<PropertyValue>();
        Object object = attributeSet.getAttribute(StyleConstants.Alignment);
        if (null != object) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaAdjust";
            switch (StyleConstants.getAlignment(attributeSet)) {
                case 2: {
                    propertyValue.Value = ParagraphAdjust.RIGHT;
                    break;
                }
                case 1: {
                    propertyValue.Value = ParagraphAdjust.CENTER;
                    break;
                }
                case 3: {
                    propertyValue.Value = ParagraphAdjust.BLOCK;
                    break;
                }
                default: {
                    propertyValue.Value = ParagraphAdjust.LEFT;
                }
            }
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.Background))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharBackColor";
            propertyValue.Value = new Integer(StyleConstants.getBackground(attributeSet).getRGB());
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.Bold))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharWeight";
            propertyValue.Value = StyleConstants.isBold(attributeSet) ? new Float(150.0f) : new Float(100.0f);
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.FirstLineIndent))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaFirstLineIndent";
            propertyValue.Value = new Double((double)StyleConstants.getFirstLineIndent(attributeSet) / 0.028985507246376812);
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.FontFamily))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharFontPitch";
            propertyValue.Value = StyleConstants.getFontFamily(attributeSet).equals("Proportional") ? new Short("2") : new Short("1");
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.FontSize))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharHeight";
            propertyValue.Value = new Integer(StyleConstants.getFontSize(attributeSet));
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.Foreground))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharColor";
            propertyValue.Value = new Integer(StyleConstants.getForeground(attributeSet).getRGB());
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.Italic))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharPosture";
            propertyValue.Value = StyleConstants.isItalic(attributeSet) ? FontSlant.ITALIC : FontSlant.DONTKNOW;
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.LeftIndent))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaFirstLeftMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getLeftIndent(attributeSet) / 0.028985507246376812).intValue());
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.RightIndent))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaFirstRightMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getRightIndent(attributeSet) / 0.028985507246376812).intValue());
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.LineSpacing))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaLineSpacing";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getLineSpacing(attributeSet) / 0.028985507246376812).intValue());
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.SpaceAbove))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaTopMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getSpaceAbove(attributeSet) / 0.028985507246376812).intValue());
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.SpaceBelow))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaBottomMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getSpaceBelow(attributeSet) / 0.028985507246376812).intValue());
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.StrikeThrough))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharPosture";
            propertyValue.Value = StyleConstants.isStrikeThrough(attributeSet) ? new Short(1) : new Short(0);
            vector.add(propertyValue);
        }
        if (null == (object = attributeSet.getAttribute(StyleConstants.Superscript))) {
            object = attributeSet.getAttribute(StyleConstants.Subscript);
        }
        if (null != object) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharEscapement";
            propertyValue.Value = StyleConstants.isSuperscript(attributeSet) ? new Short("1") : (StyleConstants.isSubscript(attributeSet) ? new Short("-1") : new Short("0"));
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.TabSet))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaTabStops";
            TabSet tabSet = StyleConstants.getTabSet(attributeSet);
            ArrayList<TabStop> arrayList = new ArrayList<TabStop>(tabSet.getTabCount());
            int n3 = 0;
            int n4 = tabSet.getTabCount();
            while (n3 < n4) {
                javax.swing.text.TabStop tabStop = tabSet.getTab(n3);
                TabStop tabStop2 = new TabStop();
                tabStop2.Position = new Double((double)tabStop.getPosition() / 0.028985507246376812).intValue();
                switch (tabStop.getAlignment()) {
                    case 2: {
                        tabStop2.Alignment = TabAlign.CENTER;
                        break;
                    }
                    case 1: {
                        tabStop2.Alignment = TabAlign.RIGHT;
                        break;
                    }
                    case 4: {
                        tabStop2.Alignment = TabAlign.DECIMAL;
                        break;
                    }
                    default: {
                        tabStop2.Alignment = TabAlign.LEFT;
                    }
                }
                arrayList.add(tabStop2);
                ++n3;
            }
            propertyValue.Value = (TabStop[])arrayList.toArray();
            vector.add(propertyValue);
        }
        if (null != (object = attributeSet.getAttribute(StyleConstants.Underline))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharUnderline";
            propertyValue.Value = StyleConstants.isUnderline(attributeSet) ? new Short(1) : new Short(0);
            vector.add(propertyValue);
        }
        try {
            ((XAccessibleEditableText)this.unoObject).setAttributes(n, n2, (PropertyValue[])vector.toArray());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void setTextContents(String string) {
        try {
            ((XAccessibleEditableText)this.unoObject).setText(string);
        }
        catch (RuntimeException runtimeException) {}
    }
}

