/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import org.openoffice.java.accessibility.AbstractButton;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Component;

public class Menu
extends AbstractButton
implements Accessible {
    private Vector children;
    protected XAccessibleSelection unoAccessibleSelection = null;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleSelection;

    protected Menu(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
        try {
            int n = this.unoAccessibleContext.getAccessibleChildCount();
            this.children = new Vector(n);
            int n2 = 0;
            while (n2 < n) {
                Component component = this.getComponent(this.unoAccessibleContext.getAccessibleChild(n2));
                if (component != null) {
                    this.children.add(component);
                }
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.children == null) {
                this.children = new Vector(0);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    protected synchronized void add(XAccessible xAccessible) {
        block2: {
            Component component = this.getComponent(xAccessible);
            if (component == null) break block2;
            try {
                this.children.add(xAccessible.getAccessibleContext().getAccessibleIndexInParent(), component);
                this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    protected synchronized void remove(XAccessible xAccessible) {
        block2: {
            Component component = this.getComponent(xAccessible);
            if (component == null) break block2;
            try {
                this.children.remove(component);
                this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected synchronized int indexOf(Object object) {
        return this.children.indexOf(object);
    }

    protected Component getComponent(XAccessible xAccessible) {
        Component component = AccessibleObjectFactory.getAccessibleComponent(xAccessible);
        if (component == null && (component = AccessibleObjectFactory.createAccessibleComponent(xAccessible)) instanceof Accessible) {
            ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
        }
        return component;
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleMenuListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleMenu();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleMenu
    extends AbstractButton.AccessibleAbstractButton
    implements AccessibleSelection {
        protected AccessibleMenu() {
            Menu.this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleSelection == null ? (class$com$sun$star$accessibility$XAccessibleSelection = Menu.class$("com.sun.star.accessibility.XAccessibleSelection")) : class$com$sun$star$accessibility$XAccessibleSelection), (Object)Menu.this.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() instanceof Menu) {
                return ((Menu)this.getAccessibleParent()).indexOf(Menu.this);
            }
            return super.getAccessibleIndexInParent();
        }

        public synchronized int getAccessibleChildrenCount() {
            return Menu.this.children.size();
        }

        public synchronized Accessible getAccessibleChild(int n) {
            try {
                if (n < Menu.this.children.size()) {
                    return (Accessible)Menu.this.children.get(n);
                }
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(Menu.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public Accessible getAccessibleSelection(int n) {
            try {
                return (Accessible)((Object)Menu.this.getComponent(Menu.this.unoAccessibleSelection.getSelectedAccessibleChild(n)));
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void addAccessibleSelection(int n) {
            try {
                Menu.this.unoAccessibleSelection.selectAccessibleChild(n);
            }
            catch (Exception exception) {}
        }

        public void clearAccessibleSelection() {
            try {
                Menu.this.unoAccessibleSelection.clearAccessibleSelection();
            }
            catch (RuntimeException runtimeException) {}
        }

        public int getAccessibleSelectionCount() {
            try {
                return Menu.this.unoAccessibleSelection.getSelectedAccessibleChildCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public boolean isAccessibleChildSelected(int n) {
            try {
                return Menu.this.unoAccessibleSelection.isAccessibleChildSelected(n);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void removeAccessibleSelection(int n) {
            if (this.isAccessibleChildSelected(n)) {
                this.clearAccessibleSelection();
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class AccessibleMenuListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleMenuListener() {
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        Menu.this.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    Menu.this.add(accessibleEventObject.NewValue);
                    break;
                }
                case 9: {
                    Menu.this.firePropertyChange("AccessibleSelection", null, null);
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

