/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.ClassContext;
import com.sun.star.lib.sandbox.ClassContextProxy;
import com.sun.star.lib.sandbox.ProtectionDomain;
import com.sun.star.lib.sandbox.ResourceProxy;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

final class ClassContextImpl
extends ClassLoader
implements ClassContext {
    private static int instances;
    private static final boolean DEBUG = false;
    private URL codeBase;
    private ProtectionDomain protectionDomain;
    private boolean _bSecure;
    private Vector _cargoVector = new Vector();
    private Vector m_class_path_jars;
    private ThreadGroup threadGroup;

    public ClassContextImpl(URL uRL, ProtectionDomain protectionDomain, ThreadGroup threadGroup, boolean bl) {
        this(uRL, protectionDomain, threadGroup);
        this._bSecure = bl;
    }

    public ClassContextImpl(URL uRL, ProtectionDomain protectionDomain, ThreadGroup threadGroup) {
        ++instances;
        this.codeBase = uRL;
        this.protectionDomain = protectionDomain;
        this.threadGroup = threadGroup;
    }

    public void finalize() {
        --instances;
    }

    public URL getBase() {
        return this.codeBase;
    }

    public void addCargo(Object object) {
        this._cargoVector.addElement(object);
    }

    public URL getCodeBase() {
        return this.getBase();
    }

    public boolean hasThreadGroup() {
        return this.threadGroup != null && !this.threadGroup.isDestroyed();
    }

    public ThreadGroup getThreadGroup() {
        if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
            this.threadGroup = new ThreadGroup(this.codeBase.toString());
            this.threadGroup.setDaemon(true);
        }
        return this.threadGroup;
    }

    boolean checkSecurity() {
        return !this._bSecure;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        block4: {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream != null) break block4;
            try {
                URL uRL = new URL(this.codeBase, string);
                if (ResourceProxy.isResource(uRL)) {
                    ResourceProxy resourceProxy = ResourceProxy.load(uRL, this.protectionDomain);
                    inputStream = resourceProxy.getInputStream();
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return inputStream;
    }

    public URL getResource(String string) {
        URL uRL;
        block3: {
            uRL = ClassLoader.getSystemResource(string);
            if (uRL != null) break block3;
            try {
                uRL = new URL(this.codeBase, string);
                if (!ResourceProxy.isResource(uRL)) {
                    uRL = null;
                    break block3;
                }
                uRL = new URL("appletresource:" + this.codeBase + "/+/" + string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return uRL;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null && !string.startsWith("JSGen")) {
            this.getClass();
            clazz = Class.forName(string);
        }
        return clazz;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        block19: {
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            clazz = null;
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    Object object;
                    Object object2;
                    block20: {
                        try {
                            ResourceProxy resourceProxy = null;
                            resourceProxy = ResourceProxy.load(new URL(this.codeBase, string.replace('.', '/') + ".class"), this.protectionDomain);
                            byte[] byArray = resourceProxy.getBytes();
                            clazz = this.defineClass(string, byArray, 0, byArray.length);
                            break block19;
                        }
                        catch (IOException iOException) {
                            if (null != this.m_class_path_jars) break block20;
                            object2 = new Vector();
                            try {
                                object = new URL(this.codeBase, "META-INF/MANIFEST.MF");
                                ResourceProxy resourceProxy = ResourceProxy.load((URL)object, null);
                                InputStream inputStream = resourceProxy.getInputStream();
                                Manifest manifest = new Manifest(inputStream);
                                Attributes attributes = manifest.getMainAttributes();
                                String string2 = attributes.getValue("Class-Path");
                                if (string2 != null) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                                    while (stringTokenizer.hasMoreElements()) {
                                        try {
                                            String string3 = (String)stringTokenizer.nextElement();
                                            URL uRL = string3.charAt(0) != '/' && string3.indexOf(58) < 0 ? new URL(this.codeBase, string3) : new URL(string3);
                                            ClassContext classContext = ClassContextProxy.create(uRL, this.protectionDomain, this.threadGroup, true);
                                            ResourceProxy resourceProxy2 = ResourceProxy.load(uRL, null);
                                            resourceProxy2.loadJar(uRL);
                                            classContext.addCargo(resourceProxy);
                                            ((Vector)object2).add(classContext);
                                        }
                                        catch (MalformedURLException malformedURLException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        this.m_class_path_jars = object2;
                    }
                    object2 = this.m_class_path_jars.elements();
                    while (object2.hasMoreElements()) {
                        object = (ClassContext)object2.nextElement();
                        try {
                            clazz = object.loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (null == clazz) {
                        throw new ClassNotFoundException("ClassContext.loadClass - class not found: " + string + " " + this.codeBase);
                    }
                }
                catch (ClassFormatError classFormatError) {
                    throw new ClassNotFoundException("ClassContext.loadClass - ClassFormatError: " + classFormatError + " " + string + " " + this.codeBase);
                }
            }
        }
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public synchronized void dispose() {
        if (this.threadGroup != null) {
            this.threadGroup.list();
            new Thread((Runnable)new ThreadGroupKiller(this.threadGroup), this.codeBase.toString() + " killer thread").start();
            this.threadGroup = null;
        }
    }

    private void printHeader(byte[] byArray) {
        System.err.print("#### ClassContext.loadClass - bytes header:");
        int n = 0;
        while (n < 4) {
            System.err.print(" " + Integer.toHexString(byArray[n] & 0xFF));
            ++n;
        }
        System.err.println();
    }

    public ClassLoader getClassLoader() {
        return this;
    }

    static class ThreadGroupKiller
    implements Runnable {
        ThreadGroup threadGroup = null;

        ThreadGroupKiller(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        public void run() {
            try {
                this.threadGroup.stop();
                this.threadGroup.destroy();
            }
            catch (Exception exception) {}
        }
    }
}

